/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.lola.view;

import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import org.baderlab.brain.BrainAlgorithm;
import org.baderlab.brain.PWMToProfileReader;
import org.baderlab.brain.PeptideToProfileReader;
import org.baderlab.brain.ProteinProfile;
import org.baderlab.lola.LolaParameterSet;
import org.baderlab.lola.model.LogoGenerator;
import org.baderlab.lola.model.Profile;
import org.baderlab.lola.model.ProfileSet;

public class GenerateLogoTask
implements Task {
    private TaskMonitor taskMonitor = null;
    BrainAlgorithm alg = null;
    ProfileSet profileSet;
    LolaParameterSet paramSet;

    public GenerateLogoTask(ProfileSet profileSet, LolaParameterSet paramSet) {
        this.profileSet = profileSet;
        this.paramSet = paramSet;
        this.alg = new BrainAlgorithm();
    }

    public void run() {
        if (this.taskMonitor == null) {
            throw new IllegalStateException("Task Monitor is not set.");
        }
        this.alg.setTaskMonitor(this.taskMonitor);
        this.taskMonitor.setStatus("Loading profiles");
        List profileList = null;
        try {
            profileList = PeptideToProfileReader.readPeptidesAsProfiles((File)this.paramSet.getProfileFile(), (double)this.paramSet.getFuzzFactor(), (File)this.paramSet.getCodonBiasFile(), (boolean)this.paramSet.getUniquePeptides(), (boolean)true);
        }
        catch (Exception e) {
            profileList = PWMToProfileReader.readPWMsAsProfiles((File)this.paramSet.getProfileFile(), (File)this.paramSet.getCodonBiasFile());
        }
        this.profileSet.clear();
        this.taskMonitor.setStatus("Drawing logos");
        for (int i = 0; i < profileList.size(); ++i) {
            ProteinProfile proteinProfile = (ProteinProfile)profileList.get(i);
            BufferedImage image = LogoGenerator.generateImage(proteinProfile, this.paramSet, "_logo");
            Profile profile = new Profile();
            profile.set(proteinProfile);
            profile.setImage(image);
            this.profileSet.addElement(profile);
        }
    }

    public void halt() {
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) throws IllegalThreadStateException {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Generating Sequence Logos");
    }
}

