/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.baderlab.brain.LogoSizeSpecification;
import org.baderlab.brain.ProteinProfile;
import org.baderlab.brain.WebLogoProteinStyle;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dp.SimpleWeightMatrix;
import org.biojava.bio.gui.DistributionLogo;
import org.biojava.bio.gui.LogoPainter;
import org.biojava.bio.gui.SymbolStyle;
import org.biojava.bio.gui.TextLogoPainter;

public class ProteinSequenceLogo {
    private ProteinProfile profile = null;
    private int sequenceLogoStartIndex = 1;
    private boolean trimLogo = false;
    private double trimLogoPercentage = 0.1;
    private int logoHeight = 240;
    private LogoSizeSpecification logoSpec = null;
    private boolean drawAxisLabels = false;

    public ProteinSequenceLogo(ProteinProfile profile, int logoHeight) {
        this.profile = profile;
        this.trimLogo = false;
        this.logoSpec = new LogoSizeSpecification(this, profile, logoHeight);
    }

    public ProteinSequenceLogo(ProteinProfile profile, int logoHeight, boolean drawAxisLabels) {
        this(profile, logoHeight);
        System.out.println("*drawAxisLabels: " + drawAxisLabels);
        this.drawAxisLabels = drawAxisLabels;
    }

    public ProteinSequenceLogo(ProteinProfile profile, double trimLogoPercentage, int logoHeight) {
        this.profile = profile;
        this.trimLogoPercentage = trimLogoPercentage;
        this.trimLogo = true;
        this.logoHeight = logoHeight;
        this.logoSpec = new LogoSizeSpecification(this, profile, this.logoHeight);
    }

    public ProteinSequenceLogo(ProteinProfile profile, double trimLogoPercentage, int logoHeight, boolean drawAxisLabels) {
        this(profile, trimLogoPercentage, logoHeight);
        this.drawAxisLabels = drawAxisLabels;
    }

    public void sequenceLogoSetStartIndex(int startIndex) {
        this.sequenceLogoStartIndex = startIndex;
    }

    public boolean isTrimLogo() {
        return this.trimLogo;
    }

    public double getTrimLogoPercentage() {
        return this.trimLogoPercentage;
    }

    public LogoSizeSpecification getDetailedLogoSizeSpecification() {
        return this.logoSpec;
    }

    public int getLogoHeight() {
        return this.logoHeight;
    }

    public int getLogoWidth() {
        return (int)this.logoSpec.logoWidth;
    }

    public BufferedImage drawSequenceLogo() {
        BufferedImage bi = new BufferedImage((int)this.logoSpec.logoWidth, (int)this.logoSpec.logoHeight, 1);
        Graphics2D graphics = bi.createGraphics();
        graphics.setBackground(Color.WHITE);
        graphics.setColor(Color.WHITE);
        graphics.clearRect(0, 0, (int)this.logoSpec.logoWidth, (int)this.logoSpec.logoHeight);
        this.drawSequenceLogo(graphics, null);
        return bi;
    }

    public BufferedImage drawSequenceLogo(SymbolStyle symbolColorStyle) {
        BufferedImage bi = new BufferedImage((int)this.logoSpec.logoWidth, (int)this.logoSpec.logoHeight, 1);
        Graphics2D graphics = bi.createGraphics();
        graphics.setBackground(Color.WHITE);
        graphics.setColor(Color.WHITE);
        graphics.clearRect(0, 0, (int)this.logoSpec.logoWidth, (int)this.logoSpec.logoHeight);
        this.drawSequenceLogo(graphics, null, symbolColorStyle);
        return bi;
    }

    public void saveAsPDF(OutputStream out, SymbolStyle symbolColorStyle) throws IOException {
        Rectangle pagesize = new Rectangle((float)this.logoSpec.logoWidth, (float)this.logoSpec.logoHeight);
        Document document = new Document(pagesize, 50.0f, 50.0f, 50.0f, 50.0f);
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)out);
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate((float)this.logoSpec.logoWidth, (float)this.logoSpec.logoHeight);
            Graphics2D graphics = tp.createGraphics((float)this.logoSpec.logoWidth, (float)this.logoSpec.logoHeight, (FontMapper)new DefaultFontMapper());
            graphics.setBackground(Color.WHITE);
            graphics.setColor(Color.WHITE);
            graphics.clearRect(0, 0, (int)this.logoSpec.logoWidth, (int)this.logoSpec.logoHeight);
            if (symbolColorStyle == null) {
                this.drawSequenceLogo(graphics, null);
            } else {
                this.drawSequenceLogo(graphics, null, symbolColorStyle);
            }
            graphics.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
        }
        catch (DocumentException de) {
            System.err.println(de.getMessage());
        }
        document.close();
    }

    public void drawSequenceLogo(Graphics2D g, Point center) {
        this.drawSequenceLogo(g, center, new WebLogoProteinStyle());
    }

    public void drawSequenceLogo(Graphics2D g, Point center, SymbolStyle symbolColorStyle) {
        int logoWidth = (int)this.logoSpec.logoWidth;
        int logoHeight = (int)this.logoSpec.logoHeight;
        int columnWidth = (int)this.logoSpec.columnWidth;
        int columnHeight = (int)this.logoSpec.columnHeight;
        SimpleWeightMatrix wm = this.profile.getWeightMatrix();
        JPanel logoPanel = new JPanel(new GridLayout(1, this.logoSpec.numberOfColumns));
        Dimension logoPanelSize = new Dimension(columnWidth * this.logoSpec.numberOfColumns, columnHeight);
        logoPanel.setPreferredSize(logoPanelSize);
        logoPanel.setOpaque(false);
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            for (int pos = this.logoSpec.minColumnIndex; pos <= this.logoSpec.maxColumnIndex; ++pos) {
                Distribution dist = wm.getColumn(pos);
                DistributionLogo dl = new DistributionLogo();
                dl.setPreferredSize(new Dimension(columnWidth, columnHeight));
                dl.setRenderingHints(hints);
                dl.setOpaque(false);
                dl.setDistribution(dist);
                dl.setLogoPainter((LogoPainter)new TextLogoPainter());
                dl.setStyle(symbolColorStyle);
                logoPanel.add((Component)dl);
            }
        }
        catch (BioException ex) {
            throw new BioError((Throwable)ex);
        }
        LogoAxisPanel axisPanel = new LogoAxisPanel();
        axisPanel.setLogoSizeSpecification(this.logoSpec);
        axisPanel.setTitle(this.profile.getName() + " (" + this.profile.getNumSequences() + " peptides)");
        Dimension axisPanelSize = new Dimension(logoWidth, logoHeight);
        axisPanel.setPreferredSize(axisPanelSize);
        axisPanel.setOpaque(false);
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setPreferredSize(axisPanelSize);
        panel.setLayout(null);
        axisPanel.setBounds(0, 0, (int)axisPanelSize.getWidth(), (int)axisPanelSize.getHeight());
        panel.add(axisPanel);
        logoPanel.setBounds((int)(axisPanelSize.getWidth() - logoPanelSize.getWidth()), 0, (int)logoPanelSize.getWidth(), (int)logoPanelSize.getHeight());
        panel.add(logoPanel);
        AffineTransform at = null;
        if (center != null) {
            at = g.getTransform();
            g.translate(center.getX() - (double)(logoWidth / 2), center.getY() - (double)(logoHeight / 2));
        }
        JFrame frame = new JFrame();
        frame.getContentPane().add(panel);
        frame.pack();
        panel.print(g);
        frame.dispose();
        if (at != null) {
            g.setTransform(at);
        }
    }

    private void drawRotatedString(String string, Graphics2D g, int x, int y) {
        TextLayout layout = new TextLayout(string, g.getFont(), g.getFontRenderContext());
        AffineTransform startMatrix = g.getTransform();
        g.translate(x, y);
        g.rotate(-1.5707963267948966);
        layout.draw(g, -layout.getAdvance() / 2.0f, 0.0f);
        g.setTransform(startMatrix);
    }

    private class LogoAxisPanel
    extends JComponent {
        private LogoSizeSpecification logoSpec = null;
        private String title = null;

        private LogoAxisPanel() {
        }

        public void setLogoSizeSpecification(LogoSizeSpecification logoSpec) {
            this.logoSpec = logoSpec;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        protected void paintComponent(Graphics gOrig) {
            Graphics2D g = (Graphics2D)gOrig;
            int logoWidth = (int)this.logoSpec.logoWidth;
            int logoHeight = (int)this.logoSpec.logoHeight;
            int padLeft = (int)this.logoSpec.padLeft;
            int padBottom = (int)this.logoSpec.padBottom;
            int columnWidth = (int)this.logoSpec.columnWidth;
            int columnHeight = (int)this.logoSpec.columnHeight;
            Dimension panelSize = new Dimension(logoWidth, logoHeight);
            int columnLabelPadding = 2;
            System.out.println("drawAxisLabels: " + ProteinSequenceLogo.this.drawAxisLabels);
            if (ProteinSequenceLogo.this.drawAxisLabels) {
                g.setColor(Color.BLACK);
                g.setFont(new Font("Dialog", 1, (int)this.logoSpec.fontSize));
                int yAxisOffset = 3;
                int yAxisTickLength = (int)this.logoSpec.yAxisTickLength;
                int tickLabelPadding = 2;
                int labelWidth = 0;
                g.drawLine(padLeft - yAxisOffset, 0, padLeft - yAxisOffset, columnHeight);
                double maxBits = Math.log(this.logoSpec.sequenceAlphabetSize) / Math.log(2.0);
                int i = 0;
                while ((double)i < maxBits) {
                    int tickLabelXOffset;
                    int y = (int)((double)columnHeight - (double)(i * columnHeight) / maxBits);
                    g.drawLine(padLeft - yAxisTickLength, y, padLeft - yAxisOffset, y);
                    FontMetrics f = g.getFontMetrics();
                    String tickLabel = Integer.toString(i);
                    labelWidth = tickLabelXOffset = (int)f.getStringBounds(tickLabel, g).getWidth();
                    LineMetrics l = f.getLineMetrics(tickLabel, g);
                    int tickLabelYOffset = (int)Math.floor(l.getAscent() / 2.0f);
                    g.drawString(tickLabel, padLeft - yAxisTickLength - tickLabelXOffset - tickLabelPadding, y + tickLabelYOffset);
                    ++i;
                }
                String yAxisLabel = "bits";
                int yAxisLabelXPos = padLeft - yAxisTickLength - labelWidth - tickLabelPadding * 2;
                int yAxisLabelYPos = columnHeight / 2;
                ProteinSequenceLogo.this.drawRotatedString(yAxisLabel, g, yAxisLabelXPos, yAxisLabelYPos);
            }
            for (int i = this.logoSpec.minColumnIndex; i <= this.logoSpec.maxColumnIndex; ++i) {
                String columnLabel = Integer.toString(ProteinSequenceLogo.this.sequenceLogoStartIndex + i);
                int x = padLeft + columnWidth / 2 + (i - this.logoSpec.minColumnIndex) * columnWidth;
                int y = columnHeight + columnLabelPadding;
                FontMetrics f = g.getFontMetrics();
                Rectangle2D stringBounds = f.getStringBounds(columnLabel, g);
                LineMetrics l = f.getLineMetrics(columnLabel, g);
                if (stringBounds.getWidth() >= (double)columnWidth) {
                    if (stringBounds.getWidth() >= (double)padBottom) {
                        AffineTransform startMatrix = g.getTransform();
                        double scaleFactor = (double)padBottom / stringBounds.getWidth();
                        g.scale(scaleFactor, scaleFactor);
                        y = (int)((double)y + stringBounds.getWidth() / 2.0 * scaleFactor);
                        x = (int)((double)x + (double)(l.getAscent() / 2.0f) * scaleFactor);
                        ProteinSequenceLogo.this.drawRotatedString(columnLabel, g, (int)((double)x / scaleFactor), (int)((double)y / scaleFactor));
                        g.setTransform(startMatrix);
                        continue;
                    }
                    y = (int)((double)y + stringBounds.getWidth() / 2.0);
                    x = (int)((float)x + l.getAscent() / 2.0f);
                    ProteinSequenceLogo.this.drawRotatedString(columnLabel, g, x, y);
                    continue;
                }
                y = (int)((float)y + l.getAscent());
                x = (int)((double)x - stringBounds.getWidth() / 2.0);
                g.drawString(columnLabel, x, y);
            }
            if (this.title != null && ProteinSequenceLogo.this.drawAxisLabels) {
                int padTitle = 3;
                FontMetrics f = g.getFontMetrics();
                Rectangle2D stringBounds = f.getStringBounds(this.title, g);
                g.drawString(this.title, (int)(panelSize.getWidth() / 2.0 - stringBounds.getWidth() / 2.0), (int)panelSize.getHeight() - padTitle);
            }
        }
    }
}

