/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.baderlab.brain.DatabaseReference;
import org.baderlab.brain.ProfileAlignment;
import org.baderlab.brain.ProteinSequenceUtil;
import org.baderlab.brain.ProteinTerminus;
import org.baderlab.brain.sequencelogo.SequenceLogoDistributionTools;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dist.DistributionTools;
import org.biojava.bio.dp.SimpleWeightMatrix;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleAlignment;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;

public class ProteinProfile {
    private SimpleWeightMatrix weightMatrix = null;
    private double fuzzFactor = 0.0;
    private String name = null;
    private int numSequences = 0;
    private double profileMinPValue = 0.0;
    private double profileMaxPValue = 0.0;
    private String experimentalMethod = null;
    private DatabaseReference proteinReference = null;
    private ArrayList proteinXrefList = null;
    private int domainNumber = 0;
    private DatabaseReference domainReference = null;
    private String domainName = null;
    private String domainSequence = null;
    private int domainSequenceStart = 0;
    private int domainSequenceStop = 0;
    private String comment = null;
    private String proteinName = null;
    private Map sequenceMap = null;
    private ArrayList alphabet = null;
    private String organism = "";
    private static double bits = Math.log(2.0);

    public ProteinProfile(SequenceIterator trainingSequences) throws BioException {
        this(trainingSequences, 0.0, null, false);
    }

    public ProteinProfile(SequenceIterator trainingSequences, double fuzzFactor, String name) throws BioException {
        this.fuzzFactor = fuzzFactor;
        this.alphabet = this.get20aaAlphabet();
        this.buildProfile(trainingSequences);
        this.name = name;
    }

    public ProteinProfile(SequenceIterator trainingSequences, double fuzzFactor, String name, boolean useSequenceLogoDistribution) throws BioException {
        this.fuzzFactor = fuzzFactor;
        this.alphabet = this.get20aaAlphabet();
        this.buildProfile(trainingSequences, useSequenceLogoDistribution);
        this.name = name;
    }

    public ProteinProfile(List profileList, String name) {
        this.fuzzFactor = 0.0;
        this.alphabet = this.get20aaAlphabet();
        this.name = name;
        this.numSequences = 0;
        try {
            ProteinProfile proteinProfile = (ProteinProfile)profileList.get(0);
            SimpleAlignment align = new SimpleAlignment(proteinProfile.sequenceMap);
            Distribution[] dists = DistributionTools.distOverAlignment((Alignment)align, (boolean)false, (double)this.fuzzFactor);
            this.weightMatrix = new SimpleWeightMatrix(dists);
            this.normalize();
            this.numSequences += proteinProfile.getNumSequences();
        }
        catch (IllegalAlphabetException e) {
            e.printStackTrace();
        }
        for (int i = 1; i < profileList.size(); ++i) {
            ProteinProfile proteinProfile = (ProteinProfile)profileList.get(i);
            SimpleWeightMatrix wm2 = proteinProfile.getWeightMatrix();
            double weight = 0.0;
            for (int j = 0; j < this.weightMatrix.columns(); ++j) {
                Distribution column1 = this.weightMatrix.getColumn(j);
                Distribution column2 = wm2.getColumn(j);
                for (Symbol symbol : this.alphabet) {
                    try {
                        weight = column1.getWeight(symbol) + column2.getWeight(symbol);
                        if (i != profileList.size() - 1) {
                            column1.setWeight(symbol, weight);
                            continue;
                        }
                        column1.setWeight(symbol, weight / (double)profileList.size());
                    }
                    catch (IllegalSymbolException e) {
                        e.printStackTrace();
                    }
                    catch (ChangeVetoException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.numSequences += proteinProfile.getNumSequences();
        }
        this.calculateMinMaxPValues();
    }

    public ProteinProfile(List profileList, String name, ProfileAlignment profileAlignment) {
        this.fuzzFactor = 0.0;
        this.alphabet = this.get20aaAlphabet();
        this.name = name;
        this.numSequences = 0;
        if (profileAlignment == null) {
            try {
                ProteinProfile proteinProfile = (ProteinProfile)profileList.get(0);
                SimpleAlignment align = new SimpleAlignment(proteinProfile.sequenceMap);
                Distribution[] dists = DistributionTools.distOverAlignment((Alignment)align, (boolean)false, (double)this.fuzzFactor);
                this.weightMatrix = new SimpleWeightMatrix(dists);
                this.normalize();
                this.numSequences += proteinProfile.getNumSequences();
            }
            catch (IllegalAlphabetException e) {
                e.printStackTrace();
            }
            for (int i = 1; i < profileList.size(); ++i) {
                ProteinProfile proteinProfile = (ProteinProfile)profileList.get(i);
                SimpleWeightMatrix wm2 = proteinProfile.getWeightMatrix();
                double weight = 0.0;
                for (int j = 0; j < this.weightMatrix.columns(); ++j) {
                    Distribution column1 = this.weightMatrix.getColumn(j);
                    Distribution column2 = wm2.getColumn(j);
                    for (Symbol symbol : this.alphabet) {
                        try {
                            weight = column1.getWeight(symbol) + column2.getWeight(symbol);
                            if (i != profileList.size() - 1) {
                                column1.setWeight(symbol, weight);
                                continue;
                            }
                            column1.setWeight(symbol, weight / (double)profileList.size());
                        }
                        catch (IllegalSymbolException e) {
                            e.printStackTrace();
                        }
                        catch (ChangeVetoException e) {
                            e.printStackTrace();
                        }
                    }
                }
                this.numSequences += proteinProfile.getNumSequences();
            }
        } else {
            int numColumns = 0;
            int minPosition = Integer.MAX_VALUE;
            for (int i = 0; i < profileList.size(); ++i) {
                ProteinProfile proteinProfile = (ProteinProfile)profileList.get(i);
                int position = profileAlignment.getAbsoluteAlignmentPosition(proteinProfile);
                numColumns = Math.max(numColumns, position + proteinProfile.getNumColumns());
                minPosition = Math.min(minPosition, position);
            }
            numColumns -= minPosition;
            try {
                int i;
                ProteinProfile tempProfile = (ProteinProfile)profileList.get(0);
                Distribution[] dists = new Distribution[numColumns];
                for (i = 0; i < numColumns; ++i) {
                    dists[i] = DistributionFactory.DEFAULT.createDistribution(tempProfile.getWeightMatrix().getAlphabet());
                }
                this.weightMatrix = new SimpleWeightMatrix(dists);
                for (i = 0; i < this.weightMatrix.columns(); ++i) {
                    Distribution column = this.weightMatrix.getColumn(i);
                    for (Symbol symbol : (FiniteAlphabet)this.weightMatrix.getColumn(0).getAlphabet()) {
                        column.setWeight(symbol, 0.0);
                    }
                }
                for (i = 0; i < profileList.size(); ++i) {
                    ProteinProfile proteinProfile = (ProteinProfile)profileList.get(i);
                    int position = profileAlignment.getAbsoluteAlignmentPosition(proteinProfile);
                    for (int j = 0; j < proteinProfile.getNumColumns(); ++j) {
                        Distribution avgColumn = this.weightMatrix.getColumn(position + j - minPosition);
                        Distribution profileColumn = proteinProfile.getWeightMatrix().getColumn(j);
                        for (Symbol symbol : this.alphabet) {
                            double weight = 0.0;
                            try {
                                weight = avgColumn.getWeight(symbol) + profileColumn.getWeight(symbol);
                                if (i != profileList.size() - 1) {
                                    avgColumn.setWeight(symbol, weight);
                                    continue;
                                }
                                avgColumn.setWeight(symbol, weight / (double)profileList.size());
                            }
                            catch (IllegalSymbolException e) {
                                e.printStackTrace();
                            }
                            catch (ChangeVetoException e) {
                                e.printStackTrace();
                            }
                            catch (BioException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    this.numSequences += proteinProfile.getNumSequences();
                }
            }
            catch (IllegalAlphabetException e) {
                e.printStackTrace();
            }
            catch (BioException e) {
                e.printStackTrace();
            }
            catch (ChangeVetoException e) {
                e.printStackTrace();
            }
        }
        this.calculateMinMaxPValues();
    }

    public ProteinProfile(SimpleWeightMatrix weightMatrix, String name) {
        this.weightMatrix = weightMatrix;
        this.name = name;
        this.fuzzFactor = 0.0;
        this.alphabet = this.get20aaAlphabet();
        this.numSequences = 0;
        this.normalize();
    }

    private ArrayList get20aaAlphabet() {
        ArrayList<Symbol> alphabet = new ArrayList<Symbol>(20);
        HashMap alphabetMap = ProteinSequenceUtil.get20aaAlphabet();
        Collection symbols = alphabetMap.values();
        for (Symbol symbol : symbols) {
            alphabet.add(symbol);
        }
        return alphabet;
    }

    private void buildProfile(SequenceIterator trainingSequences) throws BioException {
        this.buildProfile(trainingSequences, false);
    }

    private void buildProfile(SequenceIterator trainingSequences, boolean useSequenceLogoDistribution) throws BioException {
        this.numSequences = 0;
        this.sequenceMap = new HashMap();
        while (trainingSequences.hasNext()) {
            Sequence sequence = null;
            sequence = trainingSequences.nextSequence();
            this.sequenceMap.put(sequence.getName(), sequence);
            ++this.numSequences;
        }
        SimpleAlignment align = new SimpleAlignment(this.sequenceMap);
        Distribution[] dists = null;
        dists = useSequenceLogoDistribution ? SequenceLogoDistributionTools.distOverAlignment((Alignment)align, false, this.fuzzFactor) : DistributionTools.distOverAlignment((Alignment)align, (boolean)false, (double)this.fuzzFactor);
        this.weightMatrix = new SimpleWeightMatrix(dists);
        this.normalize();
        this.calculateMinMaxPValues();
    }

    private void calculateMinMaxPValues() {
        if (this.alphabet == null) {
            throw new IllegalStateException("Alphabet not set in ProteinProfile.");
        }
        double weight = 0.0;
        this.profileMinPValue = 1.0;
        this.profileMaxPValue = 1.0;
        for (int i = 0; i < this.weightMatrix.columns(); ++i) {
            Distribution column = this.weightMatrix.getColumn(i);
            Iterator symbolIterator = this.alphabet.iterator();
            double columnMinPValue = Double.MAX_VALUE;
            double columnMaxPValue = Double.MIN_VALUE;
            while (symbolIterator.hasNext()) {
                Symbol symbol = (Symbol)symbolIterator.next();
                try {
                    weight = column.getWeight(symbol);
                }
                catch (IllegalSymbolException e) {
                    e.printStackTrace();
                }
                columnMinPValue = Math.min(columnMinPValue, weight);
                columnMaxPValue = Math.max(columnMaxPValue, weight);
            }
            this.profileMinPValue *= columnMinPValue;
            this.profileMaxPValue *= columnMaxPValue;
        }
    }

    public SimpleWeightMatrix getWeightMatrix() {
        return this.weightMatrix;
    }

    public String getName() {
        return this.name;
    }

    public int getNumColumns() {
        return this.weightMatrix.columns();
    }

    public int getNumSequences() {
        return this.numSequences;
    }

    public String getOrganism() {
        return this.organism;
    }

    public double getNormalizedPValue(double pvalue) {
        double normalizedPValue = (pvalue - this.profileMinPValue) / (this.profileMaxPValue - this.profileMinPValue);
        return normalizedPValue;
    }

    public void normalize() {
        if (this.alphabet == null) {
            throw new IllegalStateException("Alphabet not set in ProteinProfile.");
        }
        SimpleWeightMatrix wm = this.getWeightMatrix();
        try {
            for (int i = 0; i < wm.columns(); ++i) {
                Distribution d = wm.getColumn(i);
                double weightSum = 0.0;
                for (Symbol symbol : this.alphabet) {
                    weightSum += d.getWeight(symbol);
                }
                for (Symbol symbol : this.alphabet) {
                    d.setWeight(symbol, d.getWeight(symbol) / weightSum);
                }
            }
        }
        catch (BioException e) {
            e.printStackTrace();
        }
        catch (ChangeVetoException e) {
            e.printStackTrace();
        }
    }

    public void reWeightByNNKCodonBias() {
        if (this.alphabet == null) {
            throw new IllegalStateException("Alphabet not set in ProteinProfile.");
        }
        String aaList = "ACDEFGHIKLMNPQRSTVWY";
        int[] codonBias = new int[]{2, 1, 1, 1, 1, 2, 1, 1, 1, 3, 1, 1, 2, 1, 3, 3, 2, 2, 1, 1};
        SimpleWeightMatrix wm = this.getWeightMatrix();
        try {
            for (int i = 0; i < wm.columns(); ++i) {
                Distribution d = wm.getColumn(i);
                double weight = 0.0;
                for (Symbol symbol : this.alphabet) {
                    String symbolString = ProteinTools.getAlphabet().getTokenization("token").tokenizeSymbol(symbol);
                    if (symbolString.equals("U")) continue;
                    weight = d.getWeight(symbol) / (double)codonBias["ACDEFGHIKLMNPQRSTVWY".indexOf(symbolString)];
                    d.setWeight(symbol, weight);
                }
            }
        }
        catch (BioException e) {
            e.printStackTrace();
        }
        catch (ChangeVetoException e) {
            e.printStackTrace();
        }
        this.normalize();
        this.calculateMinMaxPValues();
    }

    public void reWeightByCodonBias(File codonBiasFile) {
        if (this.alphabet == null) {
            throw new IllegalStateException("Alphabet not set in ProteinProfile.");
        }
        String aaList = "ACDEFGHIKLMNPQRSTVWYX";
        double[] codonBias = new double["ACDEFGHIKLMNPQRSTVWYX".length()];
        try {
            BufferedReader br = new BufferedReader(new FileReader(codonBiasFile));
            String fileLine = null;
            while ((fileLine = br.readLine()) != null) {
                String[] aaBiasString = fileLine.split("\\t");
                if (aaBiasString.length == 2) {
                    String residue = aaBiasString[0];
                    codonBias["ACDEFGHIKLMNPQRSTVWYX".indexOf((String)residue)] = Double.parseDouble(aaBiasString[1]);
                    continue;
                }
                System.out.println("Codon bias file is malformed.  Expecting two tab-delimited columns, but found " + fileLine);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SimpleWeightMatrix wm = this.getWeightMatrix();
        try {
            for (int i = 0; i < wm.columns(); ++i) {
                Distribution d = wm.getColumn(i);
                double weight = 0.0;
                for (Symbol symbol : this.alphabet) {
                    String symbolString = ProteinTools.getAlphabet().getTokenization("token").tokenizeSymbol(symbol);
                    if (symbolString.equals("U") || symbolString.equals("O")) continue;
                    weight = d.getWeight(symbol) / codonBias["ACDEFGHIKLMNPQRSTVWYX".indexOf(symbolString)];
                    d.setWeight(symbol, weight);
                }
            }
        }
        catch (BioException e) {
            e.printStackTrace();
        }
        catch (ChangeVetoException e) {
            e.printStackTrace();
        }
        this.normalize();
        this.calculateMinMaxPValues();
    }

    public ProteinProfile getTruncatedProfileCopy(int profileLength, ProteinTerminus terminus) {
        if (profileLength >= this.getNumColumns()) {
            return this;
        }
        int loopStart = 0;
        int loopEnd = 0;
        if (terminus.equals(ProteinTerminus.C)) {
            loopStart = this.getNumColumns() - profileLength;
            loopEnd = this.getNumColumns();
        } else if (terminus.equals(ProteinTerminus.N)) {
            loopStart = 0;
            loopEnd = profileLength;
        } else {
            throw new RuntimeException("Protein terminus must be either C or N to decide on a profile cut.");
        }
        ProteinProfile cutProfile = this.getProfileSubsetCopy(loopStart + "-" + loopEnd);
        return cutProfile;
    }

    public ProteinProfile getProfileSubsetCopy(String filter) {
        if (filter == null || filter.equals("")) {
            return null;
        }
        ArrayList<Integer> columnsToKeep = new ArrayList<Integer>();
        String[] positions = filter.split(",");
        for (int i = 0; i < positions.length; ++i) {
            String position = positions[i];
            if (position.indexOf("-") > 0) {
                String[] startEnd = position.split("-");
                int start = Integer.parseInt(startEnd[0]);
                int end = Integer.parseInt(startEnd[1]);
                for (int j = start; j <= end; ++j) {
                    columnsToKeep.add(new Integer(j));
                }
                continue;
            }
            int point = Integer.parseInt(position);
            columnsToKeep.add(new Integer(point));
        }
        Distribution[] distArray = new Distribution[columnsToKeep.size()];
        int j = 0;
        for (int i = 0; i < this.getNumColumns(); ++i) {
            if (!columnsToKeep.contains(new Integer(i))) continue;
            distArray[j] = this.weightMatrix.getColumn(i);
            ++j;
        }
        ProteinProfile cutProfile = null;
        try {
            SimpleWeightMatrix newWM = new SimpleWeightMatrix(distArray);
            cutProfile = new ProteinProfile(newWM, this.getName());
        }
        catch (IllegalAlphabetException e) {
            e.printStackTrace();
        }
        catch (BioException e) {
            e.printStackTrace();
        }
        return cutProfile;
    }

    private double entropy(Distribution dist, Symbol s) throws IllegalSymbolException {
        double p = dist.getWeight(s);
        if (p == 0.0) {
            return 0.0;
        }
        double lp = Math.log(p);
        return -p * lp / bits;
    }

    private double totalBits(Distribution dist) {
        return Math.log(20.0) / bits;
    }

    private double totalInformation(Distribution dist) {
        double inf = this.totalBits(dist);
        for (Symbol s : (FiniteAlphabet)dist.getAlphabet()) {
            try {
                inf -= this.entropy(dist, s);
            }
            catch (IllegalSymbolException ire) {
                throw new BioError("Symbol evaporated while calculating information", (Throwable)ire);
            }
        }
        return inf;
    }

    public double calculateSpecificityScore() {
        double score = 1.0;
        SimpleWeightMatrix wm = this.getWeightMatrix();
        for (int pos = 0; pos < wm.columns(); ++pos) {
            Distribution dist = wm.getColumn(pos);
            double informationAtPosition = this.totalInformation(dist);
            score *= Math.pow(2.0, informationAtPosition);
        }
        return score;
    }

    public ProteinProfile getTrimmedProfileCopy(double trimPercentage) {
        SimpleWeightMatrix wm = this.getWeightMatrix();
        int minColumnIndex = Integer.MAX_VALUE;
        int maxColumnIndex = Integer.MIN_VALUE;
        double bits = Math.log(20.0) / Math.log(2.0);
        for (int pos = 0; pos < wm.columns(); ++pos) {
            Distribution dist = wm.getColumn(pos);
            double informationBits = DistributionTools.bitsOfInformation((Distribution)dist);
            double informationPercentage = informationBits / bits;
            if (!(trimPercentage < informationPercentage)) continue;
            minColumnIndex = Math.min(minColumnIndex, pos);
            maxColumnIndex = Math.max(maxColumnIndex, pos);
        }
        if (minColumnIndex == Integer.MAX_VALUE || maxColumnIndex == Integer.MIN_VALUE) {
            return this;
        }
        return this.getProfileSubsetCopy(minColumnIndex + "-" + maxColumnIndex);
    }

    public int getNumberOfLeftTrimmedColumns(double trimPercentage) {
        SimpleWeightMatrix wm = this.getWeightMatrix();
        int minColumnIndex = Integer.MAX_VALUE;
        int maxColumnIndex = Integer.MIN_VALUE;
        double bits = Math.log(20.0) / Math.log(2.0);
        for (int pos = 0; pos < wm.columns(); ++pos) {
            Distribution dist = wm.getColumn(pos);
            double informationBits = DistributionTools.bitsOfInformation((Distribution)dist);
            double informationPercentage = informationBits / bits;
            if (!(trimPercentage < informationPercentage)) continue;
            minColumnIndex = Math.min(minColumnIndex, pos);
            maxColumnIndex = Math.max(maxColumnIndex, pos);
        }
        if (minColumnIndex == Integer.MAX_VALUE) {
            return 0;
        }
        return minColumnIndex - 1;
    }

    public int getNumberOfRightTrimmedColumns(double trimPercentage) {
        SimpleWeightMatrix wm = this.getWeightMatrix();
        int minColumnIndex = Integer.MAX_VALUE;
        int maxColumnIndex = Integer.MIN_VALUE;
        double bits = Math.log(20.0) / Math.log(2.0);
        for (int pos = 0; pos < wm.columns(); ++pos) {
            Distribution dist = wm.getColumn(pos);
            double informationBits = DistributionTools.bitsOfInformation((Distribution)dist);
            double informationPercentage = informationBits / bits;
            if (!(trimPercentage < informationPercentage)) continue;
            minColumnIndex = Math.min(minColumnIndex, pos);
            maxColumnIndex = Math.max(maxColumnIndex, pos);
        }
        if (maxColumnIndex == Integer.MIN_VALUE) {
            return this.weightMatrix.columns() - 1;
        }
        return this.weightMatrix.columns() - maxColumnIndex;
    }

    public String getExperimentalMethod() {
        return this.experimentalMethod;
    }

    public void setExperimentalMethod(String experimentalMethod) {
        this.experimentalMethod = experimentalMethod;
    }

    public ArrayList getProteinXrefList() {
        return this.proteinXrefList;
    }

    public void setProteinXrefList(ArrayList proteinXrefList) {
        this.proteinXrefList = proteinXrefList;
    }

    public DatabaseReference getProteinReference() {
        return this.proteinReference;
    }

    public void setProteinReference(DatabaseReference proteinReference) {
        this.proteinReference = proteinReference;
    }

    public int getDomainNumber() {
        return this.domainNumber;
    }

    public Collection getSequenceMap() {
        if (this.sequenceMap != null) {
            return this.sequenceMap.values();
        }
        return null;
    }

    public Map getSequenceHashMap() {
        return this.sequenceMap;
    }

    public void setSequenceMap(Collection sequences) throws BioException {
        this.numSequences = 0;
        this.sequenceMap = new HashMap();
        Iterator iterator = sequences.iterator();
        while (iterator.hasNext()) {
            Sequence sequence = null;
            sequence = (Sequence)iterator.next();
            this.sequenceMap.put(sequence.getName(), sequence);
            ++this.numSequences;
        }
    }

    public void setDomainNumber(int domainNumber) {
        this.domainNumber = domainNumber;
    }

    public DatabaseReference getDomainReference() {
        return this.domainReference;
    }

    public void setDomainReference(DatabaseReference domainReference) {
        this.domainReference = domainReference;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getDomainSequence() {
        return this.domainSequence;
    }

    public void setDomainSequence(String domainSequence) {
        this.domainSequence = domainSequence;
    }

    public int getDomainSequenceStart() {
        return this.domainSequenceStart;
    }

    public void setDomainSequenceStart(int position) {
        this.domainSequenceStart = position;
    }

    public int getDomainSequenceStop() {
        return this.domainSequenceStop;
    }

    public void setDomainSequenceStop(int position) {
        this.domainSequenceStop = position;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String text) {
        this.comment = text;
    }

    public String getProteinName() {
        return this.proteinName;
    }

    public void setProteinName(String text) {
        this.proteinName = text;
    }

    public void setOrganism(String organism) {
        this.organism = organism;
    }

    public void setNumberSequences(int numSequences) {
        this.numSequences = numSequences;
    }

    public String toString() {
        if (this.weightMatrix == null) {
            System.err.println("Matrix was null in ProteinProfile object. This should never happen.");
            return null;
        }
        if (this.alphabet == null) {
            throw new IllegalStateException("Alphabet not set in ProteinProfile.");
        }
        double[][] simpleMatrix = new double[this.weightMatrix.columns()][this.alphabet.size()];
        for (int i = 0; i < this.weightMatrix.columns(); ++i) {
            Distribution d = this.weightMatrix.getColumn(i);
            Iterator it = this.alphabet.iterator();
            int j = 0;
            while (it.hasNext()) {
                Symbol symbol = (Symbol)it.next();
                try {
                    simpleMatrix[i][j] = d.getWeight(symbol);
                }
                catch (IllegalSymbolException e) {
                    System.err.println("Illegal symbol found in the weight weightMatrix. This should never happen.");
                }
                ++j;
            }
        }
        Iterator it = this.alphabet.iterator();
        SymbolTokenization st = null;
        try {
            st = ProteinTools.getAlphabet().getTokenization("token");
        }
        catch (BioException e) {
            System.err.println("Unable to get symboltokenization. This should never happen.");
        }
        StringBuffer sb = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        for (int i = 0; i < this.alphabet.size(); ++i) {
            String token = null;
            try {
                token = st.tokenizeSymbol((Symbol)it.next());
            }
            catch (IllegalSymbolException e) {
                System.err.println("Unable to convert symbol to token. This should never happen.");
            }
            sb.append(token + "\t");
            for (int j = 0; j < simpleMatrix.length; ++j) {
                sb.append(simpleMatrix[j][i]);
                if (j >= simpleMatrix.length - 1) continue;
                sb.append("\t");
            }
            sb.append(lineSep);
        }
        return sb.toString();
    }
}

