/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain.sequencelogo;

import java.util.List;
import org.baderlab.brain.sequencelogo.SequenceLogoDistributionTrainerContext;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Symbol;

public class SequenceLogoDistributionTools {
    public static final Distribution[] distOverAlignment(Alignment a, boolean countGaps, double nullWeight) throws IllegalAlphabetException {
        List seqs = a.getLabels();
        FiniteAlphabet alpha = (FiniteAlphabet)a.symbolListForLabel(seqs.get(0)).getAlphabet();
        for (int i = 1; i < seqs.size(); ++i) {
            FiniteAlphabet test = (FiniteAlphabet)a.symbolListForLabel(seqs.get(i)).getAlphabet();
            if (test == alpha) continue;
            throw new IllegalAlphabetException("Cannot Calculate distOverAlignment() for alignments withmixed alphabets");
        }
        Distribution[] pos = new Distribution[a.length()];
        SequenceLogoDistributionTrainerContext dtc = new SequenceLogoDistributionTrainerContext();
        dtc.setNullModelWeight(nullWeight);
        double[] adjRatios = null;
        if (countGaps) {
            adjRatios = new double[a.length()];
        }
        try {
            int i;
            for (i = 0; i < a.length(); ++i) {
                double gapCount = 0.0;
                double totalCount = 0.0;
                pos[i] = DistributionFactory.DEFAULT.createDistribution((Alphabet)alpha);
                dtc.registerDistribution(pos[i]);
                for (Object seqLabel : seqs) {
                    Symbol s = a.symbolAt(seqLabel, i + 1);
                    if (s == null) continue;
                    Symbol gap = alpha.getGapSymbol();
                    if (countGaps && s.equals(gap)) {
                        gapCount += 1.0;
                        totalCount += 1.0;
                        continue;
                    }
                    dtc.addCount(pos[i], s, 1.0);
                    totalCount += 1.0;
                }
                if (!countGaps) continue;
                adjRatios[i] = 1.0 - gapCount / totalCount;
            }
            dtc.train();
            if (countGaps) {
                for (i = 0; i < adjRatios.length; ++i) {
                    Distribution d = pos[i];
                    for (Symbol sym : (FiniteAlphabet)d.getAlphabet()) {
                        d.setWeight(sym, d.getWeight(sym) * adjRatios[i]);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return pos;
    }
}

