/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain.correlationlearn;

import mt.MatrixEntry;
import org.baderlab.brain.correlationlearn.ResiduePositionPair;

public class FeatureUtils {
    private static final String aaList = "ACDEFGHIKLMNPQRSTVWY";

    public static int getMaxIndex(int numberOfPositions, int totalPositions) {
        int maxIndex = FeatureUtils.getCombinations(totalPositions, numberOfPositions);
        maxIndex = (int)((double)maxIndex * Math.pow(20.0, numberOfPositions));
        return maxIndex;
    }

    public static ResiduePositionPair[] indexToFeature(int index, ResiduePositionPair[] feature, int sequenceLength) {
        int partitionNumber;
        int tempPartitionNumber = partitionNumber = (int)Math.floor((double)index / Math.pow(aaList.length(), feature.length));
        block0: for (int featurePosition = feature.length; featurePosition > 0; --featurePosition) {
            for (int i = featurePosition - 1; i < sequenceLength; ++i) {
                if (tempPartitionNumber >= FeatureUtils.getCombinations(i + 1, featurePosition)) continue;
                feature[featurePosition - 1].position = i;
                tempPartitionNumber -= FeatureUtils.getCombinations(i, featurePosition);
                continue block0;
            }
        }
        int partitionOffset = partitionNumber * (int)Math.pow(aaList.length(), feature.length);
        int residueOffset = index - partitionOffset;
        for (int i = feature.length - 1; i >= 0; --i) {
            feature[i].residue = aaList.charAt(residueOffset / (int)Math.pow(aaList.length(), i));
            residueOffset %= (int)Math.pow(aaList.length(), i);
        }
        return feature;
    }

    public static boolean featureValid(ResiduePositionPair[] feature) {
        for (int i = 0; i < feature.length; ++i) {
            ResiduePositionPair residuePositionPair = feature[i];
            if (aaList.indexOf(residuePositionPair.residue) >= 0) continue;
            return false;
        }
        return true;
    }

    public static int getFeatureIndex(ResiduePositionPair[] feature) {
        int partitionNumber = 0;
        int residueOffset = 0;
        for (int i = 0; i < feature.length; ++i) {
            partitionNumber += FeatureUtils.getCombinations(feature[i].position, i + 1);
        }
        int partitionOffset = partitionNumber * (int)Math.pow(aaList.length(), feature.length);
        for (int i = 0; i < feature.length; ++i) {
            residueOffset = (int)((double)residueOffset + (double)aaList.indexOf(feature[i].residue) * Math.pow(aaList.length(), i));
        }
        int index = partitionOffset + residueOffset;
        return index;
    }

    public static ResiduePositionPair[] allocateFeature(int numPositionsPerFeature) {
        ResiduePositionPair[] feature = new ResiduePositionPair[numPositionsPerFeature];
        for (int i = 0; i < feature.length; ++i) {
            feature[i] = new ResiduePositionPair(-1, 'X');
        }
        return feature;
    }

    public static ResiduePositionPair[] createFeature(ResiduePositionPair[] feature, int[] positionArray, String sequenceString) {
        for (int i = 0; i < feature.length; ++i) {
            ResiduePositionPair residuePositionPair = feature[i];
            residuePositionPair.position = positionArray[i];
            residuePositionPair.residue = sequenceString.charAt(positionArray[i]);
        }
        return feature;
    }

    public static String featureToString(ResiduePositionPair[] feature) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < feature.length; ++i) {
            sb.append(feature[i].toString());
        }
        return sb.toString();
    }

    public static boolean isFeatureInSequence(ResiduePositionPair[] sequenceFeature, String seqString) {
        for (int i = 0; i < sequenceFeature.length; ++i) {
            ResiduePositionPair residuePositionPair = sequenceFeature[i];
            if (seqString.charAt(residuePositionPair.position) == residuePositionPair.residue) continue;
            return false;
        }
        return true;
    }

    public static int getCombinations(int n, int k) {
        if (k == 1) {
            return n;
        }
        int k1 = k;
        int k2 = n - k;
        if (k1 < k2) {
            k1 = n - k;
            k2 = k;
        }
        int t = 0;
        if (k1 > n) {
            return t;
        }
        t = 1;
        while (k2 > 1) {
            t *= k2--;
        }
        int t2 = 1;
        while (n > k1) {
            t2 *= n--;
        }
        t = t2 / t;
        return t;
    }

    public static double scoreFeature(MatrixEntry matrixEntry, double domainFrequency, double peptideFrequency, double multipleSequenceAlignmentLength) {
        double conditionalEntropy = Math.log(matrixEntry.get() * multipleSequenceAlignmentLength / (domainFrequency * peptideFrequency)) * (matrixEntry.get() / multipleSequenceAlignmentLength);
        return conditionalEntropy;
    }

    public static int[] generateFeaturePositions(int[] positionArray, int totalPositions, boolean initialize) {
        if (!initialize) {
            for (int i = positionArray.length - 1; i >= 0; --i) {
                if (positionArray[i] >= totalPositions - (positionArray.length - i)) continue;
                int n = i;
                positionArray[n] = positionArray[n] + 1;
                for (int j = i + 1; j < positionArray.length; ++j) {
                    positionArray[j] = positionArray[j - 1] + 1;
                }
                break;
            }
        } else {
            for (int i = 0; i < positionArray.length; ++i) {
                positionArray[i] = i;
            }
        }
        return positionArray;
    }
}

