package org.baderlab.lola;

/**
 Copyright 2007 Bader Lab

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU Lesser General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.

 */

/**
 * Singleton class to store the current parameters.
 *
 * User: moyez
 * Date: May 27, 2007
 * Time: 5:22:21 PM
 */

/**
 * Stores the current parameters for Lola.
 */
public class LolaCurrentParameters {
    private static LolaCurrentParameters instance = new LolaCurrentParameters();
    private static LolaParameterSet params = new LolaParameterSet();

    /**
     * Get the sole instance of this singleton class that stores the current parameters internally.
     * @return A LolaCurrentParameters object.
     */
    public static LolaCurrentParameters getInstance() {
        return instance;
    }

    /**
     * Get a copy of the current parameters. Only a copy of the current param object is
     * returned to avoid side effects.  The user should use the following code to get their
     * own copy of the current parameters:
     * LolaCurrentParameters.getInstance().getParamsCopy();
     * <p/>
     * Note: parameters can be changed by the user after you have your own copy,
     * so if you always need the latest, you should get the updated parameters again.
     *
     */
    public LolaParameterSet getParamsCopy() {
        return params.copy();
    }

    /**
     * Current parameters can only be updated using this method.
     *
     * @param paramSet The current parameters to set.
     */
    public void setParams(LolaParameterSet paramSet) {
        params = paramSet;
    }

}
