package org.baderlab.lola.view.actions;

import org.baderlab.lola.model.ProfileSet;
import org.baderlab.lola.model.LogoGenerator;
import org.baderlab.lola.model.Profile;
import org.baderlab.lola.LolaParameterSet;
import org.baderlab.brain.ProfileSearchProjectFile;
import org.baderlab.brain.PeptideToProfileReader;
import org.baderlab.brain.ProteinProfile;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;

/**
 Copyright 2007 Bader Lab

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU Lesser General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.

 */

/**
 * Created by IntelliJ IDEA.
 * User: moyez
 * Date: Jun 25, 2007
 * Time: 6:09:26 PM
 * To change this template use File | Settings | File Templates.
 */

public class SaveLogosToFileAction implements ActionListener {
    private ProfileSet profileSet;
    LolaParameterSet paramSet;

    public SaveLogosToFileAction(ProfileSet profileSet, LolaParameterSet params) {
        super();
        this.profileSet = profileSet;
        this.paramSet = params;

    }

    public void actionPerformed(ActionEvent actionEvent) {
        //save logo image for each profile
        for (int i = 0; i < profileSet.size(); i++) {
            Profile profile = (Profile) profileSet.get(i);
            LogoGenerator.writeLogo(profile, paramSet, "_logo");
        }

    }
}