package org.baderlab.lola.view.actions;

import org.baderlab.lola.model.ProfileSet;
import org.baderlab.lola.model.LogoTree;
import org.baderlab.lola.model.LogoGenerator;
import org.baderlab.lola.LolaParameterSet;
import org.baderlab.lola.resources.LolaResources;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.io.*;

/**
 * Created by IntelliJ IDEA.
 * User: moyez
 * Date: Aug 20, 2007
 * Time: 1:02:11 AM
 * To change this template use File | Settings | File Templates.
 */
public class SaveLogoTreeToFile implements ActionListener {
    private ProfileSet profileSet;
    LolaParameterSet paramSet;

    public SaveLogoTreeToFile(ProfileSet profileSet, LolaParameterSet params) {
        super();
        this.profileSet = profileSet;
        this.paramSet = params;

    }

    public void actionPerformed(ActionEvent actionEvent) {
        LogoTree tree = profileSet.getLogoTree();
        if (tree != null) {

            // Construct the output path since the output path stored in the LogoTree object is not always update to date
            // TODO: Set the output path properly in LogoTree whenever the output path is updated so it can be retrieved here
            
            String outputPath = paramSet.getOutputPath() + File.separator + paramSet.getTreeFilename();
            if (tree != null) {
                try {
                    if (paramSet.getTreeImageFormat().equals(LolaResources.OUTPUT_FORMAT_GTR))
                    {
                        //System.out.println("Writing gtr format");
                        LogoGenerator.saveToTextFile(new File(outputPath),tree.getGTRFormat());
                    }
                    else if (paramSet.getTreeImageFormat().equals(LolaResources.IMAGE_FORMAT_PDF))
                    {
                        //System.out.println("Writing pdf format");
                        LogoGenerator.saveGraphicAsPDF(new File(outputPath), tree.getLogoTreeDraw(),
                                tree.getImage().getWidth(), tree.getImage().getHeight());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
                }
                tree.setIsSaved(true);
            }
        }
    }
}