package org.baderlab.lola.view;

import org.baderlab.lola.model.ProfileSet;
import org.baderlab.lola.model.LogoTree;
import org.baderlab.lola.LolaParameterSet;
import org.baderlab.brain.BrainAlgorithm;
import org.baderlab.brain.LogoTreeDraw;
import org.baderlab.brain.ProteinTerminus;
import org.baderlab.brain.AminoAcidGrouping;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;


import javax.swing.*;
import java.io.File;
import java.io.IOException;
import java.util.List;

/**
 Copyright 2007 Bader Lab

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU Lesser General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.

 */

/**
 * Created by IntelliJ IDEA.
 * User: moyez
 * Date: May 28, 2007
 * Time: 6:14:41 PM
 * To change this template use File | Settings | File Templates.
 */
public class GenerateLogoTreeTask implements Task {
    private TaskMonitor taskMonitor = null;
    private BrainAlgorithm alg = null;

    private ProfileSet profileSet;
    private LolaParameterSet paramSet;

    public GenerateLogoTreeTask(ProfileSet profileSet, LolaParameterSet paramSet) {
        this.profileSet = profileSet;
        this.paramSet = paramSet;
        this.alg = new BrainAlgorithm();
    }

    public void run() throws OutOfMemoryError {
        if (taskMonitor == null) {
            throw new IllegalStateException("Task Monitor is not set.");
        }
        alg.setTaskMonitor(taskMonitor);
        taskMonitor.setStatus("Reading profiles");

        String outputPath = paramSet.getOutputPath() + File.separator + paramSet.getTreeFilename();
        File codonBiasFile = paramSet.getCodonBiasFile();
        String positionFilter = paramSet.getPositionFilter();
        LogoTreeDraw ltd= null;

        // Use the position filter only if it is not null or empty
        if (positionFilter != null && !positionFilter.equals(""))
        {
            ltd = alg.runAlignedProfileClusterByFilter(
                paramSet.getProfileFile().toString(),
                profileSet.getProteinProfileList(),
                positionFilter,
                paramSet.getTreeTitle(),
                new File(outputPath),
                null,
                codonBiasFile,
                paramSet.getTreeLeafTrimFactor(),
                paramSet.getTreeInternalNodeTrimFactor(),
                paramSet.getTreeLeafOrderingMethod(),
                paramSet.getAminoAcidGrouping(),
                false
            );
        }
        else
        {
            ltd = alg.runAlignedProfileCluster(
                paramSet.getProfileFile().toString(),
                profileSet.getProteinProfileList(),
                paramSet.getTreeTitle(),
                new File(outputPath),
                paramSet.getTreeLeafTrimFactor(),
                paramSet.getTreeInternalNodeTrimFactor(),
                paramSet.getTreeLeafOrderingMethod(),
                paramSet.getAminoAcidGrouping(),
                false);
        }
        

        LogoTree tree = new LogoTree();
        // TODO: Set the output file path whenever the output path file text field is updated
        //tree.setOutputFilePath(outputPath);
        tree.setIsSaved(false);
        tree.setLogoTreeDraw(ltd);
        tree.setImage(ltd.outputToGraphics());
        tree.setGTRFormat(ltd.outputToGTRFormat());
        profileSet.setLogoTree(tree);
    }

    public void halt() {
        //TODO - implement a cancel method in BrainAlgorithm that will halt logo tree drawing
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) throws IllegalThreadStateException {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Generating Logo Tree");
    }

}
