/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dp.DotState;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.IllegalTransitionException;
import org.biojava.bio.dp.SimpleDotState;
import org.biojava.bio.dp.SimpleEmissionState;
import org.biojava.bio.dp.SimpleMarkovModel;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.utils.ChangeVetoException;

public class ProfileHMM
extends SimpleMarkovModel {
    private static final int[] advance = new int[]{1};
    private final int columns;
    private final EmissionState[] matchStates;
    private final EmissionState[] insertStates;
    private final DotState[] deleteStates;

    public int columns() {
        return this.columns;
    }

    public EmissionState getMatch(int indx) throws IndexOutOfBoundsException {
        if (indx < 0 || indx > this.columns + 1) {
            throw new IndexOutOfBoundsException("Match-state index must be within (0.." + (this.columns + 1) + "), not " + indx);
        }
        return this.matchStates[indx];
    }

    public EmissionState getInsert(int indx) throws IndexOutOfBoundsException {
        if (indx < 0 || indx > this.columns) {
            throw new IndexOutOfBoundsException("Insert-state index must be within (0.." + this.columns + "), not " + indx);
        }
        return this.insertStates[indx];
    }

    public DotState getDelete(int indx) throws IndexOutOfBoundsException {
        if (indx < 1 || indx > this.columns) {
            throw new IndexOutOfBoundsException("delete-state index must be within (1.." + this.columns + "), not " + indx);
        }
        return this.deleteStates[indx - 1];
    }

    public ProfileHMM(Alphabet alpha, int columns, DistributionFactory matchFactory, DistributionFactory insertFactory) throws IllegalSymbolException, IllegalTransitionException, IllegalAlphabetException {
        this(alpha, columns, matchFactory, insertFactory, "");
    }

    public ProfileHMM(Alphabet alpha, int columns, DistributionFactory matchFactory, DistributionFactory insertFactory, String name) throws IllegalSymbolException, IllegalTransitionException, IllegalAlphabetException {
        super(1, alpha, name);
        try {
            this.columns = columns;
            this.matchStates = new EmissionState[columns + 2];
            this.insertStates = new EmissionState[columns + 1];
            this.deleteStates = new DotState[columns];
            SimpleEmissionState mO = this.magicalState();
            SimpleEmissionState iO = new SimpleEmissionState("i-0", Annotation.EMPTY_ANNOTATION, advance, insertFactory.createDistribution(alpha));
            SimpleDotState dO = null;
            this.matchStates[0] = mO;
            this.insertStates[0] = iO;
            this.addState(iO);
            for (int i = 1; i <= columns; ++i) {
                SimpleEmissionState mN = new SimpleEmissionState("m-" + i, Annotation.EMPTY_ANNOTATION, advance, matchFactory.createDistribution(alpha));
                SimpleEmissionState iN = new SimpleEmissionState("i-" + i, Annotation.EMPTY_ANNOTATION, advance, insertFactory.createDistribution(alpha));
                SimpleDotState dN = new SimpleDotState("d-" + i);
                this.addState(mN);
                this.addState(iN);
                this.addState(dN);
                this.matchStates[i] = mN;
                this.insertStates[i] = iN;
                this.deleteStates[i - 1] = dN;
                mO = mN;
                iO = iN;
                dO = dN;
            }
            this.matchStates[columns + 1] = this.magicalState();
            this.connectModel();
        }
        catch (ChangeVetoException cve) {
            throw new BioError("Unable to construct profile HMM", cve);
        }
    }

    protected void connectModel() throws ChangeVetoException, IllegalSymbolException, IllegalTransitionException, IllegalAlphabetException {
        EmissionState mO = this.getMatch(0);
        EmissionState iO = this.getInsert(0);
        DotState dO = null;
        this.createTransition(mO, iO);
        this.createTransition(iO, iO);
        for (int i = 1; i <= this.columns(); ++i) {
            EmissionState mN = this.getMatch(i);
            EmissionState iN = this.getInsert(i);
            DotState dN = this.getDelete(i);
            this.createTransition(mO, mN);
            this.createTransition(mN, iN);
            this.createTransition(mO, dN);
            this.createTransition(iN, iN);
            this.createTransition(iO, mN);
            this.createTransition(iO, dN);
            if (i > 1) {
                this.createTransition(dO, dN);
                this.createTransition(dO, mN);
            }
            this.createTransition(dN, iN);
            mO = mN;
            iO = iN;
            dO = dN;
        }
        this.createTransition(mO, this.magicalState());
        this.createTransition(iO, this.magicalState());
        this.createTransition(dO, this.magicalState());
    }
}

