/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.view;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.view.CyNetworkView;
import cytoscape.view.CytoscapeDesktop;
import cytoscape.view.InternalFrameComponent;
import ding.view.DGraphView;
import ding.view.InnerCanvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.SwingPropertyChangeSupport;

public class NetworkViewManager
implements PropertyChangeListener,
InternalFrameListener,
WindowFocusListener,
ChangeListener {
    private Container container;
    private Map networkViewMap;
    private Map componentMap;
    private Map internalFrameComponentMap;
    private int viewCount = 0;
    protected CytoscapeDesktop cytoscapeDesktop;
    protected int VIEW_TYPE;
    protected SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this);
    protected static int frame_count = 0;

    public NetworkViewManager(CytoscapeDesktop desktop, int view_type) {
        this.cytoscapeDesktop = desktop;
        this.VIEW_TYPE = view_type;
        this.initialize();
    }

    public NetworkViewManager(CytoscapeDesktop desktop) {
        this.cytoscapeDesktop = desktop;
        this.VIEW_TYPE = this.cytoscapeDesktop.getViewType();
        this.initialize();
    }

    protected void initialize() {
        if (this.VIEW_TYPE == 0) {
            this.container = new JTabbedPane(1, 1);
            ((JTabbedPane)this.container).addChangeListener(this);
        } else if (this.VIEW_TYPE == 1) {
            this.container = new JDesktopPane();
        } else if (this.VIEW_TYPE == 2) {
            this.container = null;
        }
        this.cytoscapeDesktop.getHelpBroker().enableHelp((Component)this.container, "network-view-manager", null);
        this.networkViewMap = new HashMap();
        this.componentMap = new HashMap();
        this.internalFrameComponentMap = new HashMap();
    }

    public SwingPropertyChangeSupport getSwingPropertyChangeSupport() {
        return this.pcs;
    }

    public JTabbedPane getTabbedPane() {
        if (this.VIEW_TYPE == 0) {
            return (JTabbedPane)this.container;
        }
        return null;
    }

    public JDesktopPane getDesktopPane() {
        if (this.VIEW_TYPE == 1) {
            return (JDesktopPane)this.container;
        }
        return null;
    }

    public InternalFrameComponent getInternalFrameComponent(CyNetworkView view) throws IllegalArgumentException {
        if (view == null) {
            throw new IllegalArgumentException("NetworkViewManager.getInternalFrameComponent(), argument is null");
        }
        return (InternalFrameComponent)this.internalFrameComponentMap.get(view.getIdentifier());
    }

    public void updateNetworkTitle(CyNetwork network) {
        Object frame = this.networkViewMap.get(network.getIdentifier());
        if (frame instanceof JInternalFrame) {
            ((JInternalFrame)frame).setTitle(network.getTitle());
            ((JInternalFrame)frame).repaint();
        } else if (frame instanceof JFrame) {
            ((JFrame)frame).setTitle(network.getTitle());
            ((JFrame)frame).repaint();
        } else if (frame instanceof Component) {
            ((Component)frame).setName(network.getTitle());
            ((Component)frame).repaint();
        }
    }

    public void stateChanged(ChangeEvent e) {
        String network_id = (String)this.componentMap.get(((JTabbedPane)this.container).getSelectedComponent());
        if (network_id == null) {
            return;
        }
        this.firePropertyChange("NETWORK_VIEW_FOCUSED", null, network_id);
    }

    public void internalFrameActivated(InternalFrameEvent e) {
        String network_id = (String)this.componentMap.get(e.getInternalFrame());
        if (network_id == null) {
            return;
        }
        this.firePropertyChange("NETWORK_VIEW_FOCUSED", null, network_id);
    }

    public void internalFrameClosed(InternalFrameEvent e) {
    }

    public void internalFrameClosing(InternalFrameEvent e) {
    }

    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    public void internalFrameIconified(InternalFrameEvent e) {
    }

    public void internalFrameOpened(InternalFrameEvent e) {
        this.internalFrameActivated(e);
    }

    public void windowGainedFocus(WindowEvent e) {
        String network_id = (String)this.componentMap.get(e.getWindow());
        if (network_id == null) {
            return;
        }
        this.firePropertyChange("NETWORK_VIEW_FOCUSED", null, network_id);
    }

    public void windowLostFocus(WindowEvent e) {
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == "NETWORK_VIEW_FOCUS") {
            String network_id = (String)e.getNewValue();
            e = null;
            this.unsetFocus();
            this.setFocus(network_id);
            InnerCanvas canvas = ((DGraphView)Cytoscape.getCurrentNetworkView()).getCanvas();
            if (this.getDesktopPane() != null) {
                canvas.addTransferComponent((JComponent)this.getDesktopPane());
            } else if (this.getTabbedPane() != null) {
                canvas.addTransferComponent((JComponent)this.getTabbedPane());
            }
        } else if (e.getPropertyName() == "NETWORK_VIEW_CREATED") {
            CyNetworkView new_view = (CyNetworkView)e.getNewValue();
            this.createContainer(new_view);
            e = null;
        } else if (e.getPropertyName() == "NETWORK_VIEW_DESTROYED") {
            CyNetworkView view = (CyNetworkView)e.getNewValue();
            this.removeView(view);
            e = null;
        }
    }

    public void firePropertyChange(String property_type, Object old_value, Object new_value) {
        this.pcs.firePropertyChange(new PropertyChangeEvent(this, property_type, old_value, new_value));
    }

    protected void unsetFocus() {
        Iterator i = this.networkViewMap.values().iterator();
        while (i.hasNext()) {
            if (this.VIEW_TYPE == 0) continue;
            if (this.VIEW_TYPE == 1) {
                try {
                    JInternalFrame f = (JInternalFrame)i.next();
                    f.setSelected(false);
                }
                catch (PropertyVetoException pve) {
                    System.out.println("Couldn't unset focus for internal frame.");
                }
                continue;
            }
            if (this.VIEW_TYPE != 2) continue;
        }
    }

    protected void setFocus(String network_id) {
        if (this.networkViewMap.containsKey(network_id)) {
            if (this.VIEW_TYPE == 0) {
                try {
                    ((JTabbedPane)this.container).setSelectedComponent((Component)this.networkViewMap.get(network_id));
                }
                catch (Exception e) {}
            } else if (this.VIEW_TYPE == 1) {
                try {
                    ((JInternalFrame)this.networkViewMap.get(network_id)).setIcon(false);
                    ((JInternalFrame)this.networkViewMap.get(network_id)).show();
                    ((JInternalFrame)this.networkViewMap.get(network_id)).setSelected(true);
                }
                catch (Exception e) {
                    System.err.println("Network View unable to be focused");
                }
            } else if (this.VIEW_TYPE == 2) {
                try {
                    ((JFrame)this.networkViewMap.get(network_id)).requestFocus();
                }
                catch (Exception e) {
                    System.err.println("Network View unable to be focused");
                }
            }
        }
    }

    protected void removeView(CyNetworkView view) {
        if (this.VIEW_TYPE == 0) {
            try {
                ((JTabbedPane)this.container).remove((Component)this.networkViewMap.get(view.getNetwork().getIdentifier()));
            }
            catch (Exception e) {}
        } else if (this.VIEW_TYPE == 1) {
            try {
                ((JInternalFrame)this.networkViewMap.get(view.getNetwork().getIdentifier())).dispose();
            }
            catch (Exception e) {
                System.err.println("Network View unable to be killed");
            }
        } else if (this.VIEW_TYPE == 2) {
            try {
                ((JFrame)this.networkViewMap.get(view.getNetwork().getIdentifier())).dispose();
            }
            catch (Exception e) {
                System.err.println("Network View unable to be killed");
            }
        }
        this.networkViewMap.remove(view.getNetwork().getIdentifier());
    }

    protected void createContainer(final CyNetworkView view) {
        if (this.networkViewMap.containsKey(view.getNetwork().getIdentifier())) {
            return;
        }
        if (this.VIEW_TYPE == 0) {
            ((JTabbedPane)this.container).addTab(view.getNetwork().getTitle(), view.getComponent());
            this.networkViewMap.put(view.getNetwork().getIdentifier(), view.getComponent());
            this.componentMap.put(view.getComponent(), view.getNetwork().getIdentifier());
        } else if (this.VIEW_TYPE == 1) {
            JInternalFrame iframe = new JInternalFrame(view.getTitle(), true, true, true, true);
            iframe.addInternalFrameListener(new InternalFrameAdapter(){

                public void internalFrameClosing(InternalFrameEvent e) {
                    Cytoscape.destroyNetworkView(view);
                }
            });
            ((JDesktopPane)this.container).add(iframe);
            if (view instanceof DGraphView) {
                InternalFrameComponent internalFrameComp = new InternalFrameComponent(iframe.getLayeredPane(), (DGraphView)view);
                iframe.setContentPane(internalFrameComp);
                this.internalFrameComponentMap.put(view.getNetwork().getIdentifier(), internalFrameComp);
            } else {
                System.out.println("NetworkViewManager.createContainer() - DGraphView not found!");
                iframe.getContentPane().add(view.getComponent());
            }
            iframe.pack();
            iframe.setSize(400, 400);
            try {
                String max = CytoscapeInit.getProperties().getProperty("maximizeViewOnCreate");
                if (max != null && Boolean.parseBoolean(max)) {
                    iframe.setMaximum(true);
                }
            }
            catch (PropertyVetoException pve) {
                pve.printStackTrace();
            }
            iframe.setVisible(true);
            iframe.addInternalFrameListener(this);
            this.networkViewMap.put(view.getNetwork().getIdentifier(), iframe);
            this.componentMap.put(iframe, view.getNetwork().getIdentifier());
        } else if (this.VIEW_TYPE == 2) {
            JFrame frame = new JFrame(view.getNetwork().getTitle());
            frame.getContentPane().add(view.getComponent());
            frame.pack();
            frame.setSize(400, 400);
            frame.setVisible(true);
            this.componentMap.put(frame, view.getNetwork().getIdentifier());
            this.networkViewMap.put(view.getNetwork().getIdentifier(), frame);
            frame.addWindowFocusListener(this);
            frame.setJMenuBar(this.cytoscapeDesktop.getCyMenus().getMenuBar());
        }
        this.firePropertyChange("NETWORK_VIEW_FOCUSED", null, view.getNetwork().getIdentifier());
    }
}

