/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs.preferences;

import cytoscape.dialogs.preferences.PreferencesDialog;
import cytoscape.util.CyFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.table.TableModel;

public class PreferenceValueDialog
extends JDialog {
    String preferenceName = null;
    String preferenceValue = null;
    String title = null;
    JLabel preferenceNameL = null;
    JTextField value = null;
    JButton browseButton = null;
    JButton okButton = null;
    JButton cancelButton = null;
    TableModel tableModel = null;
    boolean includeBrowseBtn = false;
    PreferencesDialog callerRef = null;

    public PreferenceValueDialog(Dialog owner, String name, String value, PreferencesDialog caller, TableModel tm, String title, boolean includeBrowse) {
        super(owner, true);
        this.callerRef = caller;
        this.tableModel = tm;
        this.title = title;
        this.includeBrowseBtn = includeBrowse;
        this.preferenceName = new String(name);
        this.preferenceValue = new String(value);
        this.showDialog(owner);
    }

    protected void showDialog(Dialog owner) {
        this.preferenceNameL = new JLabel(this.preferenceName);
        this.value = new JTextField(this.preferenceValue, 32);
        this.browseButton = new JButton("Browse..");
        this.okButton = new JButton("OK");
        this.cancelButton = new JButton("Cancel");
        this.browseButton.addActionListener(new BrowseButtonListener(this, this.callerRef));
        this.okButton.addActionListener(new OkButtonListener(this, this.callerRef));
        this.cancelButton.addActionListener(new CancelButtonListener(this, this.callerRef));
        JPanel outerPanel = new JPanel(new BorderLayout());
        JPanel valuePanel = new JPanel(new FlowLayout());
        JPanel buttonPanel = new JPanel(new FlowLayout());
        valuePanel.add(this.preferenceNameL);
        valuePanel.add(this.value);
        if (this.includeBrowseBtn || this.preferenceName.toUpperCase().indexOf("DIRECTORY") >= 0 || this.preferenceName.toUpperCase().indexOf("FILE") >= 0) {
            valuePanel.add(this.browseButton);
        }
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        outerPanel.add((Component)valuePanel, "North");
        outerPanel.add((Component)buttonPanel, "South");
        this.getContentPane().add((Component)outerPanel, "Center");
        this.pack();
        this.setTitle(this.title);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    public String validatedPluginData(Component comp, String selection) {
        String validatedData = null;
        File file = new File(selection);
        if (file.isDirectory()) {
            String[] fileList = file.list();
            String pluginFiles = new String("");
            for (int j = 0; j < fileList.length; ++j) {
                String jarString = file.getAbsolutePath() + File.separator + fileList[j];
                if (!jarString.endsWith(".jar")) continue;
                pluginFiles = pluginFiles.length() > 0 ? pluginFiles + "," + jarString : new String(jarString);
            }
            if (pluginFiles.length() == 0) {
                JOptionPane.showMessageDialog(comp, "No plugins (*.jar files) found.", "Information", 1);
            } else {
                validatedData = pluginFiles;
            }
        } else if (!selection.endsWith(".jar")) {
            JOptionPane.showMessageDialog(comp, "No plugins (*.jar files) found.", "Information", 1);
        } else {
            validatedData = selection;
        }
        return validatedData;
    }

    class CancelButtonListener
    implements ActionListener {
        PreferenceValueDialog motherRef = null;
        PreferencesDialog grandmotherRef = null;

        public CancelButtonListener(PreferenceValueDialog mother, PreferencesDialog grandmother) {
            this.motherRef = mother;
            this.grandmotherRef = grandmother;
        }

        public void actionPerformed(ActionEvent e) {
            this.motherRef.dispose();
        }
    }

    class OkButtonListener
    implements ActionListener {
        PreferenceValueDialog motherRef = null;
        PreferencesDialog grandmotherRef = null;

        public OkButtonListener(PreferenceValueDialog mother, PreferencesDialog grandmother) {
            this.motherRef = mother;
            this.grandmotherRef = grandmother;
        }

        public void actionPerformed(ActionEvent e) {
            this.motherRef.preferenceValue = this.motherRef.value.getText();
            this.grandmotherRef.setParameter(PreferenceValueDialog.this.tableModel, this.motherRef.preferenceName, this.motherRef.preferenceValue);
            this.motherRef.dispose();
        }
    }

    class BrowseButtonListener
    implements ActionListener {
        PreferenceValueDialog motherRef = null;
        PreferencesDialog grandmotherRef = null;
        JFileChooser fc = null;

        public BrowseButtonListener(PreferenceValueDialog mother, PreferencesDialog grandmother) {
            this.motherRef = mother;
            this.grandmotherRef = grandmother;
        }

        public void actionPerformed(ActionEvent e) {
            String startingDir = this.grandmotherRef.prefsTM.getProperty("mrud");
            if (startingDir == null) {
                startingDir = System.getProperty("user.dir");
            }
            this.fc = new JFileChooser(startingDir);
            CyFileFilter filter = new CyFileFilter();
            filter.addExtension("jar");
            filter.setDescription("Plugins");
            if (this.motherRef.preferenceName.equals("Local")) {
                this.fc.setFileSelectionMode(2);
                this.fc.setFileFilter(filter);
            } else if (this.motherRef.preferenceName.equals("mrud")) {
                this.fc.setFileSelectionMode(1);
            }
            int returnVal = this.fc.showOpenDialog(this.motherRef);
            if (returnVal == 0) {
                File file = this.fc.getSelectedFile();
                String selection = file.getAbsolutePath();
                if (this.motherRef.preferenceName.equals("Local")) {
                    String plugins = PreferenceValueDialog.this.validatedPluginData(this.motherRef, selection);
                    this.motherRef.value.setText(plugins);
                } else if (this.motherRef.preferenceName.equals("bioDataServer")) {
                    this.motherRef.preferenceValue = selection;
                    this.motherRef.value.setText(this.motherRef.preferenceValue);
                } else if (this.motherRef.preferenceName.equals("mrud")) {
                    this.motherRef.preferenceValue = selection;
                    this.motherRef.value.setText(this.motherRef.preferenceValue);
                }
            } else {
                this.motherRef.dispose();
            }
        }
    }
}

