/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class ColorScaleTable
extends JPanel {
    public ColorScaleTable(int width, int height, double[][] bins) {
        MyTableModel myModel = new MyTableModel(bins);
        JTable table = new JTable(myModel);
        table.setPreferredScrollableViewportSize(new Dimension(width, height));
        JScrollPane scrollPane = new JScrollPane(table);
        this.setUpColorRenderer(table);
        this.add(scrollPane);
    }

    private void setUpColorRenderer(JTable table) {
        table.setDefaultRenderer(Color.class, new ColorRenderer(false));
    }

    class MyTableModel
    extends AbstractTableModel {
        final String[] columnNames = new String[]{"Value", "Color"};
        final Object[][] data;

        MyTableModel(double[][] bins) {
            int binCount = bins.length;
            this.data = new Object[binCount][2];
            for (int i = 0; i < binCount; ++i) {
                this.data[i][0] = new Double(bins[i][0]);
                Color tempColor = new Color((int)bins[i][1], (int)bins[i][2], (int)bins[i][3]);
                this.data[i][1] = tempColor;
            }
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public void setValueAt(Object value, int row, int col) {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }

    class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;
        boolean isBordered = true;

        public ColorRenderer(boolean isBordered) {
            this.isBordered = isBordered;
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground((Color)color);
            if (this.isBordered) {
                if (isSelected) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            return this;
        }
    }
}

