/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.webutil.filter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.prefs.Preferences;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;

public class NotAvailableFilter
implements Filter {
    private FilterConfig filterConfig = null;
    private static boolean isAvailable;
    private static String reason;
    private static String defaultReason;
    private static String propertiesFile;
    private static String filterPath;
    private static String nonAvailablePage;
    private static String adminPassword;
    private static Preferences prefs;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = null;
        HttpServletResponse httpResponse = null;
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            boolean isRedirectPage;
            httpRequest = (HttpServletRequest)request;
            httpResponse = (HttpServletResponse)response;
            boolean byPass = Boolean.valueOf((String)httpRequest.getSession().getAttribute("isByPassed"));
            boolean bl = isRedirectPage = nonAvailablePage != null && (nonAvailablePage == null || httpRequest.getRequestURI().endsWith(nonAvailablePage));
            if (httpRequest != null && httpRequest.getServletPath().startsWith(filterPath)) {
                if (adminPassword == null || this.authenticate(httpRequest)) {
                    String submit = httpRequest.getParameter("submit");
                    if (httpRequest.getParameter("submit") != null) {
                        isAvailable = httpRequest.getParameter("disable") == null;
                        reason = httpRequest.getParameter("reason");
                        if (submit.equals("Bypass")) {
                            httpRequest.getSession().setAttribute("isByPassed", (Object)"true");
                        }
                        if (submit.equals("Stop Bypass")) {
                            httpRequest.getSession().setAttribute("isByPassed", (Object)"false");
                        }
                    }
                    if (isAvailable) {
                        httpRequest.getSession().setAttribute("isByPassed", (Object)"false");
                        reason = null;
                    }
                    if (reason == null || reason.equals("")) {
                        reason = defaultReason;
                        httpRequest.getSession().setAttribute("nonAvailableReason", (Object)reason);
                    }
                    byPass = Boolean.valueOf((String)httpRequest.getSession().getAttribute("isByPassed"));
                    PrintWriter writer = response.getWriter();
                    writer.println("<html>");
                    writer.println("<head><title>Not Available Filter</title></head>");
                    writer.println("<body><form>");
                    writer.println("Disable Application<input type=\"checkbox\" name=\"disable\" value=\"true\" " + (isAvailable ? "" : "checked") + "><p>");
                    writer.println("Reason: <textarea width=\"100\" height=\"10\" name=\"reason\">");
                    if (reason != null) {
                        writer.println(reason);
                    }
                    writer.println("</textarea></p>");
                    writer.println("<input type=\"submit\" value=\"Apply\" name=\"submit\">");
                    if (!byPass) {
                        writer.println("<input type=\"submit\" value=\"Bypass\" name=\"submit\">");
                    } else {
                        writer.println("<input type=\"submit\" value=\"Stop Bypass\" name=\"submit\">");
                    }
                    writer.println("</form>");
                    writer.println("</body>");
                    writer.println("<html>");
                } else {
                    httpResponse.setHeader("WWW-Authenticate", "Basic realm=\"Please enter administrator password\"");
                    httpResponse.sendError(401, "");
                }
            } else if (!(isAvailable || byPass || isRedirectPage)) {
                this.printNonAvailablePage(httpRequest.getContextPath(), nonAvailablePage, response);
            } else {
                if (!isAvailable && !isRedirectPage) {
                    PrintWriter writer = response.getWriter();
                    writer.println("<h2 align=\"center\"><font color=\"red\">The application is currently unavailable to outside users</font></h2>");
                }
                chain.doFilter((ServletRequest)httpRequest, response);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
        prefs.put("isAvailable", String.valueOf(isAvailable));
        if (reason == null || reason.equals(defaultReason)) {
            prefs.remove("reason");
        } else {
            prefs.put("reason", reason);
        }
    }

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        this.loadProperties();
        prefs = Preferences.userNodeForPackage(NotAvailableFilter.class);
        isAvailable = Boolean.valueOf(prefs.get("isAvailable", "true"));
        reason = prefs.get("reason", defaultReason);
    }

    private void printNonAvailablePage(String contextPath, String page, ServletResponse response) throws IOException {
        if (page == null) {
            PrintWriter writer = response.getWriter();
            writer.println("<html>");
            writer.println("<head><title>Not Available</title></head>");
            writer.println("<body>");
            writer.println("<h1>Not currently available</h1>");
            if (reason != null) {
                writer.println(reason);
            }
            writer.println("</body>");
            writer.println("<html>");
        } else if (response instanceof HttpServletResponse) {
            ((HttpServletResponse)response).sendRedirect(contextPath + page);
        } else {
            this.printNonAvailablePage(contextPath, null, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadProperties() {
        block11: {
            System.getProperties().remove("freehep.nonavailablefilter.path");
            System.getProperties().remove("freehep.nonavailablefilter.redirectpage");
            System.getProperties().remove("freehep.nonavailablefilter.defaultreason");
            System.getProperties().remove("freehep.nonavailablefilter.password");
            String filePath = this.filterConfig.getServletContext().getRealPath(propertiesFile);
            FileInputStream input = null;
            input = new FileInputStream(new File(filePath));
            System.getProperties().load(input);
            Object var5_3 = null;
            try {
                if (input != null) {
                    input.close();
                }
                break block11;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            break block11;
            {
                catch (Exception exception) {
                    Object var5_4 = null;
                    try {
                        if (input != null) {
                            input.close();
                        }
                        break block11;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                throw throwable;
            }
        }
        filterPath = System.getProperty("freehep.nonavailablefilter.path", "/admin/available");
        defaultReason = System.getProperty("freehep.nonavailablefilter.defaultreason");
        nonAvailablePage = System.getProperty("freehep.nonavailablefilter.redirectpage");
        adminPassword = System.getProperty("freehep.nonavailablefilter.password");
    }

    private boolean authenticate(HttpServletRequest req) {
        String authhead = req.getHeader("Authorization");
        if (authhead != null) {
            String usernpass = new String(Base64.decodeBase64((byte[])authhead.substring(6).getBytes()));
            String user = usernpass.substring(0, usernpass.indexOf(":"));
            String password = usernpass.substring(usernpass.indexOf(":") + 1);
            if (password.equals(adminPassword)) {
                return true;
            }
        }
        return false;
    }

    static {
        reason = null;
        defaultReason = null;
        propertiesFile = "/WEB-INF/freehepWebapp.properties";
        filterPath = null;
        nonAvailablePage = null;
        adminPassword = null;
    }
}

