/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class StatusBar
extends JPanel {
    private JLabel m_label = new JLabel();

    public StatusBar() {
        this.setLayout(new StatusLayout());
        boolean macOSX = false;
        try {
            macOSX = System.getProperty("mrj.version") != null;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.setBorder(new EmptyBorder(0, 0, 0, macOSX ? 18 : 0));
        super.add(this.m_label);
        this.m_label.setBorder(BorderFactory.createBevelBorder(1));
    }

    public void setMessage(final String message) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable run = new Runnable(){

                public void run() {
                    StatusBar.this.setMessage(message);
                }
            };
            SwingUtilities.invokeLater(run);
        } else if (message == null) {
            this.m_label.setText(" ");
        } else {
            this.m_label.setText(message);
        }
    }

    private class StatusLayout
    implements LayoutManager2,
    Comparator {
        StatusLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void addLayoutComponent(Component comp, Object constraints) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public float getLayoutAlignmentX(Container target) {
            return 0.5f;
        }

        public float getLayoutAlignmentY(Container target) {
            return 0.5f;
        }

        public void invalidateLayout(Container target) {
        }

        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            Dimension size = parent.getSize();
            Component[] children = parent.getComponents();
            Arrays.sort(children, this);
            int x1 = insets.left;
            int i = 0;
            while (i < children.length) {
                Component c = children[i];
                if (c != StatusBar.this.m_label) {
                    float align = c.getAlignmentX();
                    if ((double)align >= 0.5) break;
                    Dimension s = c.getPreferredSize();
                    s.height = size.height - insets.top - insets.bottom;
                    c.setSize(s);
                    c.setLocation(x1, insets.top);
                    x1 += s.width;
                }
                ++i;
            }
            int x2 = size.width - insets.right;
            int i2 = children.length;
            while (i2-- > 0) {
                Component c = children[i2];
                if (c == StatusBar.this.m_label) continue;
                float align = c.getAlignmentX();
                if ((double)align < 0.5) break;
                Dimension s = c.getPreferredSize();
                s.height = size.height - insets.top - insets.bottom;
                c.setSize(s);
                c.setLocation(x2 -= s.width, insets.top);
            }
            Dimension s = new Dimension(x2 - x1, size.height - insets.top - insets.bottom);
            StatusBar.this.m_label.setSize(s);
            StatusBar.this.m_label.setLocation(x1, insets.top);
        }

        public Dimension maximumLayoutSize(Container target) {
            Insets insets = target.getInsets();
            int width = insets.left + insets.right;
            int height = Integer.MAX_VALUE;
            int count = target.getComponentCount();
            int i = 0;
            while (i < count) {
                Component c = target.getComponent(i);
                if (c.isVisible()) {
                    Dimension size = c.getMaximumSize();
                    width += size.width;
                    height = Math.min(height, size.height);
                }
                ++i;
            }
            return new Dimension(width, height += insets.top + insets.bottom);
        }

        public Dimension minimumLayoutSize(Container parent) {
            Insets insets = parent.getInsets();
            int width = insets.left + insets.right;
            int height = 0;
            int count = parent.getComponentCount();
            int i = 0;
            while (i < count) {
                Component c = parent.getComponent(i);
                if (c.isVisible()) {
                    Dimension size = c.getMinimumSize();
                    width += size.width;
                    height = Math.max(height, size.height);
                }
                ++i;
            }
            return new Dimension(width, height += insets.top + insets.bottom);
        }

        public Dimension preferredLayoutSize(Container parent) {
            Insets insets = parent.getInsets();
            int width = insets.left + insets.right;
            int height = 0;
            int count = parent.getComponentCount();
            int i = 0;
            while (i < count) {
                Component c = parent.getComponent(i);
                if (c.isVisible()) {
                    Dimension size = c.getPreferredSize();
                    width += size.width;
                    height = Math.max(height, size.height);
                }
                ++i;
            }
            return new Dimension(width, height += insets.top + insets.bottom);
        }

        public int compare(Object o1, Object o2) {
            float delta = ((Component)o1).getAlignmentX() - ((Component)o2).getAlignmentX();
            if (delta == 0.0f) {
                return 0;
            }
            if (delta > 0.0f) {
                return 1;
            }
            return -1;
        }
    }
}

