/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings.continuous;

import cytoscape.visual.mappings.continuous.ContinuousMappingReader;
import cytoscape.visual.mappings.continuous.ContinuousRangeCalculator;
import cytoscape.visual.parsers.ColorParser;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import junit.framework.TestCase;

public class TestContinuousColorRangeCalculator
extends TestCase {
    public void testCalculator1() throws Exception {
        InputStream in = this.getMapper1Props();
        Properties props = this.getProperties(in);
        ColorParser parser = new ColorParser();
        ContinuousMappingReader reader = new ContinuousMappingReader(props, "nodeColorCalculator.Sample.mapping", parser);
        ArrayList points = reader.getPoints();
        HashMap<String, Double> bundle = new HashMap<String, Double>();
        double[] values = new double[]{-1.0, 0.07, 2.0, 4.0, 5.0, 10.0};
        for (int i = 0; i < values.length; ++i) {
            String key = "key" + i;
            bundle.put(key, new Double(values[i]));
        }
        ContinuousRangeCalculator calc = new ContinuousRangeCalculator(points, reader.getInterpolator(), bundle);
        Color[] colors = new Color[]{Color.BLUE, Color.BLUE, Color.BLUE, Color.BLUE, Color.WHITE, Color.RED};
        for (int i = 0; i < values.length; ++i) {
            Object color = calc.calculateRangeValue("key" + i);
            TestContinuousColorRangeCalculator.assertEquals((Object)colors[i], (Object)color);
        }
    }

    public void testCalculator2() throws Exception {
        InputStream in = this.getMapper2Props();
        Properties props = this.getProperties(in);
        ColorParser parser = new ColorParser();
        ContinuousMappingReader reader = new ContinuousMappingReader(props, "nodeColorCalculator.Sample.mapping", parser);
        ArrayList points = reader.getPoints();
        HashMap<String, Double> bundle = new HashMap<String, Double>();
        double[] values = new double[]{-1.0, 0.07, 2.0, 4.0, 5.0, 10.0};
        for (int i = 0; i < values.length; ++i) {
            String key = "key" + i;
            bundle.put(key, new Double(values[i]));
        }
        ContinuousRangeCalculator calc = new ContinuousRangeCalculator(points, reader.getInterpolator(), bundle);
        Color[] colors = new Color[]{new Color(0, 0, 255), new Color(255, 251, 251), new Color(255, 153, 153), new Color(255, 51, 51), new Color(255, 0, 0), new Color(0, 0, 0)};
        for (int i = 0; i < values.length; ++i) {
            Object color = calc.calculateRangeValue("key" + i);
            TestContinuousColorRangeCalculator.assertEquals((Object)colors[i], (Object)color);
        }
    }

    private Properties getProperties(InputStream in) throws IOException {
        Properties props = new Properties();
        props.load(in);
        return props;
    }

    private InputStream getMapper1Props() {
        String props = new String("nodeColorCalculator.Sample.class=cytoscape.visual.calculators.GenericNodeColorCalculator\nnodeColorCalculator.Sample.mapping.boundaryvalues=1\nnodeColorCalculator.Sample.mapping.bv0.domainvalue=5.0\nnodeColorCalculator.Sample.mapping.bv0.equal=255,255,255\nnodeColorCalculator.Sample.mapping.bv0.greater=255,0,0\nnodeColorCalculator.Sample.mapping.bv0.lesser=0,0,255\nnodeColorCalculator.Sample.mapping.controller=Expression\nnodeColorCalculator.Sample.mapping.interpolator=LinearNumberToColorInterpolator\nnodeColorCalculator.Sample.mapping.type=ContinuousMapping\n");
        ByteArrayInputStream in = new ByteArrayInputStream(props.getBytes());
        return in;
    }

    private InputStream getMapper2Props() {
        String props = new String("nodeColorCalculator.Sample.class=cytoscape.visual.calculators.GenericNodeColorCalculator\nnodeColorCalculator.Sample.mapping.boundaryvalues=2\nnodeColorCalculator.Sample.mapping.bv0.domainvalue=0.0\nnodeColorCalculator.Sample.mapping.bv0.equal=255,255,255\nnodeColorCalculator.Sample.mapping.bv0.greater=255,255,255\nnodeColorCalculator.Sample.mapping.bv0.lesser=0,0,255\nnodeColorCalculator.Sample.mapping.bv1.domainvalue=5.0\nnodeColorCalculator.Sample.mapping.bv1.equal=255,0,0\nnodeColorCalculator.Sample.mapping.bv1.greater=0,0,0\nnodeColorCalculator.Sample.mapping.bv1.lesser=255,0,0\nnodeColorCalculator.Sample.mapping.controller=Expression\nnodeColorCalculator.Sample.mapping.interpolator=LinearNumberToColorInterpolator\nnodeColorCalculator.Sample.mapping.type=ContinuousMapping\n");
        ByteArrayInputStream in = new ByteArrayInputStream(props.getBytes());
        return in;
    }
}

