/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.data.ImportHandler;
import cytoscape.data.readers.GraphReader;
import cytoscape.data.readers.XGMMLReader;
import cytoscape.util.CyFileFilter;
import java.io.File;
import java.io.IOException;

public class XGMMLFileFilter
extends CyFileFilter {
    private static String fileNature = ImportHandler.GRAPH_NATURE;
    private static String[] fileExtensions = new String[]{"xgmml", "xml"};
    private static String description = "XGMML files";

    public XGMMLFileFilter() {
        super(fileExtensions, description, fileNature);
    }

    public GraphReader getReader(String fileName) {
        this.reader = new XGMMLReader(fileName);
        return this.reader;
    }

    public boolean accept(File file) {
        String fileName = file.getName();
        boolean firstPass = false;
        for (int i = 0; i < fileExtensions.length; ++i) {
            if (!fileName.endsWith(fileExtensions[i])) continue;
            firstPass = true;
        }
        if (firstPass) {
            try {
                String header = this.getHeader(file).toLowerCase();
                if (header.indexOf("www.cs.rpi.edu/xgmml") > 0) {
                    return true;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return false;
    }
}

