/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class PopupTextArea
extends JDialog {
    PopupTextArea popupTextArea;
    Point location;

    public PopupTextArea(JDialog parent, String title, String text) {
        super((Dialog)parent, false);
        this.location = parent.getLocationOnScreen();
        this.init(title, text);
    }

    public PopupTextArea(Frame parent, String title, String text) {
        super(parent, false);
        this.location = parent.getLocationOnScreen();
        this.init(title, text);
    }

    private void init(String title, String text) {
        this.setTitle(title);
        this.popupTextArea = this;
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JTextArea textArea = new JTextArea(text);
        textArea.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(textArea);
        panel.setPreferredSize(new Dimension(600, 400));
        panel.add((Component)scrollPane, "Center");
        JPanel buttonPanel = new JPanel();
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new OKAction());
        buttonPanel.add((Component)okButton, "Center");
        panel.add((Component)buttonPanel, "South");
        this.setContentPane(panel);
        this.setLocation(this.location);
        this.pack();
        this.setVisible(true);
    }

    public class OKAction
    extends AbstractAction {
        OKAction() {
            super("");
        }

        public void actionPerformed(ActionEvent e) {
            PopupTextArea.this.popupTextArea.dispose();
        }
    }
}

