/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.io.IOException;
import java.util.Vector;
import org.freehep.graphicsio.swf.FillStyleArray;
import org.freehep.graphicsio.swf.LineStyleArray;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.util.io.BitOutputStream;

public class SWFShape {
    private int numFillBits;
    private int numLineBits;
    private FillStyleArray fillStyles;
    private LineStyleArray lineStyles;
    private Vector records;

    public SWFShape(Vector records) {
        this.records = records;
    }

    public SWFShape(SWFInputStream input) throws IOException {
        this(input, null, null, false, false);
    }

    public SWFShape(SWFInputStream input, FillStyleArray fillStyles, LineStyleArray lineStyles, boolean isMorphStyle, boolean hasAlpha) throws IOException {
        this.fillStyles = fillStyles;
        this.lineStyles = lineStyles;
        input.byteAlign();
        this.numFillBits = (int)input.readUBits(4);
        this.numLineBits = (int)input.readUBits(4);
        this.records = new Vector();
        boolean endOfShape = false;
        do {
            boolean edge;
            if (edge = input.readBitFlag()) {
                this.records.add(new EdgeRecord(input));
                continue;
            }
            int state = (int)input.readUBits(5);
            if (state == 0) {
                endOfShape = true;
                continue;
            }
            this.records.add(new ShapeRecord(this, input, this.numFillBits, this.numLineBits, isMorphStyle, hasAlpha, state));
        } while (!endOfShape);
    }

    public void write(SWFOutputStream swf) throws IOException {
        this.write(swf, false);
    }

    public void write(SWFOutputStream swf, boolean hasAlpha) throws IOException {
        Record r;
        int i;
        swf.byteAlign();
        int numFillBits = 0;
        int numLineBits = 0;
        for (i = 0; i < this.records.size(); ++i) {
            r = (Record)this.records.get(i);
            if (!(r instanceof ShapeRecord)) continue;
            ShapeRecord s = (ShapeRecord)r;
            numFillBits = Math.max(numFillBits, s.getNumFillBits());
            numLineBits = Math.max(numLineBits, s.getNumLineBits());
        }
        swf.writeUBits(numFillBits, 4);
        swf.writeUBits(numLineBits, 4);
        for (i = 0; i < this.records.size(); ++i) {
            r = (Record)this.records.get(i);
            r.write(swf, numFillBits, numLineBits, hasAlpha);
        }
        swf.writeUBits(0L, 6);
        swf.byteAlign();
    }

    void setNumFillBits(int numFillBits) {
        this.numFillBits = numFillBits;
    }

    void setNumLineBits(int numLineBits) {
        this.numLineBits = numLineBits;
    }

    void setFillStyles(FillStyleArray fillStyles) {
        this.fillStyles = fillStyles;
    }

    void setLineStyles(LineStyleArray lineStyles) {
        this.lineStyles = lineStyles;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this.records.size(); ++i) {
            s.append("    ");
            s.append(i);
            s.append(":");
            s.append(this.records.get(i));
            s.append("\n");
        }
        s.append("    End of shape\n");
        return s.toString();
    }

    public static class EdgeRecord
    extends Record {
        boolean curve;
        int controlDeltaX;
        int controlDeltaY;
        int anchorDeltaX;
        int anchorDeltaY;
        int deltaX;
        int deltaY;

        public EdgeRecord(int controlDeltaX, int controlDeltaY, int anchorDeltaX, int anchorDeltaY) {
            this.curve = true;
            this.controlDeltaX = controlDeltaX;
            this.controlDeltaY = controlDeltaY;
            this.anchorDeltaX = anchorDeltaX;
            this.anchorDeltaY = anchorDeltaY;
        }

        public EdgeRecord(int deltaX, int deltaY) {
            this.curve = false;
            this.deltaX = deltaX;
            this.deltaY = deltaY;
        }

        EdgeRecord(SWFInputStream input) throws IOException {
            this.curve = !input.readBitFlag();
            int numBits = (int)input.readUBits(4) + 2;
            if (this.curve) {
                this.controlDeltaX = (int)input.readSBits(numBits);
                this.controlDeltaY = (int)input.readSBits(numBits);
                this.anchorDeltaX = (int)input.readSBits(numBits);
                this.anchorDeltaY = (int)input.readSBits(numBits);
            } else if (input.readBitFlag()) {
                this.deltaX = (int)input.readSBits(numBits);
                this.deltaY = (int)input.readSBits(numBits);
            } else if (input.readBitFlag()) {
                this.deltaX = 0;
                this.deltaY = (int)input.readSBits(numBits);
            } else {
                this.deltaX = (int)input.readSBits(numBits);
                this.deltaY = 0;
            }
        }

        public void write(SWFOutputStream swf, int numFillBits, int numLineBits, boolean hasAlpha) throws IOException {
            swf.writeBitFlag(true);
            swf.writeBitFlag(!this.curve);
            int numBits = 0;
            if (this.curve) {
                numBits = Math.max(numBits, SWFOutputStream.minBits((long)this.controlDeltaX, (boolean)true));
                numBits = Math.max(numBits, SWFOutputStream.minBits((long)this.controlDeltaY, (boolean)true));
                numBits = Math.max(numBits, SWFOutputStream.minBits((long)this.anchorDeltaX, (boolean)true));
                numBits = Math.max(numBits, SWFOutputStream.minBits((long)this.anchorDeltaY, (boolean)true));
            } else if (this.deltaX != 0 && this.deltaY != 0) {
                numBits = Math.max(numBits, SWFOutputStream.minBits((long)this.deltaX, (boolean)true));
                numBits = Math.max(numBits, SWFOutputStream.minBits((long)this.deltaY, (boolean)true));
            } else {
                numBits = this.deltaX == 0 ? Math.max(numBits, SWFOutputStream.minBits((long)this.deltaY, (boolean)true)) : Math.max(numBits, SWFOutputStream.minBits((long)this.deltaX, (boolean)true));
            }
            swf.writeUBits(numBits - 2, 4);
            if (this.curve) {
                swf.writeSBits(this.controlDeltaX, numBits);
                swf.writeSBits(this.controlDeltaY, numBits);
                swf.writeSBits(this.anchorDeltaX, numBits);
                swf.writeSBits(this.anchorDeltaY, numBits);
            } else if (this.deltaX != 0 && this.deltaY != 0) {
                swf.writeBitFlag(true);
                swf.writeSBits(this.deltaX, numBits);
                swf.writeSBits(this.deltaY, numBits);
            } else {
                swf.writeBitFlag(false);
                if (this.deltaX == 0) {
                    swf.writeBitFlag(true);
                    swf.writeSBits(this.deltaY, numBits);
                } else {
                    swf.writeBitFlag(false);
                    swf.writeSBits(this.deltaX, numBits);
                }
            }
        }

        public String toString() {
            if (this.curve) {
                return "rcurveto(" + this.controlDeltaX + ", " + this.controlDeltaY + ", " + this.anchorDeltaX + ", " + this.anchorDeltaY + ")";
            }
            return "rlineto(" + this.deltaX + ", " + this.deltaY + ")";
        }
    }

    public static class ShapeRecord
    extends Record {
        private static final int MOVE = 1;
        private static final int FILLSTYLE0 = 2;
        private static final int FILLSTYLE1 = 4;
        private static final int LINESTYLE = 8;
        private static final int NEWSTYLES = 16;
        private boolean move;
        private int moveX = 0;
        private int moveY = 0;
        private int fillStyle0 = -1;
        private int fillStyle1 = -1;
        private int lineStyle = -1;
        private FillStyleArray newFillStyles;
        private LineStyleArray newLineStyles;

        public ShapeRecord(boolean move, int moveX, int moveY, int fillStyle0, int fillStyle1, int lineStyle) {
            this.move = move;
            this.moveX = moveX;
            this.moveY = moveY;
            this.fillStyle0 = fillStyle0;
            this.fillStyle1 = fillStyle1;
            this.lineStyle = lineStyle;
        }

        ShapeRecord(SWFShape shape, SWFInputStream input, int numFillBits, int numLineBits, boolean isMorphStyle, boolean hasAlpha, int state) throws IOException {
            if ((state & 1) > 0) {
                this.move = true;
                int numMoveBits = (int)input.readUBits(5);
                this.moveX = (int)input.readSBits(numMoveBits);
                this.moveY = (int)input.readSBits(numMoveBits);
            }
            if ((state & 2) > 0) {
                this.fillStyle0 = (int)input.readUBits(numFillBits);
            }
            if ((state & 4) > 0) {
                this.fillStyle1 = (int)input.readUBits(numFillBits);
            }
            if ((state & 8) > 0) {
                this.lineStyle = (int)input.readUBits(numLineBits);
            }
            if ((state & 0x10) > 0) {
                this.newFillStyles = new FillStyleArray(input, isMorphStyle, hasAlpha);
                shape.setFillStyles(this.newFillStyles);
                this.newLineStyles = new LineStyleArray(input, isMorphStyle, hasAlpha);
                shape.setLineStyles(this.newLineStyles);
                numFillBits = (int)input.readUBits(4);
                shape.setNumFillBits(numFillBits);
                numLineBits = (int)input.readUBits(4);
                shape.setNumLineBits(numLineBits);
            }
        }

        public void write(SWFOutputStream swf, int numFillBits, int numLineBits, boolean hasAlpha) throws IOException {
            int state = 0;
            if (this.newFillStyles != null) {
                state |= 0x10;
            }
            if (this.lineStyle != -1) {
                state |= 8;
            }
            if (this.fillStyle1 != -1) {
                state |= 4;
            }
            if (this.fillStyle0 != -1) {
                state |= 2;
            }
            if (this.move) {
                state |= 1;
            }
            swf.writeUBits(state, 6);
            if (this.move) {
                int numMoveBits = Math.max(SWFOutputStream.minBits((long)this.moveX, (boolean)true), SWFOutputStream.minBits((long)this.moveY, (boolean)true));
                swf.writeUBits(numMoveBits, 5);
                swf.writeSBits(this.moveX, numMoveBits);
                swf.writeSBits(this.moveY, numMoveBits);
            }
            if (this.fillStyle0 != -1) {
                swf.writeUBits(this.fillStyle0, numFillBits);
            }
            if (this.fillStyle1 != -1) {
                swf.writeUBits(this.fillStyle1, numFillBits);
            }
            if (this.lineStyle != -1) {
                swf.writeUBits(this.lineStyle, numLineBits);
            }
            if (this.newFillStyles != null) {
                this.newFillStyles.write(swf, hasAlpha);
                this.newLineStyles.write(swf, hasAlpha);
                swf.writeUBits(numFillBits, 4);
                swf.writeUBits(numLineBits, 4);
            }
        }

        public int getNumFillBits() {
            int numFillBits = 0;
            if (this.fillStyle0 != -1) {
                numFillBits = Math.max(numFillBits, BitOutputStream.minBits((long)this.fillStyle0));
            }
            if (this.fillStyle1 != -1) {
                numFillBits = Math.max(numFillBits, BitOutputStream.minBits((long)this.fillStyle1));
            }
            return numFillBits;
        }

        public int getNumLineBits() {
            return this.lineStyle != -1 ? BitOutputStream.minBits((long)this.lineStyle) : 0;
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            if (this.move) {
                s.append("moveto(" + this.moveX + ", " + this.moveY + "); ");
            }
            if (this.fillStyle0 != -1) {
                s.append("fillStyle0=" + this.fillStyle0 + "; ");
            }
            if (this.fillStyle1 != -1) {
                s.append("fillStyle1=" + this.fillStyle1 + "; ");
            }
            if (this.lineStyle != -1) {
                s.append("lineStyle=" + this.lineStyle + "; ");
            }
            if (this.newFillStyles != null || this.newLineStyles != null) {
                s.append("More Styles;\n");
            }
            if (this.newFillStyles != null) {
                s.append(this.newFillStyles.toString());
            }
            if (this.newLineStyles != null) {
                s.append(this.newLineStyles.toString());
            }
            return s.toString();
        }
    }

    public static abstract class Record {
        public abstract void write(SWFOutputStream var1, int var2, int var3, boolean var4) throws IOException;
    }
}

