/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import org.baderlab.brain.ProteinTerminus;

public class ProteinDatabaseSearchParams {
    private ProteinTerminus terminus = null;
    private Integer length = null;
    private boolean multipleHits = false;
    private Boolean normalized = null;
    private int scoreType = -1;
    public static final int SCORE_TYPE_PROBABILITY = 1;
    public static final int SCORE_TYPE_NORM_PROBABILITY = 2;
    public static final int SCORE_TYPE_DELTAG = 3;
    private boolean dontSaveSequences = false;

    public ProteinDatabaseSearchParams(boolean multipleHits) {
        this.multipleHits = multipleHits;
        this.terminus = ProteinTerminus.NONE;
    }

    public ProteinDatabaseSearchParams(ProteinTerminus terminus, int length) {
        this.terminus = terminus;
        this.length = new Integer(length);
        this.multipleHits = true;
    }

    public ProteinDatabaseSearchParams(ProteinTerminus terminus) {
        this.terminus = terminus;
        this.multipleHits = false;
    }

    public void setNormalized(boolean normalized) {
        this.normalized = new Boolean(normalized);
    }

    public void setScoreType(int scoreType) {
        this.scoreType = scoreType;
    }

    public int getScoreType() {
        return this.scoreType;
    }

    public ProteinTerminus getTerminus() {
        return this.terminus;
    }

    public int getLength() {
        if (this.length == null) {
            return -1;
        }
        return this.length;
    }

    public boolean isMultipleHits() {
        return this.multipleHits;
    }

    public boolean isNormalized() {
        if (this.normalized == null) {
            return false;
        }
        return this.normalized;
    }

    public boolean isNormalizedSet() {
        return this.normalized != null;
    }

    public void setTerminus(ProteinTerminus terminus) {
        this.terminus = terminus;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public void setMultipleHits(boolean multipleHits) {
        this.multipleHits = multipleHits;
    }

    public boolean isDontSaveSequences() {
        return this.dontSaveSequences;
    }

    public void setDontSaveSequences(boolean dontSaveSequences) {
        this.dontSaveSequences = dontSaveSequences;
    }

    public ProteinDatabaseSearchParams copy() {
        ProteinDatabaseSearchParams newParams = new ProteinDatabaseSearchParams(this.multipleHits);
        newParams.normalized = this.normalized;
        newParams.length = this.length;
        newParams.terminus = this.terminus;
        newParams.scoreType = this.scoreType;
        return newParams;
    }

    public String toString() {
        String lineSep = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("Sequence search: " + (this.terminus.equals(ProteinTerminus.NONE) ? " Whole sequence" : " Sequence subset (" + this.terminus + " terminus " + this.length + " residues)") + lineSep);
        sb.append("Multiple hits allowed: " + (this.multipleHits ? "True" : "False") + lineSep);
        sb.append("Score type: ");
        switch (this.scoreType) {
            case 1: {
                sb.append("Probability");
            }
            case 2: {
                sb.append("Normalized Probability");
            }
            case 3: {
                sb.append("Delta G Style");
            }
        }
        sb.append("Unknown score type");
        sb.append(lineSep);
        return sb.toString();
    }
}

