/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import java.io.Serializable;
import org.baderlab.brain.ProteinProfile;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.ScoreType;
import org.biojava.bio.dp.WeightMatrix;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceAnnotator;
import org.biojava.bio.seq.impl.ViewSequence;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;

public class NormalizedProfileAnnotator
implements SequenceAnnotator,
Serializable {
    private ProteinProfile profile;
    private WeightMatrix matrix;
    private double threshold;
    private final ScoreType scoreType;

    public Sequence annotate(Sequence seq) throws IllegalAlphabetException, BioException, ChangeVetoException {
        seq = new ViewSequence(seq);
        int cols = this.matrix.columns();
        Feature.Template template = new Feature.Template();
        template.source = "NormalizedProfileAnnotator";
        for (int offset = 1; offset <= seq.length() - cols + 1; ++offset) {
            double score = DP.scoreWeightMatrix((WeightMatrix)this.matrix, (SymbolList)seq, (ScoreType)this.scoreType, (int)offset);
            double qraw = Math.exp(score);
            double q = this.profile.getNormalizedPValue(qraw);
            if (q > 1.0) {
                q = 1.0;
            }
            if (!(q >= this.threshold)) continue;
            template.location = new RangeLocation(offset, offset + cols - 1);
            SimpleAnnotation ann = new SimpleAnnotation();
            ann.setProperty((Object)"score", (Object)new Double(q));
            ann.setProperty((Object)"raw_score", (Object)new Double(qraw));
            template.annotation = ann;
            seq.createFeature(template);
        }
        return seq;
    }

    public NormalizedProfileAnnotator(ProteinProfile profile, double threshold) {
        this.profile = profile;
        this.matrix = profile.getWeightMatrix();
        this.threshold = threshold;
        this.scoreType = ScoreType.PROBABILITY;
    }
}

