/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import java.util.Collection;
import java.util.HashMap;
import org.baderlab.brain.ProteinProfile;
import org.baderlab.brain.SequenceSearchResultSet;

public class MultiSequenceSearchResultSet {
    private HashMap resultSets = new HashMap();

    public void add(SequenceSearchResultSet results) {
        if (results.getProfile() != null) {
            this.resultSets.put(results.getProfile(), results);
        } else if (results.getRegex() != null) {
            this.resultSets.put(results.getRegex(), results);
        } else {
            throw new RuntimeException("No profile or regular expression set in the result set.");
        }
    }

    public Collection getAllResultSets() {
        return this.resultSets.values();
    }

    public SequenceSearchResultSet getResultSet(ProteinProfile profile) {
        return (SequenceSearchResultSet)this.resultSets.get(profile);
    }

    public SequenceSearchResultSet getResultSet(String regex) {
        return (SequenceSearchResultSet)this.resultSets.get(regex);
    }

    public void clear() {
        Collection results = this.getAllResultSets();
        for (SequenceSearchResultSet sequenceSearchResultSet : results) {
            sequenceSearchResultSet.clear();
        }
        this.resultSets.clear();
    }
}

