/*
 * Decompiled with CFR 0.152.
 */
package BiNGO;

import BiNGO.ChooseAnnotationPanel;
import BiNGO.ChooseOntologyPanel;
import BiNGO.HelpButtonActionListener;
import BiNGO.OverUnderPanel;
import BiNGO.SettingsPanelActionListener;
import BiNGO.SettingsSavePanel;
import BiNGO.TextOrGraphPanel;
import BiNGO.TypeOfIdentifierPanel;
import BiNGO.VizPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SettingsPanel
extends JPanel {
    private final int DIM_HEIGHT = 600;
    private final int DIM_WIDTH = 550;
    private String bingoDir;
    private final String[] testsArray = new String[]{"---", "Hypergeometric test", "Binomial test"};
    private final String[] correctionArray = new String[]{"---", "Benjamini & Hochberg False Discovery Rate (FDR) correction", "Bonferroni Family-Wise Error Rate (FWER) correction"};
    private final String[] categoriesArray = new String[]{"---", "All categories", "Overrepresented categories before correction", "Overrepresented categories after correction"};
    private final String[] clusterVsArray = new String[]{"---", "Test cluster versus complete annotation", "Test cluster versus network"};
    private JButton helpButton;
    private TextOrGraphPanel textOrGraphPanel;
    private OverUnderPanel overUnderPanel;
    private VizPanel vizPanel;
    private JComboBox testBox;
    private JComboBox correctionBox;
    private JComboBox categoriesBox;
    private JComboBox clusterVsBox;
    private JTextField alphaField;
    private JLabel nameLabel;
    private JLabel overUnderLabel;
    private JLabel testLabel;
    private JLabel correctionLabel;
    private JLabel alphaLabel;
    private JLabel ontologyLabel;
    private JLabel annotationLabel;
    private JLabel categoriesLabel;
    private JLabel clusterVsLabel;
    private JButton bingoButton;
    private ChooseAnnotationPanel annotationPanel;
    private TypeOfIdentifierPanel typeOfIdentifierPanel;
    private ChooseOntologyPanel ontologyPanel;
    private JTextField nameField;
    private SettingsSavePanel dataPanel;

    public SettingsPanel(String bingoDir) {
        this.bingoDir = bingoDir;
        this.makeJComponents();
        this.setPreferredSize(new Dimension(550, 600));
        this.setOpaque(false);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "BiNGO settings", 0, 0, new Font("BiNGO settings", 1, 16), Color.black));
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 2;
        JPanel dummyPanel = new JPanel();
        dummyPanel.setOpaque(false);
        dummyPanel.setPreferredSize(new Dimension(50, 20));
        JButton infoButton = new JButton("Info");
        c.gridx = 0;
        gridbag.setConstraints(dummyPanel, c);
        this.add(dummyPanel);
        c.gridx = 1;
        c.fill = 0;
        c.anchor = 13;
        gridbag.setConstraints(this.helpButton, c);
        this.add(this.helpButton);
        JPanel dummyPanel2 = new JPanel();
        dummyPanel2.setOpaque(false);
        dummyPanel2.setPreferredSize(new Dimension(50, 20));
        c.gridx = 2;
        c.fill = 2;
        c.anchor = 10;
        c.gridwidth = 0;
        gridbag.setConstraints(dummyPanel2, c);
        this.add(dummyPanel2);
        c.weighty = 1.0;
        c.weightx = 100.0;
        c.gridx = 1;
        c.gridwidth = -1;
        c.fill = 2;
        gridbag.setConstraints(this.nameLabel, c);
        this.add(this.nameLabel);
        gridbag.setConstraints(this.nameField, c);
        this.add(this.nameField);
        c.fill = 1;
        c.gridheight = 1;
        c.weighty = 10.0;
        gridbag.setConstraints(this.textOrGraphPanel, c);
        this.add(this.textOrGraphPanel);
        c.fill = 2;
        c.gridheight = 1;
        c.weighty = 1.0;
        gridbag.setConstraints(this.overUnderLabel, c);
        this.add(this.overUnderLabel);
        gridbag.setConstraints(this.overUnderPanel, c);
        this.add(this.overUnderPanel);
        gridbag.setConstraints(this.vizPanel, c);
        this.add(this.vizPanel);
        gridbag.setConstraints(this.testLabel, c);
        this.add(this.testLabel);
        gridbag.setConstraints(this.testBox, c);
        this.add(this.testBox);
        gridbag.setConstraints(this.correctionLabel, c);
        this.add(this.correctionLabel);
        gridbag.setConstraints(this.correctionBox, c);
        this.add(this.correctionBox);
        gridbag.setConstraints(this.alphaLabel, c);
        this.add(this.alphaLabel);
        gridbag.setConstraints(this.alphaField, c);
        this.add(this.alphaField);
        gridbag.setConstraints(this.categoriesLabel, c);
        this.add(this.categoriesLabel);
        gridbag.setConstraints(this.categoriesBox, c);
        this.add(this.categoriesBox);
        gridbag.setConstraints(this.clusterVsLabel, c);
        this.add(this.clusterVsLabel);
        gridbag.setConstraints(this.clusterVsBox, c);
        this.add(this.clusterVsBox);
        gridbag.setConstraints(this.ontologyLabel, c);
        this.add(this.ontologyLabel);
        gridbag.setConstraints(this.ontologyPanel, c);
        this.add(this.ontologyPanel);
        gridbag.setConstraints(this.annotationLabel, c);
        this.add(this.annotationLabel);
        gridbag.setConstraints(this.annotationPanel, c);
        this.add(this.annotationPanel);
        gridbag.setConstraints(this.dataPanel, c);
        this.add(this.dataPanel);
        gridbag.setConstraints(this.bingoButton, c);
        this.add(this.bingoButton);
        this.validate();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public void makeJComponents() {
        this.helpButton = new JButton("Help");
        this.helpButton.setMnemonic(72);
        this.helpButton.addActionListener(new HelpButtonActionListener(this));
        this.testBox = new JComboBox<String>(this.testsArray);
        this.testBox.setSelectedItem("Hypergeometric test");
        this.correctionBox = new JComboBox<String>(this.correctionArray);
        this.correctionBox.setSelectedItem("Benjamini & Hochberg False Discovery Rate (FDR) correction");
        this.categoriesBox = new JComboBox<String>(this.categoriesArray);
        this.categoriesBox.setSelectedItem("Overrepresented categories after correction");
        this.clusterVsBox = new JComboBox<String>(this.clusterVsArray);
        this.clusterVsBox.setSelectedItem("Test cluster versus complete annotation");
        this.alphaField = new JTextField("0.05");
        this.nameField = new JTextField();
        this.overUnderPanel = new OverUnderPanel();
        this.vizPanel = new VizPanel();
        this.textOrGraphPanel = new TextOrGraphPanel();
        this.overUnderLabel = new JLabel("Do you want to assess over- or underrepresentation :");
        this.nameLabel = new JLabel("Cluster name :");
        this.testLabel = new JLabel("Select a statistical test :");
        this.correctionLabel = new JLabel("Select a multiple testing correction :");
        this.alphaLabel = new JLabel("Choose a significance level :");
        this.categoriesLabel = new JLabel("Select the categories to be visualized :");
        this.clusterVsLabel = new JLabel("Select reference set :");
        this.testLabel.setForeground(Color.black);
        this.correctionLabel.setForeground(Color.black);
        this.alphaLabel.setForeground(Color.black);
        this.categoriesLabel.setForeground(Color.black);
        this.clusterVsLabel.setForeground(Color.black);
        this.annotationLabel = new JLabel("Select organism/annotation and gene identifier:");
        this.annotationPanel = new ChooseAnnotationPanel(this, this.bingoDir);
        this.typeOfIdentifierPanel = this.annotationPanel.getTypeOfIdentifierPanel();
        this.ontologyLabel = new JLabel("Select ontology :");
        this.ontologyPanel = new ChooseOntologyPanel(this, this.bingoDir);
        this.dataPanel = new SettingsSavePanel("Data", this, this.bingoDir);
        this.bingoButton = new JButton("Start BiNGO");
        this.bingoButton.setMnemonic(66);
        this.bingoButton.addActionListener(new SettingsPanelActionListener(this));
    }

    TextOrGraphPanel getTextOrGraphPanel() {
        return this.textOrGraphPanel;
    }

    OverUnderPanel getOverUnderPanel() {
        return this.overUnderPanel;
    }

    VizPanel getVizPanel() {
        return this.vizPanel;
    }

    JComboBox getTestBox() {
        return this.testBox;
    }

    JComboBox getCorrectionBox() {
        return this.correctionBox;
    }

    JComboBox getCategoriesBox() {
        return this.categoriesBox;
    }

    JComboBox getClusterVsBox() {
        return this.clusterVsBox;
    }

    JTextField getAlphaField() {
        return this.alphaField;
    }

    JTextField getNameField() {
        return this.nameField;
    }

    TypeOfIdentifierPanel getTypeOfIdentifierPanel() {
        return this.typeOfIdentifierPanel;
    }

    ChooseAnnotationPanel getAnnotationPanel() {
        return this.annotationPanel;
    }

    ChooseOntologyPanel getOntologyPanel() {
        return this.ontologyPanel;
    }

    SettingsSavePanel getDataPanel() {
        return this.dataPanel;
    }

    String getBingoDir() {
        return this.bingoDir;
    }
}

