/*
 * Decompiled with CFR 0.152.
 */
package BiNGO;

import BiNGO.SignificantFigures;
import cytoscape.data.annotation.Annotation;
import cytoscape.data.annotation.Ontology;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class CreateBiNGOFile {
    private HashMap testMap;
    private HashMap correctionMap;
    private HashMap mapSmallX;
    private HashMap mapSmallN;
    private int bigX;
    private int bigN;
    private String alphaString;
    private String testString;
    private String correctionString;
    private String overUnderString;
    private Annotation annotation;
    private Ontology ontology;
    private String annotationFile;
    private String ontologyFile;
    private String dirName;
    private String fileName;
    private String clusterVsString;
    private String catString;
    private Vector selectedCanonicalNameVector;
    private HashMap annotatedGenes;
    private final String NONE = "---";
    private final String CATEGORY_ALL = "All categories";
    private final String CATEGORY_BEFORE_CORRECTION = "Overrepresented categories before correction";
    private final String CATEGORY_CORRECTION = "Overrepresented categories after correction";

    CreateBiNGOFile(HashMap testMap, HashMap correctionMap, HashMap mapSmallX, HashMap mapSmallN, int bigX, int bigN, String alphaString, Annotation annotation, Ontology ontology, String annotationFile, String ontologyFile, String testString, String correctionString, String overUnderString, String dirName, String fileName, String clusterVsString, String catString, Vector selectedCanonicalNameVector) {
        this.testMap = testMap;
        this.correctionMap = correctionMap;
        this.mapSmallX = mapSmallX;
        this.mapSmallN = mapSmallN;
        this.bigX = bigX;
        this.bigN = bigN;
        this.alphaString = alphaString;
        this.annotation = annotation;
        this.ontology = ontology;
        this.annotationFile = annotationFile;
        this.ontologyFile = ontologyFile;
        this.testString = testString;
        this.correctionString = correctionString;
        this.overUnderString = overUnderString;
        this.dirName = dirName;
        this.fileName = fileName;
        this.clusterVsString = clusterVsString;
        this.catString = catString;
        this.selectedCanonicalNameVector = selectedCanonicalNameVector;
        this.annotatedGenes = new HashMap();
    }

    void makeFile() {
        String dateString = DateFormat.getDateInstance().format(new Date());
        String timeString = DateFormat.getTimeInstance().format(new Date());
        try {
            File results = new File(this.dirName, this.fileName);
            BufferedWriter output = new BufferedWriter(new FileWriter(results));
            System.out.println("BiNGO results file : " + results.getPath());
            output.write("File created with BiNGO (c) on " + dateString + " at " + timeString + "\n");
            output.write("\n");
            output.write(this.ontology.toString());
            output.write("\n");
            output.write("Selected ontology file : " + this.ontologyFile + "\n");
            output.write("Selected annotation file : " + this.annotationFile + "\n");
            output.write(this.overUnderString + "\n");
            output.write("Selected statistical test : " + this.testString + "\n");
            output.write("Selected correction : " + this.correctionString + "\n");
            output.write("Selected significance level : " + this.alphaString + "\n");
            output.write("\n");
            output.write("Testing option : " + this.clusterVsString + "\n");
            output.write("\n");
            output.write("The selected cluster :\n");
            int j = 1;
            for (int i = 0; i < this.selectedCanonicalNameVector.size(); ++i) {
                int[] nodeClassifications = this.annotation.getClassifications(this.selectedCanonicalNameVector.get(i).toString());
                for (int k = 0; k < nodeClassifications.length; ++k) {
                    String cat = new Integer(nodeClassifications[k]).toString();
                    if (!this.annotatedGenes.containsKey(cat)) {
                        HashSet catset = new HashSet();
                        this.annotatedGenes.put(cat, catset);
                    }
                    ((HashSet)this.annotatedGenes.get(cat)).add(this.selectedCanonicalNameVector.get(i).toString());
                }
                output.write(this.selectedCanonicalNameVector.get(i).toString() + "\t");
                if (j == 255) {
                    output.write("\n");
                    j = 0;
                }
                ++j;
            }
            output.write("\n");
            output.write("\n");
            output.write("Number of genes selected : " + this.bigX + "\n");
            output.write("Total number of genes in annotation : " + this.bigN + "\n");
            output.write("\n");
            if (this.testString.equals("---")) {
                output.write("GO-ID\t# selected\t# total\tDescription\tGenes in test set\n");
            } else if (this.correctionString.equals("---")) {
                output.write("GO-ID\tp-value\t# selected\t# total\tDescription\tGenes in test set\n");
            } else {
                output.write("GO-ID\tp-value\tcorr p-value# selected\t# total\tDescription\tGenes in test set\n");
            }
            HashSet keySet = !this.testString.equals("---") ? new HashSet(this.testMap.keySet()) : new HashSet(this.mapSmallX.keySet());
            Iterator it = keySet.iterator();
            String[] keyLabels = new String[keySet.size()];
            int i = 0;
            while (it.hasNext()) {
                keyLabels[i] = it.next().toString();
                ++i;
            }
            String[] ordenedKeySet = !this.testString.equals("---") ? this.ordenKeysByPvalues(keyLabels) : this.ordenKeysBySmallX(keyLabels);
            boolean ok = true;
            for (int i2 = 0; i2 < ordenedKeySet.length && ok; ++i2) {
                Iterator k;
                String description;
                String smallN;
                String smallX;
                String termID = ordenedKeySet[i2];
                String pvalue = "";
                String correctedPvalue = "";
                if (!this.testString.equals("---")) {
                    try {
                        pvalue = SignificantFigures.sci_format(this.testMap.get(new Integer(termID)).toString(), 5);
                    }
                    catch (Exception e) {
                        pvalue = "N/A";
                    }
                } else {
                    pvalue = "N/A";
                }
                if (!this.correctionString.equals("---")) {
                    try {
                        correctedPvalue = SignificantFigures.sci_format(this.correctionMap.get(termID).toString(), 5);
                    }
                    catch (Exception e) {
                        correctedPvalue = "N/A";
                    }
                } else {
                    correctedPvalue = "N/A";
                }
                try {
                    smallX = this.mapSmallX.get(new Integer(termID)).toString();
                }
                catch (Exception e) {
                    smallX = "N/A";
                }
                try {
                    smallN = this.mapSmallN.get(new Integer(termID)).toString();
                }
                catch (Exception e) {
                    smallN = "N/A";
                }
                try {
                    description = this.ontology.getTerm(Integer.parseInt(termID)).getName();
                }
                catch (Exception e) {
                    description = "?";
                }
                if (this.testString.equals("---")) {
                    output.write(termID + "\t" + smallX + "\t" + smallN + "\t" + description + "\t");
                    if (this.annotatedGenes.containsKey(termID)) {
                        k = ((HashSet)this.annotatedGenes.get(termID)).iterator();
                        while (k.hasNext()) {
                            output.write(k.next().toString());
                            if (!k.hasNext()) continue;
                            output.write(124);
                        }
                    }
                    output.write("\n");
                    continue;
                }
                if (this.correctionString.equals("---")) {
                    if (this.catString.equals("Overrepresented categories before correction")) {
                        if (new BigDecimal(this.testMap.get(new Integer(ordenedKeySet[i2])).toString()).compareTo(new BigDecimal(this.alphaString)) < 0) {
                            output.write(termID + "\t" + pvalue + "\t" + smallX + "\t" + smallN + "\t" + description + "\t");
                            if (this.annotatedGenes.containsKey(termID)) {
                                k = ((HashSet)this.annotatedGenes.get(termID)).iterator();
                                while (k.hasNext()) {
                                    output.write(k.next().toString());
                                    if (!k.hasNext()) continue;
                                    output.write(124);
                                }
                            }
                            output.write("\n");
                            continue;
                        }
                        ok = false;
                        continue;
                    }
                    output.write(termID + "\t" + pvalue + "\t" + smallX + "\t" + smallN + "\t" + description + "\t");
                    if (this.annotatedGenes.containsKey(termID)) {
                        k = ((HashSet)this.annotatedGenes.get(termID)).iterator();
                        while (k.hasNext()) {
                            output.write(k.next().toString());
                            if (!k.hasNext()) continue;
                            output.write(124);
                        }
                    }
                    output.write("\n");
                    continue;
                }
                if (this.catString.equals("Overrepresented categories after correction")) {
                    if (new BigDecimal(this.correctionMap.get(ordenedKeySet[i2]).toString()).compareTo(new BigDecimal(this.alphaString)) < 0) {
                        output.write(termID + "\t" + pvalue + "\t" + correctedPvalue + "\t" + smallX + "\t" + smallN + "\t" + description + "\t");
                        if (this.annotatedGenes.containsKey(termID)) {
                            k = ((HashSet)this.annotatedGenes.get(termID)).iterator();
                            while (k.hasNext()) {
                                output.write(k.next().toString());
                                if (!k.hasNext()) continue;
                                output.write(124);
                            }
                        }
                        output.write("\n");
                        continue;
                    }
                    ok = false;
                    continue;
                }
                if (this.catString.equals("Overrepresented categories before correction")) {
                    if (new BigDecimal(this.testMap.get(new Integer(ordenedKeySet[i2])).toString()).compareTo(new BigDecimal(this.alphaString)) < 0) {
                        output.write(termID + "\t" + pvalue + "\t" + correctedPvalue + "\t" + smallX + "\t" + smallN + "\t" + description + "\t");
                        if (this.annotatedGenes.containsKey(termID)) {
                            k = ((HashSet)this.annotatedGenes.get(termID)).iterator();
                            while (k.hasNext()) {
                                output.write(k.next().toString());
                                if (!k.hasNext()) continue;
                                output.write(124);
                            }
                        }
                        output.write("\n");
                        continue;
                    }
                    ok = false;
                    continue;
                }
                output.write(termID + "\t" + pvalue + "\t" + correctedPvalue + "\t" + smallX + "\t" + smallN + "\t" + description + "\t");
                if (this.annotatedGenes.containsKey(termID)) {
                    k = ((HashSet)this.annotatedGenes.get(termID)).iterator();
                    while (k.hasNext()) {
                        output.write(k.next().toString());
                        if (!k.hasNext()) continue;
                        output.write(124);
                    }
                }
                output.write("\n");
            }
            output.close();
        }
        catch (Exception e) {
            System.out.println("Error: " + e);
        }
    }

    public String[] ordenKeysByPvalues(String[] labels) {
        for (int i = 1; i < labels.length; ++i) {
            String insert_label = labels[i];
            BigDecimal val = new BigDecimal(this.testMap.get(new Integer(labels[i])).toString());
            for (int j = i; j > 0 && val.compareTo(new BigDecimal(this.testMap.get(new Integer(labels[j - 1])).toString())) < 0; --j) {
                labels[j] = labels[j - 1];
            }
            labels[j] = insert_label;
        }
        return labels;
    }

    public String[] ordenKeysBySmallX(String[] labels) {
        for (int i = 1; i < labels.length; ++i) {
            String insert_label = labels[i];
            BigDecimal val = new BigDecimal(this.mapSmallX.get(new Integer(labels[i])).toString());
            for (int j = i; j > 0 && val.compareTo(new BigDecimal(this.mapSmallX.get(new Integer(labels[j - 1])).toString())) > 0; --j) {
                labels[j] = labels[j - 1];
            }
            labels[j] = insert_label;
        }
        return labels;
    }
}

