/*
 * Decompiled with CFR 0.152.
 */
package BiNGO;

import BiNGO.CalculateCorrectionTask;
import BiNGO.SwingWorker;
import java.math.BigDecimal;

public class BenjaminiHochbergFDR
implements CalculateCorrectionTask {
    private static String[] goLabels;
    private static String[] pvalues;
    private static String[] ordenedGOLabels;
    private static String[] ordenedPvalues;
    private static String[] adjustedPvalues;
    private static BigDecimal alpha;
    private static int m;
    private static final int RESULT_SCALE = 100;
    protected int currentProgress;
    protected int lengthOfTask;
    protected String statusMessage;
    protected boolean done;
    protected boolean canceled;

    public BenjaminiHochbergFDR(String[] pvalues, String[] goLabels, String alpha) {
        BenjaminiHochbergFDR.pvalues = pvalues;
        BenjaminiHochbergFDR.goLabels = goLabels;
        BenjaminiHochbergFDR.alpha = new BigDecimal(alpha);
        m = pvalues.length;
        adjustedPvalues = new String[m];
        this.currentProgress = 0;
        this.lengthOfTask = pvalues.length;
        this.done = false;
        this.canceled = false;
    }

    public void calculate() {
        this.currentProgress = 0;
        this.lengthOfTask = pvalues.length;
        this.done = false;
        this.canceled = false;
        ordenedPvalues = this.ordenArrayStrings(pvalues);
        BigDecimal min = new BigDecimal("1");
        for (int i = m; i > 0; --i) {
            BigDecimal mkprk = new BigDecimal("" + m).multiply(new BigDecimal(ordenedPvalues[i - 1])).divide(new BigDecimal("" + i), 100, 4);
            if (mkprk.compareTo(min) < 0) {
                min = mkprk;
            }
            BenjaminiHochbergFDR.adjustedPvalues[i - 1] = min.toString();
        }
        this.currentProgress = this.lengthOfTask;
        this.done = true;
    }

    public String[] ordenArrayStrings(String[] data) {
        String[] tempGOLabels = goLabels;
        for (int i = 1; i < data.length; ++i) {
            ++this.currentProgress;
            double percentDone = this.currentProgress * 100 / this.lengthOfTask;
            this.statusMessage = "Completed " + percentDone + "%.";
            BigDecimal val = new BigDecimal(data[i]);
            String valGOLabel = tempGOLabels[i];
            for (int j = i; j > 0 && val.compareTo(new BigDecimal(data[j - 1])) < 0; --j) {
                data[j] = data[j - 1];
                tempGOLabels[j] = tempGOLabels[j - 1];
            }
            data[j] = val.toString();
            tempGOLabels[j] = valGOLabel;
        }
        ordenedGOLabels = tempGOLabels;
        return data;
    }

    public String[] getOrdenedPvalues() {
        return ordenedPvalues;
    }

    public String[] getAdjustedPvalues() {
        return adjustedPvalues;
    }

    public String[] getOrdenedGOLabels() {
        return ordenedGOLabels;
    }

    public int getCurrentProgress() {
        return this.currentProgress;
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public String getTaskDescription() {
        return "Calculating FDR Corrections";
    }

    public String getCurrentStatusMessage() {
        return this.statusMessage;
    }

    public boolean isDone() {
        return this.done;
    }

    public void stop() {
        this.canceled = true;
        this.statusMessage = null;
    }

    public boolean wasCanceled() {
        return this.canceled;
    }

    public void start(boolean return_when_done) {
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                return new DoTask();
            }
        };
        worker.start();
        if (return_when_done) {
            worker.get();
        }
    }

    class DoTask {
        DoTask() {
            BenjaminiHochbergFDR.this.calculate();
        }
    }
}

