/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.automata;

import java.util.Iterator;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.automata.AutomatonException;
import org.biojava.utils.automata.DfaBuilder;
import org.biojava.utils.automata.FiniteAutomaton;
import org.biojava.utils.automata.Nfa;
import org.biojava.utils.automata.NfaBuilder;
import org.biojava.utils.automata.NfaSubModel;

public class PatternMaker {
    private Nfa nfa;
    private Tokenizer toke;
    private FiniteAlphabet alfa;
    private SymbolTokenization symtoke;

    PatternMaker(String patternString, FiniteAlphabet alfa) throws BioException {
        this.alfa = alfa;
        this.toke = new Tokenizer(patternString);
        this.nfa = new Nfa(patternString, alfa);
        this.symtoke = alfa.getTokenization("token");
    }

    static FiniteAutomaton compilePattern(String patternString, FiniteAlphabet alfa) throws BioException, AutomatonException {
        PatternMaker maker = new PatternMaker(patternString, alfa);
        return maker.parse();
    }

    private FiniteAutomaton parse() throws AutomatonException {
        NfaSubModel result = this.parse(this.nfa);
        this.nfa.addEpsilonTransition(this.nfa.getStart(), result.getStart());
        this.nfa.addEpsilonTransition(result.getEnd(), this.nfa.getEnd());
        this.nfa.doEpsilonClosure();
        return new DfaBuilder(this.nfa).getDFA();
    }

    private NfaSubModel parse(NfaBuilder delegate) throws AutomatonException {
        NfaSubModel returnSubModel = new NfaSubModel(delegate);
        NfaSubModel branchSubModel = new NfaSubModel(returnSubModel);
        branchSubModel.addEpsilonTransition(branchSubModel.getStart(), branchSubModel.getEnd());
        boolean gotContent = false;
        block6: while (this.toke.hasNext()) {
            int tokenType = this.toke.nextTokenType();
            NfaSubModel currSubModel = null;
            switch (tokenType) {
                case 5: {
                    gotContent = true;
                    currSubModel = this.parseSubPattern(branchSubModel);
                    Range times = this.parseIterations();
                    currSubModel = this.reiterate(currSubModel, branchSubModel, times);
                    branchSubModel.append(currSubModel);
                    continue block6;
                }
                case 0: {
                    gotContent = true;
                    currSubModel = this.parseSymbol(branchSubModel);
                    Range times = this.parseIterations();
                    currSubModel = this.reiterate(currSubModel, branchSubModel, times);
                    branchSubModel.append(currSubModel);
                    continue block6;
                }
                case 9: {
                    if (!gotContent) {
                        throw new AutomatonException("no content in this branch!");
                    }
                    System.out.println(returnSubModel.getStart().getID() + " " + branchSubModel.getStart().getID());
                    returnSubModel.addEpsilonTransition(returnSubModel.getStart(), branchSubModel.getStart());
                    returnSubModel.addEpsilonTransition(branchSubModel.getEnd(), returnSubModel.getEnd());
                    branchSubModel = new NfaSubModel(returnSubModel);
                    branchSubModel.addEpsilonTransition(branchSubModel.getStart(), branchSubModel.getEnd());
                    gotContent = false;
                    this.toke.getToken();
                    continue block6;
                }
                case 6: {
                    if (!gotContent) {
                        throw new AutomatonException("no content in this branch!");
                    }
                    returnSubModel.addEpsilonTransition(returnSubModel.getStart(), branchSubModel.getStart());
                    returnSubModel.addEpsilonTransition(branchSubModel.getEnd(), returnSubModel.getEnd());
                    return returnSubModel;
                }
            }
            throw new AutomatonException("Illegal symbol encountered: " + this.toke.peekToken());
        }
        if (gotContent) {
            returnSubModel.addEpsilonTransition(returnSubModel.getStart(), branchSubModel.getStart());
            returnSubModel.addEpsilonTransition(branchSubModel.getEnd(), returnSubModel.getEnd());
            return returnSubModel;
        }
        throw new AutomatonException("no content in this branch!");
    }

    NfaSubModel parseSubPattern(NfaBuilder delegate) throws AutomatonException {
        this.toke.getToken();
        NfaSubModel returnSubModel = this.parse(delegate);
        if (this.toke.nextTokenType() != 6) {
            throw new AutomatonException("Missing right bracket!");
        }
        this.toke.getToken();
        return returnSubModel;
    }

    NfaSubModel parseSymbol(NfaBuilder delegate) throws AutomatonException {
        Symbol sym;
        NfaSubModel returnSubModel = new NfaSubModel(delegate);
        try {
            sym = this.symtoke.parseToken(Character.toString(this.toke.getToken()));
        }
        catch (IllegalSymbolException ise) {
            throw new AutomatonException(ise);
        }
        FiniteAutomaton.Node pre = returnSubModel.addNode(false);
        FiniteAutomaton.Node post = returnSubModel.addNode(false);
        if (sym instanceof AtomicSymbol) {
            returnSubModel.addTransition(pre, post, sym);
            returnSubModel.addEpsilonTransition(returnSubModel.getStart(), pre);
            returnSubModel.addEpsilonTransition(post, returnSubModel.getEnd());
        } else {
            Iterator symI = ((FiniteAlphabet)sym.getMatches()).iterator();
            while (symI.hasNext()) {
                Symbol atomicSym = (Symbol)symI.next();
                returnSubModel.addTransition(pre, post, atomicSym);
                returnSubModel.addEpsilonTransition(returnSubModel.getStart(), pre);
                returnSubModel.addEpsilonTransition(post, returnSubModel.getEnd());
            }
        }
        return returnSubModel;
    }

    Range parseIterations() throws AutomatonException {
        int tokenType = this.toke.nextTokenType();
        switch (tokenType) {
            case 2: {
                return this.getIterations();
            }
            case 7: {
                this.toke.getToken();
                return new Range(1, Integer.MAX_VALUE);
            }
            case 8: {
                this.toke.getToken();
                return new Range(0, Integer.MAX_VALUE);
            }
        }
        return new Range(1, 1);
    }

    private Range getIterations() throws AutomatonException {
        int min = 0;
        int max = 0;
        this.toke.getToken();
        boolean onSecondArg = false;
        StringBuffer numString = new StringBuffer();
        block5: while (this.toke.hasNext()) {
            int tokenType = this.toke.nextTokenType();
            switch (tokenType) {
                case 1: {
                    if (numString == null) {
                        numString = new StringBuffer();
                    }
                    numString.append(this.toke.getToken());
                    continue block5;
                }
                case 4: {
                    this.toke.getToken();
                    if (!onSecondArg) {
                        min = numString.length() > 0 ? Integer.parseInt(numString.toString()) : 0;
                        numString = null;
                        onSecondArg = true;
                        continue block5;
                    }
                    throw new AutomatonException("only two arguments permitted.");
                }
                case 3: {
                    this.toke.getToken();
                    if (onSecondArg) {
                        max = numString != null ? Integer.parseInt(numString.toString()) : Integer.MAX_VALUE;
                    } else {
                        min = max = Integer.parseInt(numString.toString());
                    }
                    return new Range(min, max);
                }
            }
            throw new AutomatonException(this.toke.getToken() + " is not valid in an iteration specifier.");
        }
        throw new AutomatonException("unexpected error.");
    }

    NfaSubModel reiterate(NfaSubModel base, NfaBuilder delegate, Range count) {
        NfaSubModel duplSubModel;
        int i;
        if (count.once()) {
            return base;
        }
        NfaSubModel returnSubModel = new NfaSubModel(delegate);
        FiniteAutomaton.Node lastNode = returnSubModel.getStart();
        for (i = 0; i < count.getMin(); ++i) {
            duplSubModel = base.duplicate();
            returnSubModel.addEpsilonTransition(lastNode, duplSubModel.getStart());
            lastNode = duplSubModel.getEnd();
        }
        if (count.getMax() != Integer.MAX_VALUE) {
            for (i = count.getMin(); i < count.getMax(); ++i) {
                returnSubModel.addLambdaTransition(lastNode, returnSubModel.getEnd());
                duplSubModel = base.duplicate();
                returnSubModel.addEpsilonTransition(lastNode, duplSubModel.getStart());
                lastNode = duplSubModel.getEnd();
            }
        } else {
            NfaSubModel duplSubModel2 = base.duplicate();
            returnSubModel.addEpsilonTransition(lastNode, duplSubModel2.getStart());
            returnSubModel.addEpsilonTransition(duplSubModel2.getEnd(), lastNode);
        }
        returnSubModel.addEpsilonTransition(lastNode, returnSubModel.getEnd());
        return returnSubModel;
    }

    private static class Range {
        private int min = 1;
        private int max = 1;

        private int getMin() {
            return this.min;
        }

        private int getMax() {
            return this.max;
        }

        private void setMin(int min) {
            this.min = min;
        }

        private void setMax(int max) {
            this.max = max;
        }

        private Range(int min, int max) {
            this.min = min;
            this.max = max;
        }

        private boolean once() {
            return this.min == 1 && this.max == 1;
        }
    }

    private static class Tokenizer {
        private String packedTxt;
        private int ptr = 0;
        static final int EOL = -1;
        static final int SYMBOL_TOKEN = 0;
        static final int NUMERIC = 1;
        static final int LEFT_BRACE = 2;
        static final int RIGHT_BRACE = 3;
        static final int COMMA = 4;
        static final int LEFT_BRACKET = 5;
        static final int RIGHT_BRACKET = 6;
        static final int PLUS = 7;
        static final int ASTERISK = 8;
        static final int VERT_BAR = 9;
        static final int UNKNOWN = 999;

        private Tokenizer(String target) {
            this.packedTxt = this.pack(target);
        }

        private char getToken() throws IndexOutOfBoundsException {
            if (this.hasNext()) {
                return this.packedTxt.charAt(this.ptr++);
            }
            throw new IndexOutOfBoundsException("text length: " + this.packedTxt.length() + " index: " + this.ptr);
        }

        private char peekToken() throws IndexOutOfBoundsException {
            if (this.hasNext()) {
                return this.packedTxt.charAt(this.ptr);
            }
            throw new IndexOutOfBoundsException("text length: " + this.packedTxt.length() + " index: " + this.ptr);
        }

        private int nextTokenType() {
            if (!this.hasNext()) {
                return -1;
            }
            char nextCh = this.packedTxt.charAt(this.ptr);
            if (Character.isLetter(nextCh)) {
                return 0;
            }
            if (Character.isDigit(nextCh)) {
                return 1;
            }
            if (nextCh == '{') {
                return 2;
            }
            if (nextCh == '}') {
                return 3;
            }
            if (nextCh == ',') {
                return 4;
            }
            if (nextCh == '(') {
                return 5;
            }
            if (nextCh == ')') {
                return 6;
            }
            if (nextCh == '+') {
                return 7;
            }
            if (nextCh == '*') {
                return 8;
            }
            if (nextCh == '|') {
                return 9;
            }
            return 999;
        }

        private boolean hasNext() {
            return this.ptr < this.packedTxt.length();
        }

        private String pack(String source) {
            StringBuffer packedString = new StringBuffer();
            for (int i = 0; i < source.length(); ++i) {
                char currCh = source.charAt(i);
                if (Character.isWhitespace(currCh)) continue;
                packedString.append(currCh);
            }
            return packedString.toString();
        }
    }
}

