/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings.discrete;

import cytoscape.visual.mappings.MappingUtil;
import cytoscape.visual.parsers.ValueParser;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TreeMap;

public class DiscreteMappingReader {
    private String controllingAttribute;
    private TreeMap map = new TreeMap();

    public DiscreteMappingReader(Properties props, String baseKey, ValueParser parser) {
        this.readProperties(props, baseKey, parser);
    }

    public String getControllingAttributeName() {
        return this.controllingAttribute;
    }

    public TreeMap getMap() {
        return this.map;
    }

    private void readProperties(Properties props, String baseKey, ValueParser parser) {
        String contKey = baseKey + ".controller";
        this.controllingAttribute = props.getProperty(contKey);
        String contTypeKey = baseKey + ".controllerType";
        String attrTypeString = props.getProperty(contTypeKey);
        byte attrType = -1;
        if (attrTypeString != null) {
            attrType = new Byte(attrTypeString);
        }
        String mapKey = baseKey + ".map.";
        Enumeration<?> eProps = props.propertyNames();
        while (eProps.hasMoreElements()) {
            String key = (String)eProps.nextElement();
            if (!key.startsWith(mapKey)) continue;
            String value = props.getProperty(key);
            Object domainVal = MappingUtil.parseObjectType(key.substring(mapKey.length()), attrType);
            Object parsedVal = parser.parseStringValue(value);
            this.map.put(domainVal, parsedVal);
        }
    }
}

