/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.visual.DuplicateCalculatorNameException;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.calculators.CalculatorFactory;
import cytoscape.visual.calculators.EdgeArrowCalculator;
import cytoscape.visual.calculators.EdgeColorCalculator;
import cytoscape.visual.calculators.EdgeFontFaceCalculator;
import cytoscape.visual.calculators.EdgeFontSizeCalculator;
import cytoscape.visual.calculators.EdgeLabelCalculator;
import cytoscape.visual.calculators.EdgeLineTypeCalculator;
import cytoscape.visual.calculators.EdgeToolTipCalculator;
import cytoscape.visual.calculators.NodeColorCalculator;
import cytoscape.visual.calculators.NodeFontFaceCalculator;
import cytoscape.visual.calculators.NodeFontSizeCalculator;
import cytoscape.visual.calculators.NodeLabelCalculator;
import cytoscape.visual.calculators.NodeLabelColorCalculator;
import cytoscape.visual.calculators.NodeLineTypeCalculator;
import cytoscape.visual.calculators.NodeShapeCalculator;
import cytoscape.visual.calculators.NodeSizeCalculator;
import cytoscape.visual.calculators.NodeToolTipCalculator;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.mappings.PassThroughMapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalculatorCatalog {
    Map<Byte, Map<String, Calculator>> calculators;
    Map<Byte, List> listeners;
    Map visualStyles;
    Map mappers;
    protected transient ChangeEvent changeEvent;

    public CalculatorCatalog() {
        this.clear();
    }

    public CalculatorCatalog(Properties props) {
        this.clear();
    }

    public void clear() {
        this.calculators = new HashMap<Byte, Map<String, Calculator>>();
        this.listeners = new HashMap<Byte, List>();
        this.visualStyles = new HashMap();
        this.mappers = new HashMap();
    }

    protected List getListenerList(byte type) throws IllegalArgumentException {
        Byte b = new Byte(type);
        ArrayList l = this.listeners.get(b);
        if (l == null) {
            l = new ArrayList();
            this.listeners.put(b, l);
        }
        return l;
    }

    public void addChangeListener(ChangeListener l, byte type) throws IllegalArgumentException {
        List theListeners = this.getListenerList(type);
        theListeners.add(l);
    }

    protected void fireStateChanged(byte type) throws IllegalArgumentException {
        List notifyEvents = this.getListenerList(type);
        for (int i = notifyEvents.size() - 1; i >= 0; --i) {
            ChangeListener listener = (ChangeListener)notifyEvents.get(i);
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            listener.stateChanged(this.changeEvent);
        }
    }

    public byte getType(Calculator c) throws IllegalArgumentException {
        return c.getType();
    }

    protected Map<String, Calculator> getCalculatorMap(byte type) {
        Byte b = new Byte(type);
        Map<String, Calculator> m = this.calculators.get(b);
        if (m == null) {
            m = new HashMap<String, Calculator>();
            this.calculators.put(b, m);
        }
        return m;
    }

    public void addCalculator(Calculator dupe) throws DuplicateCalculatorNameException, IllegalArgumentException {
        byte calcType = dupe.getType();
        Map<String, Calculator> theMap = this.getCalculatorMap(calcType);
        this.addCalculator(dupe, theMap);
        this.fireStateChanged(calcType);
    }

    public String checkCalculatorName(String calcName, byte calcType) {
        Map<String, Calculator> theMap = this.getCalculatorMap(calcType);
        return this.checkName(calcName, theMap);
    }

    public void renameCalculator(Calculator c, String name) throws DuplicateCalculatorNameException, IllegalArgumentException {
        byte calcType = c.getType();
        Map<String, Calculator> theMap = this.getCalculatorMap(calcType);
        String newName = this.checkName(name, theMap);
        if (!newName.equals(name)) {
            throw new DuplicateCalculatorNameException(newName);
        }
        theMap.remove(((Object)c).toString());
        c.setName(name);
        theMap.put(name, c);
        this.fireStateChanged(calcType);
    }

    public void removeCalculator(Calculator c) throws IllegalArgumentException {
        byte calcType = c.getType();
        Map<String, Calculator> theMap = this.getCalculatorMap(calcType);
        theMap.remove(((Object)c).toString());
        this.fireStateChanged(calcType);
    }

    public Set getMappingNames() {
        return this.mappers.keySet();
    }

    public void addMapping(String name, Class m) throws DuplicateCalculatorNameException, IllegalArgumentException {
        if (!ObjectMapping.class.isAssignableFrom(m)) {
            throw new IllegalArgumentException("Class " + m.getName() + " is not an ObjectMapper!");
        }
        if (this.mappers.keySet().contains(name)) {
            throw new DuplicateCalculatorNameException("Duplicate mapper name " + name);
        }
        this.mappers.put(name, m);
    }

    public Class removeMapping(String name) {
        return (Class)this.mappers.remove(name);
    }

    public Class getMapping(String name) {
        return (Class)this.mappers.get(name);
    }

    public String checkMappingName(String name) {
        String newName = name;
        int nameApp = 2;
        while (this.mappers.keySet().contains(newName)) {
            newName = name + nameApp;
            ++nameApp;
        }
        return newName;
    }

    public Set getVisualStyleNames() {
        return this.visualStyles.keySet();
    }

    public Collection getVisualStyles() {
        return this.visualStyles.values();
    }

    public void addVisualStyle(VisualStyle vs) {
        if (vs == null) {
            return;
        }
        String name = vs.toString();
        if (this.visualStyles.keySet().contains(name)) {
            String s = "Duplicate visual style name " + name;
            throw new DuplicateCalculatorNameException(s);
        }
        this.visualStyles.put(name, vs);
        this.addNodeAppearanceCalculator(vs.getNodeAppearanceCalculator());
        this.addEdgeAppearanceCalculator(vs.getEdgeAppearanceCalculator());
    }

    public VisualStyle removeVisualStyle(String name) {
        return (VisualStyle)this.visualStyles.remove(name);
    }

    public VisualStyle getVisualStyle(String name) {
        if (name != null && name.equals("default") && !this.visualStyles.containsKey(name)) {
            this.createDefaultVisualStyle();
        }
        return (VisualStyle)this.visualStyles.get(name);
    }

    public String checkVisualStyleName(String name) {
        return this.checkName(name, this.visualStyles);
    }

    private void addNodeAppearanceCalculator(NodeAppearanceCalculator c) {
        for (Calculator cc : c.getCalculators()) {
            Byte b = new Byte(cc.getType());
            Map<String, Calculator> m = this.calculators.get(b);
            if (m.values().contains(cc)) continue;
            m.put(((Object)cc).toString(), cc);
        }
    }

    private void addEdgeAppearanceCalculator(EdgeAppearanceCalculator c) {
        for (Calculator cc : c.getCalculators()) {
            Byte b = new Byte(cc.getType());
            Map<String, Calculator> m = this.calculators.get(b);
            if (m.values().contains(cc)) continue;
            m.put(((Object)cc).toString(), cc);
        }
    }

    protected void addCalculator(Calculator c, Map m) throws DuplicateCalculatorNameException {
        if (c == null) {
            return;
        }
        String name = ((Object)c).toString();
        if (m.keySet().contains(name)) {
            String s = "Duplicate calculator name " + name;
            throw new DuplicateCalculatorNameException(s);
        }
        m.put(name, c);
    }

    protected String checkName(String name, Map m) {
        if (name == null) {
            return null;
        }
        String newName = name;
        int nameApp = 2;
        while (m.keySet().contains(newName)) {
            newName = name + nameApp;
            ++nameApp;
        }
        return newName;
    }

    public Collection<Calculator> getCalculators() {
        ArrayList<Calculator> l = new ArrayList<Calculator>();
        for (Byte b : this.calculators.keySet()) {
            for (String s : this.calculators.get(b).keySet()) {
                l.add(this.calculators.get(b).get(s));
            }
        }
        return l;
    }

    public Collection<Calculator> getCalculators(byte b) {
        Map<String, Calculator> m = this.getCalculatorMap(b);
        return m.values();
    }

    public Calculator getCalculator(byte b, String name) {
        Map<String, Calculator> m = this.getCalculatorMap(b);
        return m.get(name);
    }

    public String checkCalculatorName(byte b, String name) {
        return this.checkName(name, this.getCalculatorMap(b));
    }

    public Calculator removeCalculator(byte b, String name) {
        Map<String, Calculator> m = this.getCalculatorMap(b);
        return m.remove(name);
    }

    public Collection<Byte> getCalculatorTypes() {
        return this.calculators.keySet();
    }

    public void createDefaultVisualStyle() {
        VisualStyle defaultVS = new VisualStyle("default");
        String label = "label";
        Calculator nlc = this.getCalculator((byte)5, label);
        if (nlc == null) {
            PassThroughMapping m = new PassThroughMapping((Object)"", "ID");
            nlc = CalculatorFactory.newDefaultCalculator((byte)5, label, m);
        }
        defaultVS.getNodeAppearanceCalculator().setCalculator(nlc);
        this.addVisualStyle(defaultVS);
    }

    public Collection getNodeColorCalculators() {
        ArrayList<Calculator> a = new ArrayList<Calculator>();
        a.addAll(this.getCalculators((byte)0));
        a.addAll(this.getCalculators((byte)1));
        return a;
    }

    public void addNodeColorCalculator(NodeColorCalculator c) {
        this.addCalculator(c);
    }

    public NodeColorCalculator removeNodeColorCalculator(String name) {
        NodeColorCalculator c = (NodeColorCalculator)this.removeCalculator((byte)0, name);
        if (c == null) {
            c = (NodeColorCalculator)this.removeCalculator((byte)1, name);
        }
        return c;
    }

    public NodeColorCalculator getNodeColorCalculator(String name) {
        NodeColorCalculator c = (NodeColorCalculator)this.getCalculator((byte)0, name);
        if (c == null) {
            c = (NodeColorCalculator)this.getCalculator((byte)1, name);
        }
        return c;
    }

    public String checkNodeColorCalculatorName(String name) {
        String s = this.checkCalculatorName((byte)0, name);
        if (s == null) {
            s = this.checkCalculatorName((byte)1, name);
        }
        return s;
    }

    public Collection getNodeLineTypeCalculators() {
        return this.getCalculators((byte)2);
    }

    public void addNodeLineTypeCalculator(NodeLineTypeCalculator c) {
        this.addCalculator(c);
    }

    public NodeLineTypeCalculator removeNodeLineTypeCalculator(String name) {
        return (NodeLineTypeCalculator)this.removeCalculator((byte)2, name);
    }

    public NodeLineTypeCalculator getNodeLineTypeCalculator(String name) {
        return (NodeLineTypeCalculator)this.getCalculator((byte)2, name);
    }

    public String checkNodeLineTypeCalculatorName(String name) {
        return this.checkCalculatorName((byte)2, name);
    }

    public Collection getNodeShapeCalculators() {
        return this.getCalculators((byte)3);
    }

    public void addNodeShapeCalculator(NodeShapeCalculator c) {
        this.addCalculator(c);
    }

    public NodeShapeCalculator removeNodeShapeCalculator(String name) {
        return (NodeShapeCalculator)this.removeCalculator((byte)3, name);
    }

    public NodeShapeCalculator getNodeShapeCalculator(String name) {
        return (NodeShapeCalculator)this.getCalculator((byte)3, name);
    }

    public String checkNodeShapeCalculatorName(String name) {
        return this.checkCalculatorName((byte)3, name);
    }

    public Collection getNodeSizeCalculators() {
        ArrayList<Calculator> a = new ArrayList<Calculator>();
        a.addAll(this.getCalculators((byte)4));
        a.addAll(this.getCalculators((byte)127));
        a.addAll(this.getCalculators((byte)126));
        return a;
    }

    public void addNodeSizeCalculator(NodeSizeCalculator c) {
        this.addCalculator(c);
    }

    public NodeSizeCalculator removeNodeSizeCalculator(String name) {
        NodeSizeCalculator c = (NodeSizeCalculator)this.removeCalculator((byte)4, name);
        if (c == null) {
            c = (NodeSizeCalculator)this.removeCalculator((byte)127, name);
        }
        if (c == null) {
            c = (NodeSizeCalculator)this.removeCalculator((byte)126, name);
        }
        return c;
    }

    public NodeSizeCalculator getNodeSizeCalculator(String name) {
        NodeSizeCalculator c = (NodeSizeCalculator)this.getCalculator((byte)4, name);
        if (c == null) {
            c = (NodeSizeCalculator)this.getCalculator((byte)127, name);
        }
        if (c == null) {
            c = (NodeSizeCalculator)this.getCalculator((byte)126, name);
        }
        return c;
    }

    public String checkNodeSizeCalculatorName(String name) {
        String s = this.checkCalculatorName((byte)4, name);
        if (s == null) {
            s = this.checkCalculatorName((byte)127, name);
        }
        if (s == null) {
            s = this.checkCalculatorName((byte)126, name);
        }
        return s;
    }

    public Collection getNodeLabelCalculators() {
        return this.getCalculators((byte)5);
    }

    public void addNodeLabelCalculator(NodeLabelCalculator c) {
        this.addCalculator(c);
    }

    public NodeLabelCalculator removeNodeLabelCalculator(String name) {
        return (NodeLabelCalculator)this.removeCalculator((byte)5, name);
    }

    public NodeLabelCalculator getNodeLabelCalculator(String name) {
        return (NodeLabelCalculator)this.getCalculator((byte)5, name);
    }

    public String checkNodeLabelCalculatorName(String name) {
        return this.checkCalculatorName((byte)5, name);
    }

    public Collection getNodeLabelColorCalculators() {
        return this.getCalculators((byte)7);
    }

    public void addNodeLabelColorCalculator(NodeLabelColorCalculator c) {
        this.addCalculator(c);
    }

    public NodeLabelColorCalculator removeNodeLabelColorCalculator(String name) {
        return (NodeLabelColorCalculator)this.removeCalculator((byte)7, name);
    }

    public NodeLabelColorCalculator getNodeLabelColorCalculator(String name) {
        return (NodeLabelColorCalculator)this.getCalculator((byte)7, name);
    }

    public String checkNodeLabelColorCalculatorName(String name) {
        return this.checkCalculatorName((byte)7, name);
    }

    public Collection getNodeToolTipCalculators() {
        return this.getCalculators((byte)14);
    }

    public void addNodeToolTipCalculator(NodeToolTipCalculator c) {
        this.addCalculator(c);
    }

    public NodeToolTipCalculator removeNodeToolTipCalculator(String name) {
        return (NodeToolTipCalculator)this.removeCalculator((byte)14, name);
    }

    public NodeToolTipCalculator getNodeToolTipCalculator(String name) {
        return (NodeToolTipCalculator)this.getCalculator((byte)14, name);
    }

    public String checkNodeToolTipCalculatorName(String name) {
        return this.checkCalculatorName((byte)14, name);
    }

    public Collection getNodeFontFaceCalculators() {
        return this.getCalculators((byte)122);
    }

    public void addNodeFontFaceCalculator(NodeFontFaceCalculator c) {
        this.addCalculator(c);
    }

    public NodeFontFaceCalculator removeNodeFontFaceCalculator(String name) {
        return (NodeFontFaceCalculator)this.removeCalculator((byte)122, name);
    }

    public NodeFontFaceCalculator getNodeFontFaceCalculator(String name) {
        return (NodeFontFaceCalculator)this.getCalculator((byte)122, name);
    }

    public String checkNodeFontFaceCalculatorName(String name) {
        return this.checkCalculatorName((byte)122, name);
    }

    public Collection getNodeFontSizeCalculators() {
        return this.getCalculators((byte)123);
    }

    public void addNodeFontSizeCalculator(NodeFontSizeCalculator c) {
        this.addCalculator(c);
    }

    public NodeFontSizeCalculator removeNodeFontSizeCalculator(String name) {
        return (NodeFontSizeCalculator)this.removeCalculator((byte)123, name);
    }

    public NodeFontSizeCalculator getNodeFontSizeCalculator(String name) {
        return (NodeFontSizeCalculator)this.getCalculator((byte)123, name);
    }

    public String checkNodeFontSizeCalculatorName(String name) {
        return this.checkCalculatorName((byte)123, name);
    }

    public Collection getEdgeColorCalculators() {
        return this.getCalculators((byte)8);
    }

    public void addEdgeColorCalculator(EdgeColorCalculator c) {
        this.addCalculator(c);
    }

    public EdgeColorCalculator removeEdgeColorCalculator(String name) {
        return (EdgeColorCalculator)this.removeCalculator((byte)8, name);
    }

    public EdgeColorCalculator getEdgeColorCalculator(String name) {
        return (EdgeColorCalculator)this.getCalculator((byte)8, name);
    }

    public String checkEdgeColorCalculatorName(String name) {
        return this.checkCalculatorName((byte)8, name);
    }

    public Collection getEdgeLineTypeCalculators() {
        return this.getCalculators((byte)9);
    }

    public void addEdgeLineTypeCalculator(EdgeLineTypeCalculator c) {
        this.addCalculator(c);
    }

    public EdgeLineTypeCalculator removeEdgeLineTypeCalculator(String name) {
        return (EdgeLineTypeCalculator)this.removeCalculator((byte)9, name);
    }

    public EdgeLineTypeCalculator getEdgeLineTypeCalculator(String name) {
        return (EdgeLineTypeCalculator)this.getCalculator((byte)9, name);
    }

    public String checkEdgeLineTypeCalculatorName(String name) {
        return this.checkCalculatorName((byte)9, name);
    }

    public Collection getEdgeArrowCalculators() {
        ArrayList<Calculator> a = new ArrayList<Calculator>();
        a.addAll(this.getCalculators((byte)10));
        a.addAll(this.getCalculators((byte)11));
        return a;
    }

    public void addEdgeArrowCalculator(EdgeArrowCalculator c) {
        this.addCalculator(c);
    }

    public EdgeArrowCalculator removeEdgeArrowCalculator(String name) {
        EdgeArrowCalculator c = (EdgeArrowCalculator)this.removeCalculator((byte)10, name);
        if (c == null) {
            c = (EdgeArrowCalculator)this.removeCalculator((byte)11, name);
        }
        return c;
    }

    public EdgeArrowCalculator getEdgeArrowCalculator(String name) {
        EdgeArrowCalculator c = (EdgeArrowCalculator)this.getCalculator((byte)10, name);
        if (c == null) {
            c = (EdgeArrowCalculator)this.getCalculator((byte)11, name);
        }
        return c;
    }

    public String checkEdgeArrowCalculatorName(String name) {
        String s = this.checkCalculatorName((byte)10, name);
        if (s == null) {
            s = this.checkCalculatorName((byte)11, name);
        }
        return s;
    }

    public Collection getEdgeLabelCalculators() {
        return this.getCalculators((byte)12);
    }

    public void addEdgeLabelCalculator(EdgeLabelCalculator c) {
        this.addCalculator(c);
    }

    public EdgeLabelCalculator removeEdgeLabelCalculator(String name) {
        return (EdgeLabelCalculator)this.removeCalculator((byte)12, name);
    }

    public EdgeLabelCalculator getEdgeLabelCalculator(String name) {
        return (EdgeLabelCalculator)this.getCalculator((byte)12, name);
    }

    public String checkEdgeLabelCalculatorName(String name) {
        return this.checkCalculatorName((byte)12, name);
    }

    public Collection getEdgeToolTipCalculators() {
        return this.getCalculators((byte)15);
    }

    public void addEdgeToolTipCalculator(EdgeToolTipCalculator c) {
        this.addCalculator(c);
    }

    public EdgeToolTipCalculator removeEdgeToolTipCalculator(String name) {
        return (EdgeToolTipCalculator)this.removeCalculator((byte)15, name);
    }

    public EdgeToolTipCalculator getEdgeToolTipCalculator(String name) {
        return (EdgeToolTipCalculator)this.getCalculator((byte)15, name);
    }

    public String checkEdgeToolTipCalculatorName(String name) {
        return this.checkCalculatorName((byte)15, name);
    }

    public Collection getEdgeFontFaceCalculators() {
        return this.getCalculators((byte)124);
    }

    public void addEdgeFontFaceCalculator(EdgeFontFaceCalculator c) {
        this.addCalculator(c);
    }

    public EdgeFontFaceCalculator removeEdgeFontFaceCalculator(String name) {
        return (EdgeFontFaceCalculator)this.removeCalculator((byte)124, name);
    }

    public EdgeFontFaceCalculator getEdgeFontFaceCalculator(String name) {
        return (EdgeFontFaceCalculator)this.getCalculator((byte)124, name);
    }

    public String checkEdgeFontFaceCalculatorName(String name) {
        return this.checkCalculatorName((byte)124, name);
    }

    public Collection getEdgeFontSizeCalculators() {
        return this.getCalculators((byte)125);
    }

    public void addEdgeFontSizeCalculator(EdgeFontSizeCalculator c) {
        this.addCalculator(c);
    }

    public EdgeFontSizeCalculator removeEdgeFontSizeCalculator(String name) {
        return (EdgeFontSizeCalculator)this.removeCalculator((byte)125, name);
    }

    public EdgeFontSizeCalculator getEdgeFontSizeCalculator(String name) {
        return (EdgeFontSizeCalculator)this.getCalculator((byte)125, name);
    }

    public String checkEdgeFontSizeCalculatorName(String name) {
        return this.checkCalculatorName((byte)125, name);
    }
}

