/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.view;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.SelectEvent;
import cytoscape.data.SelectEventListener;
import cytoscape.util.swing.AbstractTreeTableModel;
import cytoscape.util.swing.JTreeTable;
import cytoscape.util.swing.TreeTableModel;
import cytoscape.view.CytoscapeDesktop;
import cytoscape.view.PopupActionListener;
import cytoscape.view.cytopanels.BiModalJSplitPane;
import cytoscape.view.cytopanels.CytoPanelImp;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class NetworkPanel
extends JPanel
implements PropertyChangeListener,
TreeSelectionListener,
SelectEventListener {
    protected SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this);
    private final JTreeTable treeTable;
    private final NetworkTreeNode root;
    private JPanel navigatorPanel;
    private JPopupMenu popup;
    private PopupActionListener popupActionListener;
    private JMenuItem createViewItem;
    private JMenuItem destroyViewItem;
    private JMenuItem destroyNetworkItem;
    private JMenuItem editNetworkTitle;
    private JSplitPane split;
    private BiModalJSplitPane split_top;
    private final NetworkTreeTableModel treeTableModel;
    private final CytoscapeDesktop cytoscapeDesktop;

    public NetworkPanel(CytoscapeDesktop desktop) {
        this.cytoscapeDesktop = desktop;
        this.root = new NetworkTreeNode("Network Root", "root");
        this.treeTableModel = new NetworkTreeTableModel(this.root);
        this.treeTable = new JTreeTable(this.treeTableModel);
        this.initialize();
        for (KeyStroke listener : this.treeTable.getRegisteredKeyStrokes()) {
            if (!listener.toString().equals("ctrl pressed A")) continue;
            InputMap map = this.treeTable.getInputMap();
            map.remove(listener);
            this.treeTable.setInputMap(0, map);
            this.treeTable.setInputMap(1, map);
        }
    }

    protected void initialize() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(180, 700));
        this.treeTable.getTree().addTreeSelectionListener(this);
        this.treeTable.getTree().setRootVisible(false);
        ToolTipManager.sharedInstance().registerComponent(this.treeTable);
        this.treeTable.getTree().setCellRenderer(new TreeCellRenderer());
        this.treeTable.getColumn("Network").setPreferredWidth(100);
        this.treeTable.getColumn("Nodes").setPreferredWidth(45);
        this.treeTable.getColumn("Edges").setPreferredWidth(45);
        this.navigatorPanel = new JPanel();
        this.navigatorPanel.setMinimumSize(new Dimension(180, 180));
        this.navigatorPanel.setMaximumSize(new Dimension(180, 180));
        this.navigatorPanel.setPreferredSize(new Dimension(180, 180));
        CytoPanelImp manualLayoutPanel = (CytoPanelImp)this.cytoscapeDesktop.getCytoPanel(6);
        manualLayoutPanel.setMinimumSize(new Dimension(180, 185));
        manualLayoutPanel.setMaximumSize(new Dimension(180, 185));
        manualLayoutPanel.setPreferredSize(new Dimension(180, 185));
        JScrollPane scroll = new JScrollPane(this.treeTable);
        this.split_top = new BiModalJSplitPane(this.cytoscapeDesktop, 0, 2, scroll, manualLayoutPanel);
        this.split_top.setResizeWeight(1.0);
        manualLayoutPanel.setCytoPanelContainer(this.split_top);
        this.split = new JSplitPane(0, this.split_top, this.navigatorPanel);
        this.split.setResizeWeight(1.0);
        this.add(this.split);
        this.treeTable.addMouseListener(new PopupListener());
        this.popup = new JPopupMenu();
        this.editNetworkTitle = new JMenuItem("Edit Network Title");
        this.createViewItem = new JMenuItem("Create View");
        this.destroyViewItem = new JMenuItem("Destroy View");
        this.destroyNetworkItem = new JMenuItem("Destroy Network");
        this.popupActionListener = new PopupActionListener();
        this.editNetworkTitle.addActionListener(this.popupActionListener);
        this.createViewItem.addActionListener(this.popupActionListener);
        this.destroyViewItem.addActionListener(this.popupActionListener);
        this.destroyNetworkItem.addActionListener(this.popupActionListener);
        this.popup.add(this.editNetworkTitle);
        this.popup.add(this.createViewItem);
        this.popup.add(this.destroyViewItem);
        this.popup.add(this.destroyNetworkItem);
    }

    public void setNavigator(Component comp) {
        this.split.setRightComponent(comp);
        this.split.validate();
    }

    public JTreeTable getTreeTable() {
        return this.treeTable;
    }

    public JPanel getNavigatorPanel() {
        return this.navigatorPanel;
    }

    public SwingPropertyChangeSupport getSwingPropertyChangeSupport() {
        return this.pcs;
    }

    public void removeNetwork(String network_id) {
        NetworkTreeNode node = this.getNetworkNode(network_id);
        Enumeration<TreeNode> children = node.children();
        Object var4_4 = null;
        ArrayList<TreeNode> removed_children = new ArrayList<TreeNode>();
        while (children.hasMoreElements()) {
            removed_children.add(children.nextElement());
        }
        for (NetworkTreeNode networkTreeNode : removed_children) {
            networkTreeNode.removeFromParent();
            this.root.add(networkTreeNode);
        }
        Cytoscape.getNetwork(network_id).removeSelectEventListener(this);
        node.removeFromParent();
        this.treeTable.getTree().updateUI();
        this.treeTable.doLayout();
    }

    public void updateTitle(CyNetwork network) {
        this.treeTableModel.setValueAt(network.getTitle(), this.treeTable.getTree().getSelectionPath().getLastPathComponent(), 0);
        this.treeTable.getTree().updateUI();
        this.treeTable.doLayout();
        Cytoscape.getDesktop().getNetworkViewManager().updateNetworkTitle(network);
    }

    public void onSelectEvent(SelectEvent event) {
        this.treeTable.getTree().updateUI();
    }

    public void addNetwork(String network_id, String parent_id) {
        if (this.getNetworkNode(network_id) == null) {
            NetworkTreeNode dmtn = new NetworkTreeNode(Cytoscape.getNetwork(network_id).getTitle(), network_id);
            Cytoscape.getNetwork(network_id).addSelectEventListener(this);
            if (parent_id != null) {
                NetworkTreeNode parent = this.getNetworkNode(parent_id);
                parent.add(dmtn);
            } else {
                this.root.add(dmtn);
            }
            this.treeTable.getTree().collapsePath(new TreePath(new TreeNode[]{this.root}));
            this.treeTable.getTree().updateUI();
            TreePath path = new TreePath(dmtn.getPath());
            this.treeTable.getTree().expandPath(path);
            this.treeTable.getTree().scrollPathToVisible(path);
            this.treeTable.doLayout();
            this.focusNetworkNode(network_id);
        }
    }

    public void focusNetworkNode(String network_id) {
        NetworkTreeNode node = this.getNetworkNode(network_id);
        if (node != null) {
            this.treeTable.getTree().getSelectionModel().setSelectionPath(new TreePath(node.getPath()));
            this.treeTable.getTree().scrollPathToVisible(new TreePath(node.getPath()));
        }
    }

    public NetworkTreeNode getNetworkNode(String network_id) {
        Enumeration<TreeNode> tree_node_enum = this.root.breadthFirstEnumeration();
        while (tree_node_enum.hasMoreElements()) {
            NetworkTreeNode node = (NetworkTreeNode)tree_node_enum.nextElement();
            if (node.getNetworkID() != network_id) continue;
            return node;
        }
        return null;
    }

    public void fireFocus(String network_id) {
        this.pcs.firePropertyChange(new PropertyChangeEvent(this, "NETWORK_VIEW_FOCUS", null, network_id));
    }

    public void valueChanged(TreeSelectionEvent e) {
        NetworkTreeNode node = (NetworkTreeNode)this.treeTable.getTree().getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (node.getUserObject() == null) {
            return;
        }
        this.fireFocus(node.getNetworkID());
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == Cytoscape.NETWORK_CREATED) {
            this.addNetwork((String)e.getNewValue(), (String)e.getOldValue());
        } else if (e.getPropertyName() == Cytoscape.NETWORK_DESTROYED) {
            this.removeNetwork((String)e.getNewValue());
        } else if (e.getPropertyName() == "NETWORK_VIEW_FOCUSED") {
            this.focusNetworkNode((String)e.getNewValue());
        }
    }

    protected class PopupListener
    extends MouseAdapter {
        protected PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            JTree tree;
            TreePath treePath;
            String networkID;
            CyNetwork cyNetwork;
            int row;
            if (e.isPopupTrigger() && (row = NetworkPanel.this.treeTable.rowAtPoint(e.getPoint())) != -1 && (cyNetwork = Cytoscape.getNetwork(networkID = ((NetworkTreeNode)(treePath = (tree = NetworkPanel.this.treeTable.getTree()).getPathForRow(row)).getLastPathComponent()).getNetworkID())) != null) {
                if (Cytoscape.viewExists(networkID)) {
                    NetworkPanel.this.createViewItem.setEnabled(false);
                    NetworkPanel.this.destroyViewItem.setEnabled(true);
                } else {
                    NetworkPanel.this.createViewItem.setEnabled(true);
                    NetworkPanel.this.destroyViewItem.setEnabled(false);
                }
                NetworkPanel.this.popupActionListener.setActiveNetwork(cyNetwork);
                NetworkPanel.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class TreeCellRenderer
    extends DefaultTreeCellRenderer {
        private TreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (this.hasView(value)) {
                this.setBackgroundNonSelectionColor(Color.green.brighter());
                this.setBackgroundSelectionColor(Color.green.darker());
            } else {
                this.setBackgroundNonSelectionColor(Color.red.brighter());
                this.setBackgroundSelectionColor(Color.red.darker());
            }
            return this;
        }

        private boolean hasView(Object value) {
            NetworkTreeNode node = (NetworkTreeNode)value;
            this.setToolTipText(Cytoscape.getNetwork(node.getNetworkID()).getTitle());
            return Cytoscape.viewExists(node.getNetworkID());
        }
    }

    public class NetworkTreeNode
    extends DefaultMutableTreeNode {
        protected String network_uid;

        public NetworkTreeNode(Object userobj, String id) {
            super(userobj.toString());
            this.network_uid = id;
        }

        protected void setNetworkID(String id) {
            this.network_uid = id;
        }

        protected String getNetworkID() {
            return this.network_uid;
        }
    }

    class NetworkTreeTableModel
    extends AbstractTreeTableModel {
        String[] columns;
        Class[] columns_class;

        public NetworkTreeTableModel(Object root) {
            super(root);
            this.columns = new String[]{"Network", "Nodes", "Edges"};
            this.columns_class = new Class[]{TreeTableModel.class, String.class, String.class};
        }

        public Object getChild(Object parent, int index) {
            Enumeration<TreeNode> tree_node_enum = ((DefaultMutableTreeNode)this.getRoot()).breadthFirstEnumeration();
            while (tree_node_enum.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree_node_enum.nextElement();
                if (node != parent) continue;
                return node.getChildAt(index);
            }
            return null;
        }

        public int getChildCount(Object parent) {
            Enumeration<TreeNode> tree_node_enum = ((DefaultMutableTreeNode)this.getRoot()).breadthFirstEnumeration();
            while (tree_node_enum.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree_node_enum.nextElement();
                if (node != parent) continue;
                return node.getChildCount();
            }
            return 0;
        }

        public int getColumnCount() {
            return this.columns.length;
        }

        public String getColumnName(int column) {
            return this.columns[column];
        }

        public Class getColumnClass(int column) {
            return this.columns_class[column];
        }

        public Object getValueAt(Object node, int column) {
            if (column == 0) {
                return ((DefaultMutableTreeNode)node).getUserObject();
            }
            if (column == 1) {
                CyNetwork cyNetwork = Cytoscape.getNetwork(((NetworkTreeNode)node).getNetworkID());
                return "" + cyNetwork.getNodeCount() + "(" + cyNetwork.getSelectedNodes().size() + ")";
            }
            if (column == 2) {
                CyNetwork cyNetwork = Cytoscape.getNetwork(((NetworkTreeNode)node).getNetworkID());
                return "" + cyNetwork.getEdgeCount() + "(" + cyNetwork.getSelectedEdges().size() + ")";
            }
            return "";
        }

        public void setValueAt(Object aValue, Object node, int column) {
            if (column == 0) {
                ((DefaultMutableTreeNode)node).setUserObject(aValue);
            } else {
                JOptionPane.showMessageDialog(Cytoscape.getDesktop(), "Error: assigning value at in NetworkPanel");
            }
        }
    }
}

