/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.plugin;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CytoscapePlugin
implements PropertyChangeListener {
    private HashMap<String, List<File>> pluginFileListMap;

    public CytoscapePlugin() {
        Cytoscape.getPropertyChangeSupport().addPropertyChangeListener("SAVE_PLUGIN_STATE", this);
        Cytoscape.getPropertyChangeSupport().addPropertyChangeListener("RESTORE_PLUGIN_STATE", this);
    }

    public boolean isScriptable() {
        return false;
    }

    public String getScriptName() {
        return "default";
    }

    public CyNetwork interpretScript(String[] args, CyNetwork network) {
        return null;
    }

    public void activate() {
    }

    public void deactivate() {
    }

    public String describe() {
        return new String("No description.");
    }

    public static boolean loadPlugin(Class pluginClass) {
        System.out.println("Loading: " + pluginClass);
        if (pluginClass == null) {
            return false;
        }
        Object object = null;
        try {
            object = pluginClass.newInstance();
        }
        catch (InstantiationException e) {
            System.out.println("InstantiationException");
            System.out.println(e);
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            System.out.println("IllegalAccessException");
            System.out.println(e);
            e.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("Unchecked '" + e.getClass().getName() + "'exception while attempting to load plugin.");
            System.err.println("This may happen when loading a plugin written for a different version of Cytoscape than this one, or if the plugin is dependent on another plugin that isn't available. Consult the documentation for the plugin or contact the plugin author for more information.");
            System.err.println(e);
            e.printStackTrace();
        }
        if (object == null) {
            System.out.println("Instantiation seems to have failed");
        }
        System.out.println("Successfully loaded: " + pluginClass);
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String pluginName = this.getClass().getName();
        int index = pluginName.lastIndexOf(".");
        pluginName = pluginName.substring(index + 1);
        if (e.getPropertyName().equalsIgnoreCase("SAVE_PLUGIN_STATE")) {
            this.pluginFileListMap = (HashMap)e.getOldValue();
            ArrayList<File> newfiles = new ArrayList<File>();
            this.saveSessionStateFiles(newfiles);
            if (newfiles.size() > 0) {
                this.pluginFileListMap.put(pluginName, newfiles);
            }
        } else if (e.getPropertyName().equalsIgnoreCase("RESTORE_PLUGIN_STATE")) {
            List<File> theFileList;
            this.pluginFileListMap = (HashMap)e.getOldValue();
            if (this.pluginFileListMap.containsKey(pluginName) && (theFileList = this.pluginFileListMap.get(pluginName)) != null && theFileList.size() > 0) {
                this.restoreSessionState(theFileList);
            }
        }
    }

    public void restoreSessionState(List<File> pStateFileList) {
    }

    public void saveSessionStateFiles(List<File> pFileList) {
    }
}

