/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.abi;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SymbolList;

public class ABITrace {
    private String sequence;
    private int[] A;
    private int[] G;
    private int[] C;
    private int[] T;
    private int[] Basecalls;
    private int TraceLength;
    private int SeqLength;
    private byte[] TraceData;
    private int maximum = 0;
    private int MacJunk = 0;
    private static int AbsIndexBase = 26;
    private int IndexBase;
    private int PLOC;
    private int ATraceStart;
    private int CTraceStart;
    private int GTraceStart;
    private int TTraceStart;
    private int DATA9;
    private int DATA10;
    private int DATA11;
    private int DATA12;
    private int PBAS2;
    private int FWO;

    public ABITrace(File ABIFile) throws IOException {
        int b;
        byte[] bytes = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileInputStream fis = new FileInputStream(ABIFile);
        BufferedInputStream bis = new BufferedInputStream(fis);
        while ((b = bis.read()) >= 0) {
            baos.write(b);
        }
        bis.close();
        fis.close();
        baos.close();
        bytes = baos.toByteArray();
        this.initData(bytes);
    }

    public ABITrace(URL ABIFile) throws IOException {
        int b;
        byte[] bytes = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream is = ABIFile.openStream();
        BufferedInputStream bis = new BufferedInputStream(is);
        while ((b = bis.read()) >= 0) {
            baos.write(b);
        }
        bis.close();
        is.close();
        baos.close();
        bytes = baos.toByteArray();
        this.initData(bytes);
    }

    public ABITrace(byte[] ABIFileData) {
        this.initData(ABIFileData);
    }

    public int getSequenceLength() {
        return this.SeqLength;
    }

    public int getTraceLength() {
        return this.TraceLength;
    }

    public int[] getBasecalls() {
        return this.Basecalls;
    }

    public SymbolList getSequence() throws BioError {
        try {
            return DNATools.createDNA(this.sequence);
        }
        catch (IllegalSymbolException ise) {
            throw new BioError(ise);
        }
    }

    public int[] getTrace(AtomicSymbol base) throws IllegalSymbolException {
        if (base == DNATools.a()) {
            return this.A;
        }
        if (base == DNATools.c()) {
            return this.C;
        }
        if (base == DNATools.g()) {
            return this.G;
        }
        if (base == DNATools.t()) {
            return this.T;
        }
        DNATools.getDNA().validate(base);
        throw new IllegalSymbolException("Don't know symbol: " + base);
    }

    public BufferedImage getImage(int imageHeight, int widthScale) {
        BufferedImage out = new BufferedImage(this.TraceLength * widthScale, imageHeight, 13);
        Graphics2D g = out.createGraphics();
        Color acolor = Color.green.darker();
        Color ccolor = Color.blue;
        Color gcolor = Color.black;
        Color tcolor = Color.red;
        Color ncolor = Color.pink;
        double scale = this.calculateScale(imageHeight);
        int[] bc = this.Basecalls;
        char[] seq = this.sequence.toCharArray();
        g.setBackground(Color.white);
        g.clearRect(0, 0, this.TraceLength * widthScale, imageHeight);
        int here = 0;
        int basenum = 0;
        block6: for (int q = 1; q <= 5; ++q) {
            for (int x = 0; x <= this.TraceLength - 2; ++x) {
                if (q == 1) {
                    g.setColor(acolor);
                    g.drawLine(2 * x, this.transmute(this.A[x], imageHeight, scale), 2 * (x + 1), this.transmute(this.A[x + 1], imageHeight, scale));
                }
                if (q == 2) {
                    g.setColor(ccolor);
                    g.drawLine(2 * x, this.transmute(this.C[x], imageHeight, scale), 2 * (x + 1), this.transmute(this.C[x + 1], imageHeight, scale));
                }
                if (q == 3) {
                    g.setColor(tcolor);
                    g.drawLine(2 * x, this.transmute(this.T[x], imageHeight, scale), 2 * (x + 1), this.transmute(this.T[x + 1], imageHeight, scale));
                }
                if (q == 4) {
                    g.setColor(gcolor);
                    g.drawLine(2 * x, this.transmute(this.G[x], imageHeight, scale), 2 * (x + 1), this.transmute(this.G[x + 1], imageHeight, scale));
                }
                if (q != 5) continue;
                if (here > bc.length - 1 || basenum > seq.length - 1) continue block6;
                if (bc[here] != x) continue;
                g.drawLine(2 * x, this.transmute(-2, imageHeight, 1.0), 2 * x, this.transmute(-7, imageHeight, 1.0));
                if ((basenum + 1) % 10 == 0) {
                    g.drawLine(2 * x, this.transmute(-20, imageHeight, 1.0), 2 * x, this.transmute(-25, imageHeight, 1.0));
                    g.drawString(Integer.toString(basenum + 1), 2 * x - 3, this.transmute(-36, imageHeight, 1.0));
                }
                switch (seq[basenum]) {
                    case 'A': 
                    case 'a': {
                        g.setColor(acolor);
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        g.setColor(ccolor);
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        g.setColor(gcolor);
                        break;
                    }
                    case 'T': 
                    case 't': {
                        g.setColor(tcolor);
                        break;
                    }
                    default: {
                        g.setColor(ncolor);
                    }
                }
                g.drawChars(seq, basenum, 1, 2 * x - 3, this.transmute(-18, imageHeight, 1.0));
                g.setColor(Color.black);
                ++here;
                ++basenum;
            }
        }
        return out;
    }

    private void initData(byte[] fileData) {
        this.TraceData = fileData;
        if (!this.isABI()) {
            throw new IllegalArgumentException("Not a valid ABI file.");
        }
        this.setIndex();
        this.setBasecalls();
        this.setSeq();
        this.setTraces();
    }

    private void getSubArray(byte[] b, int traceDataOffset) {
        for (int x = 0; x <= b.length - 1; ++x) {
            b[x] = this.TraceData[traceDataOffset + x];
        }
    }

    private void setTraces() {
        int i;
        int[] pointers = new int[4];
        int[] datas = new int[4];
        char[] order = new char[4];
        datas[0] = this.DATA9;
        datas[1] = this.DATA10;
        datas[2] = this.DATA11;
        datas[3] = this.DATA12;
        for (i = 0; i <= 3; ++i) {
            order[i] = (char)this.TraceData[this.FWO + i];
        }
        block9: for (i = 0; i <= 3; ++i) {
            switch (order[i]) {
                case 'A': 
                case 'a': {
                    pointers[0] = datas[i];
                    continue block9;
                }
                case 'C': 
                case 'c': {
                    pointers[1] = datas[i];
                    continue block9;
                }
                case 'G': 
                case 'g': {
                    pointers[2] = datas[i];
                    continue block9;
                }
                case 'T': 
                case 't': {
                    pointers[3] = datas[i];
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Trace contains illegal values.");
                }
            }
        }
        this.A = new int[this.TraceLength];
        this.C = new int[this.TraceLength];
        this.G = new int[this.TraceLength];
        this.T = new int[this.TraceLength];
        for (i = 0; i <= 3; ++i) {
            byte[] qq = new byte[this.TraceLength * 2];
            this.getSubArray(qq, pointers[i]);
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(qq));
            for (int x = 0; x <= this.TraceLength - 1; ++x) {
                try {
                    if (i == 0) {
                        this.A[x] = dis.readShort();
                    }
                    if (i == 1) {
                        this.C[x] = dis.readShort();
                    }
                    if (i == 2) {
                        this.G[x] = dis.readShort();
                    }
                    if (i != 3) continue;
                    this.T[x] = dis.readShort();
                    continue;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unexpected IOException encountered while manipulating internal streams.");
                }
            }
        }
    }

    private void setSeq() {
        char[] tempseq = new char[this.SeqLength];
        for (int x = 0; x <= this.SeqLength - 1; ++x) {
            tempseq[x] = (char)this.TraceData[this.PBAS2 + x];
        }
        this.sequence = new String(tempseq);
    }

    private void setBasecalls() {
        this.Basecalls = new int[this.SeqLength];
        byte[] qq = new byte[this.SeqLength * 2];
        this.getSubArray(qq, this.PLOC);
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(qq));
        for (int i = 0; i <= this.SeqLength - 1; ++i) {
            try {
                this.Basecalls[i] = dis.readShort();
                continue;
            }
            catch (IOException e) {
                throw new IllegalStateException("Unexpected IOException encountered while manipulating internal streams.");
            }
        }
    }

    private int getIntAt(int pointer) {
        int out = 0;
        byte[] temp = new byte[4];
        this.getSubArray(temp, pointer);
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(temp));
            out = dis.readInt();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IOException encountered while manipulating internal streams.");
        }
        return out;
    }

    private int transmute(int ya, int height, double scale) {
        return height - 45 - (int)((double)ya * scale);
    }

    private int getMaximum() {
        if (this.maximum > 0) {
            return this.maximum;
        }
        int max = 0;
        for (int x = 0; x <= this.T.length - 1; ++x) {
            if (this.T[x] > max) {
                max = this.T[x];
            }
            if (this.A[x] > max) {
                max = this.A[x];
            }
            if (this.C[x] > max) {
                max = this.C[x];
            }
            if (this.G[x] <= max) continue;
            max = this.G[x];
        }
        return max;
    }

    private double calculateScale(int height) {
        double newScale = 0.0;
        double max = this.getMaximum();
        double ht = height;
        newScale = (ht - 50.0) / max;
        return newScale;
    }

    private void setIndex() {
        byte[] RecNameArray = new byte[4];
        int DataCounter = 0;
        int PBASCounter = 0;
        int PLOCCounter = 0;
        this.IndexBase = this.getIntAt(AbsIndexBase + this.MacJunk);
        int NumRecords = this.getIntAt(AbsIndexBase - 8 + this.MacJunk);
        for (int record = 0; record <= NumRecords - 1; ++record) {
            this.getSubArray(RecNameArray, this.IndexBase + record * 28);
            String RecName = new String(RecNameArray);
            if (RecName.equals("FWO_")) {
                this.FWO = this.IndexBase + record * 28 + 20;
            }
            if (RecName.equals("DATA")) {
                if (++DataCounter == 9) {
                    this.DATA9 = this.IndexBase + record * 28 + 20;
                }
                if (DataCounter == 10) {
                    this.DATA10 = this.IndexBase + record * 28 + 20;
                }
                if (DataCounter == 11) {
                    this.DATA11 = this.IndexBase + record * 28 + 20;
                }
                if (DataCounter == 12) {
                    this.DATA12 = this.IndexBase + record * 28 + 20;
                }
            }
            if (RecName.equals("PBAS") && ++PBASCounter == 2) {
                this.PBAS2 = this.IndexBase + record * 28 + 20;
            }
            if (!RecName.equals("PLOC") || ++PLOCCounter != 2) continue;
            this.PLOC = this.IndexBase + record * 28 + 20;
        }
        this.TraceLength = this.getIntAt(this.DATA12 - 8);
        this.SeqLength = this.getIntAt(this.PBAS2 - 4);
        this.PLOC = this.getIntAt(this.PLOC) + this.MacJunk;
        this.DATA9 = this.getIntAt(this.DATA9) + this.MacJunk;
        this.DATA10 = this.getIntAt(this.DATA10) + this.MacJunk;
        this.DATA11 = this.getIntAt(this.DATA11) + this.MacJunk;
        this.DATA12 = this.getIntAt(this.DATA12) + this.MacJunk;
        this.PBAS2 = this.getIntAt(this.PBAS2) + this.MacJunk;
    }

    private boolean isABI() {
        int i;
        char[] ABI = new char[4];
        for (i = 0; i <= 2; ++i) {
            ABI[i] = (char)this.TraceData[i];
        }
        if (ABI[0] == 'A' && ABI[1] == 'B' && ABI[2] == 'I') {
            return true;
        }
        for (i = 128; i <= 130; ++i) {
            ABI[i] = (char)this.TraceData[i];
        }
        if (ABI[0] == 'A' && ABI[1] == 'B' && ABI[2] == 'I') {
            this.MacJunk = 128;
            return true;
        }
        return false;
    }
}

