/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.lola;

import java.io.File;
import org.baderlab.brain.AminoAcidGrouping;

public class LolaParameterSet {
    private File profileFile = null;
    private File codonBiasFile = null;
    private boolean uniquePeptides;
    private double fuzzFactor;
    private File outputPath = null;
    private int logoStartIndex;
    private int logoHeight;
    private double logoTrimPercentage;
    private String logoImageFormat;
    private String treeTitle;
    private String treeImageFormat;
    private String treeFilename;
    private double treeLeafTrimFactor;
    private double treeInternalNodeTrimFactor;
    private String treeLeafOrderingMethod;
    private AminoAcidGrouping aaGrouping;

    public LolaParameterSet() {
        this.profileFile = null;
        this.codonBiasFile = null;
        this.uniquePeptides = true;
        this.fuzzFactor = 0.0;
        this.outputPath = null;
        this.logoStartIndex = 1;
        this.logoHeight = 180;
        this.logoTrimPercentage = 0.1;
        this.logoImageFormat = "PDF";
        this.treeTitle = "Sequence Logo Tree";
        this.treeImageFormat = "PDF";
        this.treeFilename = null;
        this.treeLeafTrimFactor = 0.1;
        this.treeInternalNodeTrimFactor = 0.1;
        this.treeLeafOrderingMethod = "Bar-Joseph";
        this.aaGrouping = new AminoAcidGrouping();
    }

    public LolaParameterSet(File profileFile, File biasFile, boolean uniquePeptides, double fuzzFactor, File outputPath, int logoStartIndex, int logoHeight, double logoTrimPercentage, String logoImageFormat, String treeTitle, String treeImageFormat, String treeFilename, double treeLeafTrimFactor, double treeInternalNodeTrimFactor, String treeLeafOrderingMethod, AminoAcidGrouping aaGrouping) {
        this.profileFile = profileFile;
        this.codonBiasFile = biasFile;
        this.uniquePeptides = uniquePeptides;
        this.fuzzFactor = fuzzFactor;
        this.outputPath = outputPath;
        this.logoStartIndex = logoStartIndex;
        this.logoHeight = logoHeight;
        this.logoTrimPercentage = logoTrimPercentage;
        this.logoImageFormat = logoImageFormat;
        this.treeTitle = treeTitle;
        this.treeImageFormat = treeImageFormat;
        this.treeFilename = treeFilename;
        this.treeLeafTrimFactor = treeLeafTrimFactor;
        this.treeInternalNodeTrimFactor = treeInternalNodeTrimFactor;
        this.treeLeafOrderingMethod = treeLeafOrderingMethod;
        this.aaGrouping = aaGrouping;
    }

    public LolaParameterSet(File profileFile, File biasFile, boolean uniquePeptides, double fuzzFactor, File outputPath, int logoStartIndex, int logoHeight, double logoTrimPercentage, String logoImageFormat, String logoColorStyle, AminoAcidGrouping aaGrouping) {
        this.profileFile = profileFile;
        this.codonBiasFile = biasFile;
        this.uniquePeptides = uniquePeptides;
        this.fuzzFactor = fuzzFactor;
        this.outputPath = outputPath;
        this.logoStartIndex = logoStartIndex;
        this.logoHeight = logoHeight;
        this.logoTrimPercentage = logoTrimPercentage;
        this.logoImageFormat = logoImageFormat;
        this.aaGrouping = aaGrouping;
    }

    public LolaParameterSet copy() {
        LolaParameterSet newParamSet = new LolaParameterSet(this.getProfileFile(), this.getCodonBiasFile(), this.getUniquePeptides(), this.getFuzzFactor(), this.getOutputPath(), this.getLogoStartIndex(), this.getLogoHeight(), this.getLogoTrimPercentage(), this.getLogoImageFileFormat(), this.getTreeTitle(), this.getTreeImageFormat(), this.getTreeFilename(), this.getTreeLeafTrimFactor(), this.getTreeInternalNodeTrimFactor(), this.getTreeLeafOrderingMethod(), this.getAminoAcidGrouping());
        return newParamSet;
    }

    public File getProfileFile() {
        return this.profileFile;
    }

    public void setProfileFile(File file) {
        this.profileFile = file;
    }

    public File getCodonBiasFile() {
        return this.codonBiasFile;
    }

    public void setCodonBiasFile(File file) {
        this.codonBiasFile = file;
    }

    public boolean getUniquePeptides() {
        return this.uniquePeptides;
    }

    public void setUniquePeptides(boolean value) {
        this.uniquePeptides = value;
    }

    public double getFuzzFactor() {
        return this.fuzzFactor;
    }

    public void setFuzzFactor(double value) {
        this.fuzzFactor = value;
    }

    public File getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(File path) {
        this.outputPath = path;
    }

    public int getLogoStartIndex() {
        return this.logoStartIndex;
    }

    public void setLogoStartIndex(int index) {
        this.logoStartIndex = index;
    }

    public int getLogoHeight() {
        return this.logoHeight;
    }

    public void setLogoHeight(int height) {
        this.logoHeight = height;
    }

    public double getLogoTrimPercentage() {
        return this.logoTrimPercentage;
    }

    public void setLogoTrimPercentage(double percentage) {
        this.logoTrimPercentage = percentage;
    }

    public String getLogoImageFileFormat() {
        return this.logoImageFormat;
    }

    public void setLogoImageFormat(String imageFormat) {
        this.logoImageFormat = imageFormat;
    }

    public String getTreeTitle() {
        return this.treeTitle;
    }

    public void setTreeTitle(String treeTitle) {
        this.treeTitle = treeTitle;
    }

    public String getTreeImageFormat() {
        return this.treeImageFormat;
    }

    public void setTreeImageFormat(String treeImageFormat) {
        this.treeImageFormat = treeImageFormat;
    }

    public String getTreeFilename() {
        return this.treeFilename;
    }

    public void setTreeFilename(String treeFilename) {
        this.treeFilename = treeFilename;
    }

    public double getTreeLeafTrimFactor() {
        return this.treeLeafTrimFactor;
    }

    public void setTreeLeafTrimFactor(double treeLeafTrimFactor) {
        this.treeLeafTrimFactor = treeLeafTrimFactor;
    }

    public double getTreeInternalNodeTrimFactor() {
        return this.treeInternalNodeTrimFactor;
    }

    public void setTreeInternalNodeTrimFactor(double treeInternalNodeTrimFactor) {
        this.treeInternalNodeTrimFactor = treeInternalNodeTrimFactor;
    }

    public AminoAcidGrouping getAminoAcidGrouping() {
        return this.aaGrouping;
    }

    public void setAminoAcidGrouping(AminoAcidGrouping aaGrouping) {
        this.aaGrouping = aaGrouping;
    }

    public String getTreeLeafOrderingMethod() {
        return this.treeLeafOrderingMethod;
    }

    public void setTreeLeafOrderingMethod(String treeLeafOrderingMethod) {
        this.treeLeafOrderingMethod = treeLeafOrderingMethod;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        sb.append("Profile File: " + this.profileFile.toString() + lineSep);
        return sb.toString();
    }
}

