/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import cytoscape.task.TaskMonitor;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.baderlab.brain.DeltaGProfileAnnotator;
import org.baderlab.brain.MultiSequenceSearchResultSet;
import org.baderlab.brain.NormalizedProfileAnnotator;
import org.baderlab.brain.ProteinDatabaseSearchParams;
import org.baderlab.brain.ProteinProfile;
import org.baderlab.brain.ProteinTerminus;
import org.baderlab.brain.SequenceIdentifierAware;
import org.baderlab.brain.SequenceSearchResultSet;
import org.biojava.bio.BioException;
import org.biojava.bio.dp.ScoreType;
import org.biojava.bio.dp.WeightMatrixAnnotator;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceAnnotator;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.seq.io.SeqIOTools;
import org.biojava.bio.symbol.Location;
import org.biojava.utils.ChangeVetoException;

public class ProteinDatabaseSearch
implements SequenceIdentifierAware {
    private SequenceIterator searchDatabase = null;
    private BufferedReader br = null;
    private String dbFileName = null;
    private String dbFormat = null;
    private long lastSearchTime;
    private boolean cancelled = false;
    private TaskMonitor taskMonitor = null;

    public ProteinDatabaseSearch(String dbFileName, String dbFormat) throws FileNotFoundException, BioException {
        this.br = new BufferedReader(new FileReader(dbFileName));
        this.searchDatabase = (SequenceIterator)SeqIOTools.fileToBiojava(dbFormat, "PROTEIN", this.br);
        this.dbFileName = dbFileName;
        this.dbFormat = dbFormat;
    }

    public long getLastSearchTime() {
        return this.lastSearchTime;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        this.taskMonitor = taskMonitor;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public SequenceSearchResultSet profileSearchDB(ProteinProfile profile, double scoreThreshold, ProteinDatabaseSearchParams params) throws BioException {
        ArrayList<ProteinProfile> profileList = new ArrayList<ProteinProfile>(1);
        profileList.add(profile);
        ArrayList<Double> scoreThresholdList = new ArrayList<Double>(1);
        scoreThresholdList.add(new Double(scoreThreshold));
        MultiSequenceSearchResultSet resultSets = this.multiProfileSearchDB(profileList, scoreThresholdList, params);
        return resultSets.getResultSet(profile);
    }

    public MultiSequenceSearchResultSet multiProfileSearchDB(List profileList, List scoreThresholdList, ProteinDatabaseSearchParams params) throws BioException {
        SequenceAnnotator annotator;
        SequenceSearchResultSet resultSet2;
        long count = 0L;
        long msTimeBefore = System.currentTimeMillis();
        MultiSequenceSearchResultSet multiResultSet = new MultiSequenceSearchResultSet();
        HashMap<ProteinProfile, NormalizedProfileAnnotator> profile2annotator = new HashMap<ProteinProfile, NormalizedProfileAnnotator>();
        int i = 0;
        while (i < profileList.size()) {
            ProteinProfile profile = (ProteinProfile)profileList.get(i);
            double scoreThreshold = (Double)scoreThresholdList.get(i);
            double pValueScoreThreshold = Math.pow(10.0, -scoreThreshold);
            resultSet2 = new SequenceSearchResultSet(pValueScoreThreshold, params);
            resultSet2.setProfile(profile);
            multiResultSet.add(resultSet2);
            if (params.getScoreType() == 2) {
                annotator = new NormalizedProfileAnnotator(profile, pValueScoreThreshold);
            } else if (params.getScoreType() == 1) {
                annotator = new WeightMatrixAnnotator(profile.getWeightMatrix(), ScoreType.PROBABILITY, pValueScoreThreshold);
            } else if (params.getScoreType() == 3) {
                annotator = new DeltaGProfileAnnotator(profile, scoreThreshold);
            } else {
                throw new IllegalArgumentException("Illegal score type passed. (" + params.getScoreType() + ")");
            }
            profile2annotator.put(profile, (NormalizedProfileAnnotator)annotator);
            if (this.cancelled) break;
            ++i;
        }
        while (this.searchDatabase.hasNext()) {
            if (this.cancelled) break;
            Sequence sequenceFromDB = this.searchDatabase.nextSequence();
            Sequence filteredSequenceFromDB = this.filterTrailingAsterisk(sequenceFromDB);
            Sequence sequenceToSearch = null;
            if (params.getLength() > 0) {
                sequenceToSearch = ProteinTerminus.getSequenceTerminus(filteredSequenceFromDB, params.getLength(), params.getTerminus());
            }
            int i2 = 0;
            while (i2 < profileList.size()) {
                Sequence annotatedSequenceToSearch;
                if (this.cancelled) break;
                ProteinProfile profile = (ProteinProfile)profileList.get(i2);
                resultSet2 = multiResultSet.getResultSet(profile);
                if (sequenceToSearch == null) {
                    sequenceToSearch = ProteinTerminus.getSequenceTerminus(filteredSequenceFromDB, profile.getNumColumns(), params.getTerminus());
                }
                annotator = (SequenceAnnotator)profile2annotator.get(profile);
                try {
                    annotatedSequenceToSearch = annotator.annotate(sequenceToSearch);
                }
                catch (ChangeVetoException e) {
                    e.printStackTrace();
                    return null;
                }
                if (annotatedSequenceToSearch.countFeatures() > 0) {
                    boolean containsInvalidSymbols = false;
                    if (annotatedSequenceToSearch.seqString().indexOf("X") >= 0 || annotatedSequenceToSearch.seqString().indexOf("-") >= 0) {
                        containsInvalidSymbols = true;
                    }
                    Iterator it = annotatedSequenceToSearch.features();
                    while (it.hasNext()) {
                        Feature f = (Feature)it.next();
                        if (f.getAnnotation() == null || !f.getAnnotation().containsProperty("score")) continue;
                        Location loc = f.getLocation();
                        Double score = (Double)f.getAnnotation().getProperty("score");
                        double convertedScore = 0.0;
                        if (params.getScoreType() == 2 || params.getScoreType() == 1) {
                            double neglogscore = score == 0.0 ? Double.MAX_VALUE : (score == 1.0 ? 0.0 : -Math.log(score) / Math.log(10.0));
                            if (containsInvalidSymbols) {
                                neglogscore = -Math.log(resultSet2.getScoreThreshold()) / Math.log(10.0);
                            }
                            convertedScore = neglogscore;
                        } else if (params.getScoreType() == 3) {
                            convertedScore = score;
                        }
                        if (params.isDontSaveSequences()) {
                            resultSet2.addSequenceHit(new Double(convertedScore));
                        } else {
                            resultSet2.addSequenceHit(sequenceToSearch, loc.getMin(), loc.getMax(), new Double(convertedScore));
                            resultSet2.addOriginalSequenceToHit(sequenceToSearch, sequenceFromDB);
                        }
                        if (!params.isMultipleHits()) break;
                    }
                }
                ++i2;
            }
            if (this.taskMonitor == null || ++count % 500L != 0L) continue;
            this.taskMonitor.setStatus("Searching sequence " + count);
        }
        Collection resultSets = multiResultSet.getAllResultSets();
        for (SequenceSearchResultSet resultSet2 : resultSets) {
            resultSet2.setNumberOfSequencesSearched(count);
        }
        long msTimeAfter = System.currentTimeMillis();
        this.lastSearchTime = msTimeAfter - msTimeBefore;
        if (this.taskMonitor != null) {
            this.taskMonitor.setStatus("Searching sequence " + count);
        }
        return multiResultSet;
    }

    public SequenceSearchResultSet regexSearchDB(String regex, ProteinDatabaseSearchParams params) throws BioException {
        ArrayList<String> regexList = new ArrayList<String>(1);
        regexList.add(regex);
        MultiSequenceSearchResultSet resultSets = this.multiRegexSearchDB(regexList, params);
        return resultSets.getResultSet(regex);
    }

    public MultiSequenceSearchResultSet multiRegexSearchDB(List regexList, ProteinDatabaseSearchParams params) throws BioException {
        SequenceSearchResultSet resultSet2;
        long count = 0L;
        long msTimeBefore = System.currentTimeMillis();
        MultiSequenceSearchResultSet multiResultSet = new MultiSequenceSearchResultSet();
        int i = 0;
        while (i < regexList.size()) {
            String regex = (String)regexList.get(i);
            resultSet2 = new SequenceSearchResultSet(params);
            resultSet2.setRegex(regex);
            multiResultSet.add(resultSet2);
            ++i;
        }
        while (this.searchDatabase.hasNext()) {
            if (this.cancelled) break;
            Sequence sequenceFromDB = this.searchDatabase.nextSequence();
            sequenceFromDB = this.filterTrailingAsterisk(sequenceFromDB);
            Sequence sequenceToSearch = null;
            if (params.getLength() > 0) {
                sequenceToSearch = ProteinTerminus.getSequenceTerminus(sequenceFromDB, params.getLength(), params.getTerminus());
            }
            int i2 = 0;
            while (i2 < regexList.size()) {
                if (this.cancelled) break;
                String regex = (String)regexList.get(i2);
                resultSet2 = multiResultSet.getResultSet(regex);
                if (sequenceToSearch == null) {
                    sequenceToSearch = ProteinTerminus.getSequenceTerminus(sequenceFromDB, regex.length(), params.getTerminus());
                }
                Pattern p = Pattern.compile(regex);
                Matcher m = p.matcher(sequenceToSearch.seqString());
                int start = 0;
                while (m.find(start)) {
                    start = m.start();
                    resultSet2.addSequenceHit(sequenceToSearch, start + 1, m.end());
                    ++start;
                    if (!params.isMultipleHits()) break;
                }
                ++i2;
            }
            if (this.taskMonitor == null || ++count % 500L != 0L) continue;
            this.taskMonitor.setStatus("Searching sequence " + count);
        }
        Collection resultSets = multiResultSet.getAllResultSets();
        for (SequenceSearchResultSet resultSet2 : resultSets) {
            resultSet2.setNumberOfSequencesSearched(count);
        }
        long msTimeAfter = System.currentTimeMillis();
        this.lastSearchTime = msTimeAfter - msTimeBefore;
        if (this.taskMonitor != null) {
            this.taskMonitor.setStatus("Searching sequence " + count);
        }
        return multiResultSet;
    }

    public void close() throws IOException {
        this.br.close();
    }

    public void reset() throws IOException, BioException {
        this.br.close();
        this.br = new BufferedReader(new FileReader(this.dbFileName));
        this.searchDatabase = (SequenceIterator)SeqIOTools.fileToBiojava(this.dbFormat, "PROTEIN", this.br);
    }

    @Override
    public String getIdentifier(Sequence sequence) {
        return sequence.getName();
    }

    private Sequence filterTrailingAsterisk(Sequence sequence) {
        if (!sequence.subStr(sequence.length(), sequence.length()).equals("*")) {
            return sequence;
        }
        SimpleSequence sequenceSubSet = new SimpleSequence(sequence.subList(1, sequence.length() - 1), "", sequence.getName(), null);
        return sequenceSubSet;
    }
}

