/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings;

import cytoscape.visual.Arrow;
import cytoscape.visual.LabelPosition;
import cytoscape.visual.LineType;
import cytoscape.visual.ui.IconSupport;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LegendTable
extends JPanel {
    byte type;

    public LegendTable(Object[][] data, byte b) {
        this.type = b;
        this.setLayout(new GridLayout(data.length, data[0].length, 4, 4));
        this.setBackground(Color.white);
        this.setAlignmentX(0.0f);
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                this.add(this.getValue(data[i][j]));
            }
        }
    }

    private JComponent getValue(Object value) {
        JLabel j = null;
        if (value instanceof Byte) {
            ImageIcon i = this.getIcon(value);
            j = new JLabel(i);
        } else if (value instanceof LineType) {
            ImageIcon i = this.getIcon(value);
            j = new JLabel(i);
        } else if (value instanceof Arrow) {
            ImageIcon i = this.getIcon(value);
            j = new JLabel(i);
        } else if (value instanceof Color) {
            j = new JLabel(IconSupport.getColorIcon((Color)value));
        } else if (value instanceof Font) {
            Font f = (Font)value;
            JLabel lab = new JLabel();
            lab.setText(f.getFontName());
            lab.setFont(f);
            j = lab;
        } else if (value instanceof Double) {
            if (this.type == 4) {
                j = new JLabel(IconSupport.getNodeSizeIcon((Double)value));
            } else if (this.type == 127) {
                j = new JLabel(IconSupport.getNodeWidthIcon((Double)value));
            } else if (this.type == 126) {
                j = new JLabel(IconSupport.getNodeHeightIcon((Double)value));
            }
        } else {
            j = value instanceof LabelPosition ? new JLabel(IconSupport.getLabelPositionIcon((LabelPosition)value)) : new JLabel(value.toString());
        }
        j.setAlignmentX(0.0f);
        return j;
    }

    private ImageIcon getIcon(Object o) {
        if (o == null) {
            return null;
        }
        IconSupport is = new IconSupport(o);
        return is.getCurrentIcon();
    }

    public static JPanel getHeader() {
        JPanel titles = new JPanel();
        titles.setLayout(new GridLayout(1, 2));
        titles.setAlignmentX(0.0f);
        titles.setBackground(Color.white);
        titles.add(new JLabel("Visual Representation"));
        titles.add(new JLabel("Attribute Value"));
        return titles;
    }
}

