/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.servers.ui;

import cytoscape.Cytoscape;
import cytoscape.data.servers.BioDataServer;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.io.IOException;
import java.util.Arrays;

class LoadGeneOntologyTask
implements Task {
    private TaskMonitor taskMonitor;
    private String manifest;

    public LoadGeneOntologyTask(String target) {
        this.manifest = target;
    }

    public void run() {
        this.taskMonitor.setStatus("Reading Gene Ontology Database files...");
        this.taskMonitor.setPercentCompleted(-1);
        Cytoscape.loadBioDataServer(this.manifest);
        BioDataServer bds = Cytoscape.getBioDataServer();
        if (bds.getAnnotationCount() != 0) {
            this.informUserOfServerStats(bds);
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append("Could not load Gene Ontology Server.");
            sb.append("\nSome of the data file may not be a valid ontology or annotation file.");
            this.taskMonitor.setException(new IOException(sb.toString()), sb.toString());
        }
        this.taskMonitor.setPercentCompleted(100);
        Cytoscape.firePropertyChange(Cytoscape.DATASERVER_CHANGED, null, null);
    }

    private void informUserOfServerStats(BioDataServer server) {
        String message = server.describe();
        String newMessage = "";
        String status2 = "";
        Object[] oneEntry = message.split("\n");
        Arrays.sort(oneEntry);
        for (int i = 0; i < oneEntry.length; ++i) {
            String[] element = ((String)oneEntry[i]).split(",");
            if (element.length <= 2) continue;
            for (int j = 0; j < element.length; ++j) {
                if (element[j].startsWith("annotation")) continue;
                newMessage = newMessage + element[j] + "\n     ";
            }
            newMessage = newMessage + "\n";
        }
        status2 = "Summary of the Gene Ontology Server:\n\n" + newMessage + "\n\nGene Ontology Server loaded successfully.";
        this.taskMonitor.setStatus(status2);
    }

    public void halt() {
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) throws IllegalThreadStateException {
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Loading Gene Ontology Database");
    }
}

