/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cern.colt.list.IntArrayList;
import cern.colt.map.OpenIntIntHashMap;
import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.data.CyAttributes;
import cytoscape.data.readers.AbstractGraphReader;
import cytoscape.data.readers.GMLException;
import cytoscape.data.readers.GMLParser;
import cytoscape.data.readers.GraphReader;
import cytoscape.data.readers.KeyValue;
import cytoscape.dialogs.VisualStyleBuilderDialog;
import cytoscape.init.CyInitParams;
import cytoscape.task.TaskMonitor;
import cytoscape.util.PercentUtil;
import cytoscape.visual.Arrow;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.LineType;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.calculators.GenericEdgeColorCalculator;
import cytoscape.visual.calculators.GenericEdgeLineTypeCalculator;
import cytoscape.visual.calculators.GenericEdgeSourceArrowCalculator;
import cytoscape.visual.calculators.GenericEdgeTargetArrowCalculator;
import cytoscape.visual.calculators.GenericNodeBorderColorCalculator;
import cytoscape.visual.calculators.GenericNodeFillColorCalculator;
import cytoscape.visual.calculators.GenericNodeHeightCalculator;
import cytoscape.visual.calculators.GenericNodeLabelCalculator;
import cytoscape.visual.calculators.GenericNodeLineTypeCalculator;
import cytoscape.visual.calculators.GenericNodeShapeCalculator;
import cytoscape.visual.calculators.GenericNodeWidthCalculator;
import cytoscape.visual.mappings.DiscreteMapping;
import cytoscape.visual.mappings.PassThroughMapping;
import giny.view.EdgeView;
import giny.view.GraphView;
import giny.view.NodeView;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class GMLReader
extends AbstractGraphReader {
    protected static String GRAPH = "graph";
    protected static String NODE = "node";
    protected static String EDGE = "edge";
    protected static String GRAPHICS = "graphics";
    protected static String LABEL = "label";
    protected static String SOURCE = "source";
    protected static String TARGET = "target";
    protected static String X = "x";
    protected static String Y = "y";
    protected static String H = "h";
    protected static String W = "w";
    protected static String TYPE = "type";
    protected static String ID = "id";
    protected static String ROOT_INDEX = "root_index";
    protected static String RECTANGLE = "rectangle";
    protected static String ELLIPSE = "ellipse";
    protected static String LINE = "Line";
    protected static String POINT = "point";
    protected static String DIAMOND = "diamond";
    protected static String HEXAGON = "hexagon";
    protected static String OCTAGON = "octagon";
    protected static String PARALELLOGRAM = "parallelogram";
    protected static String TRIANGLE = "triangle";
    protected static String FILL = "fill";
    protected static String WIDTH = "width";
    protected static String STRAIGHT_LINES = "line";
    protected static String CURVED_LINES = "curved";
    protected static String SOURCE_ARROW = "source_arrow";
    protected static String TARGET_ARROW = "target_arrow";
    protected static String ARROW = "arrow";
    protected static String ARROW_NONE = "none";
    protected static String ARROW_FIRST = "first";
    protected static String ARROW_LAST = "last";
    protected static String ARROW_BOTH = "both";
    protected static String OUTLINE = "outline";
    protected static String OUTLINE_WIDTH = "outline_width";
    protected static String DEFAULT_EDGE_INTERACTION = "pp";
    protected static String VERSION = "Version";
    protected static String CREATOR = "Creator";
    private String mapSuffix;
    private Color DEF_COLOR = new Color(153, 153, 255);
    List keyVals;
    OpenIntIntHashMap nodeIDMap;
    IntArrayList nodes;
    IntArrayList sources;
    IntArrayList targets;
    Vector node_labels;
    Vector edge_labels;
    Vector edge_root_index_pairs;
    Vector node_root_index_pairs;
    Vector edge_names;
    Vector node_names;
    IntArrayList giny_nodes;
    IntArrayList giny_edges;
    private TaskMonitor taskMonitor;
    private PercentUtil percentUtil;
    String styleName = this.createVSName();
    VisualStyle gmlstyle;
    NodeAppearanceCalculator nac;
    EdgeAppearanceCalculator eac;
    GlobalAppearanceCalculator gac;
    CalculatorCatalog catalog;
    HashMap nodeW;
    HashMap nodeH;
    HashMap nodeShape;
    HashMap nodeCol;
    HashMap nodeBWidth;
    HashMap nodeBCol;
    HashMap edgeCol;
    HashMap edgeWidth;
    HashMap edgeArrow;
    HashMap edgeShape;

    public GMLReader(String filename) {
        this(filename, null);
    }

    public GMLReader(String filename, TaskMonitor taskMonitor) {
        super(filename);
        this.initializeHash();
        this.initStyle();
        if (taskMonitor != null) {
            this.taskMonitor = taskMonitor;
            this.percentUtil = new PercentUtil(5);
        }
    }

    private String createVSName() {
        String target = null;
        File fileTest = new File(this.fileName);
        target = fileTest.getName();
        System.out.println("Target GML file is " + target);
        this.mapSuffix = " for " + this.fileName;
        return target.concat("_GML_style");
    }

    private void initializeHash() {
        this.nodeW = new HashMap();
        this.nodeH = new HashMap();
        this.nodeShape = new HashMap();
        this.nodeCol = new HashMap();
        this.nodeBWidth = new HashMap();
        this.nodeBCol = new HashMap();
        this.edgeCol = new HashMap();
        this.edgeWidth = new HashMap();
        this.edgeArrow = new HashMap();
        this.edgeShape = new HashMap();
        this.edge_names = new Vector();
        this.node_names = new Vector();
    }

    private void initStyle() {
        this.nac = new NodeAppearanceCalculator();
        this.eac = new EdgeAppearanceCalculator();
        this.gac = new GlobalAppearanceCalculator();
        this.nac.setNodeSizeLocked(false);
    }

    public void setNodeMaps(VisualMappingManager vizmapper) {
        String cName = "GML Labels" + this.mapSuffix;
        Calculator nlc = this.catalog.getCalculator((byte)5, cName);
        if (nlc == null) {
            PassThroughMapping m = new PassThroughMapping((Object)"", "ID");
            nlc = new GenericNodeLabelCalculator(cName, m);
        }
        this.nac.setCalculator(nlc);
        DiscreteMapping nodeShapeMapping = new DiscreteMapping(new Byte(8), "ID", 1);
        nodeShapeMapping.setControllingAttributeName("ID", vizmapper.getNetwork(), false);
        for (int i = 0; i < this.node_names.size(); ++i) {
            String key = (String)this.node_names.get(i);
            Byte value = this.nodeShape.containsKey(key) ? (Byte)this.nodeShape.get(key) : new Byte(8);
            nodeShapeMapping.putMapValue(key, value);
        }
        GenericNodeShapeCalculator shapeCalculator = new GenericNodeShapeCalculator("GML_Node_Shape" + this.mapSuffix, nodeShapeMapping);
        this.nac.setCalculator(shapeCalculator);
        Color defcol = Color.WHITE;
        DiscreteMapping nodeColorMapping = new DiscreteMapping(defcol, 1);
        nodeColorMapping.setControllingAttributeName("ID", vizmapper.getNetwork(), true);
        for (int i = 0; i < this.node_names.size(); ++i) {
            Color c;
            String key = (String)this.node_names.get(i);
            if (this.nodeCol.containsKey(key)) {
                String col = this.nodeCol.get(key).toString();
                c = this.getColor(col);
            } else {
                c = defcol;
            }
            nodeColorMapping.putMapValue(key, c);
        }
        GenericNodeFillColorCalculator nodeColorCalculator = new GenericNodeFillColorCalculator("GML Node Color" + this.mapSuffix, nodeColorMapping);
        this.nac.setCalculator(nodeColorCalculator);
        Color defbcol = Color.BLACK;
        DiscreteMapping nodeBorderColorMapping = new DiscreteMapping(defcol, 1);
        nodeBorderColorMapping.setControllingAttributeName("ID", vizmapper.getNetwork(), true);
        for (int i = 0; i < this.node_names.size(); ++i) {
            Color c;
            String key = (String)this.node_names.get(i);
            if (this.nodeBCol.containsKey(key)) {
                String col = this.nodeBCol.get(key).toString();
                c = this.getColor(col);
            } else {
                c = defbcol;
            }
            nodeBorderColorMapping.putMapValue(key, c);
        }
        GenericNodeBorderColorCalculator nodeBorderColorCalculator = new GenericNodeBorderColorCalculator("GML Node Border Color" + this.mapSuffix, nodeBorderColorMapping);
        this.nac.setCalculator(nodeBorderColorCalculator);
        Double defaultWidth = new Double(this.nac.getDefaultAppearance().getWidth());
        DiscreteMapping nodeWMapping = new DiscreteMapping(defaultWidth, 1);
        nodeWMapping.setControllingAttributeName("ID", vizmapper.getNetwork(), true);
        for (int i = 0; i < this.node_names.size(); ++i) {
            String key = (String)this.node_names.get(i);
            Double w = this.nodeW.containsKey(key) ? new Double(Double.parseDouble(this.nodeW.get(key).toString())) : defaultWidth;
            nodeWMapping.putMapValue(key, w);
        }
        GenericNodeWidthCalculator nodeSizeCalculatorW = new GenericNodeWidthCalculator("GML Node Width" + this.mapSuffix, nodeWMapping);
        this.nac.setCalculator(nodeSizeCalculatorW);
        Double defaultHeight = new Double(this.nac.getDefaultAppearance().getHeight());
        DiscreteMapping nodeHMapping = new DiscreteMapping(defaultHeight, 1);
        nodeHMapping.setControllingAttributeName("ID", vizmapper.getNetwork(), true);
        for (int i = 0; i < this.node_names.size(); ++i) {
            String key = (String)this.node_names.get(i);
            Double h = this.nodeH.containsKey(key) ? new Double(Double.parseDouble(this.nodeH.get(key).toString())) : defaultHeight;
            nodeHMapping.putMapValue(key, h);
        }
        GenericNodeHeightCalculator nodeSizeCalculatorH = new GenericNodeHeightCalculator("GML Node Height" + this.mapSuffix, nodeHMapping);
        this.nac.setCalculator(nodeSizeCalculatorH);
        DiscreteMapping nodeBorderTypeMapping = new DiscreteMapping(LineType.LINE_1, 1);
        nodeBorderTypeMapping.setControllingAttributeName("ID", vizmapper.getNetwork(), false);
        for (int i = 0; i < this.node_names.size(); ++i) {
            String key = (String)this.node_names.get(i);
            double value = 1.0;
            int ivalue = 1;
            if (this.nodeBWidth.containsKey(key)) {
                value = Double.parseDouble(this.nodeBWidth.get(key).toString());
            }
            ivalue = (int)value;
            LineType lt = GMLReader.getLineType(ivalue);
            nodeBorderTypeMapping.putMapValue(key, lt);
        }
        GenericNodeLineTypeCalculator nodeBoderTypeCalculator = new GenericNodeLineTypeCalculator("GML Node Border" + this.mapSuffix, nodeBorderTypeMapping);
        this.nac.setCalculator(nodeBoderTypeCalculator);
    }

    public void setEdgeMaps(VisualMappingManager vizmapper) {
        Color defcol = this.eac.getDefaultAppearance().getColor();
        DiscreteMapping edgeColorMapping = new DiscreteMapping(defcol, 0);
        edgeColorMapping.setControllingAttributeName("ID", vizmapper.getNetwork(), false);
        for (int i = 0; i < this.edge_names.size(); ++i) {
            Color c;
            String key = (String)this.edge_names.get(i);
            if (this.edgeCol.containsKey(key)) {
                String col = this.edgeCol.get(key).toString();
                c = this.getColor(col);
            } else {
                c = defcol;
            }
            edgeColorMapping.putMapValue(key, c);
        }
        GenericEdgeColorCalculator edgeColorCalculator = new GenericEdgeColorCalculator("GML Edge Color" + this.mapSuffix, edgeColorMapping);
        this.eac.setCalculator(edgeColorCalculator);
        DiscreteMapping edgeLineTypeMapping = new DiscreteMapping(LineType.LINE_1, 0);
        edgeLineTypeMapping.setControllingAttributeName("ID", vizmapper.getNetwork(), false);
        for (int i = 0; i < this.edge_names.size(); ++i) {
            String key = (String)this.edge_names.get(i);
            double value = 1.0;
            if (this.edgeWidth.containsKey(key)) {
                value = Double.parseDouble(this.edgeWidth.get(key).toString());
            }
            int ivalue = (int)value;
            LineType lt = GMLReader.getLineType(ivalue);
            edgeLineTypeMapping.putMapValue(key, lt);
        }
        GenericEdgeLineTypeCalculator edgeLineTypeCalculator = new GenericEdgeLineTypeCalculator("GML Line Type" + this.mapSuffix, edgeLineTypeMapping);
        this.eac.setCalculator(edgeLineTypeCalculator);
        DiscreteMapping edgeSourceArrowMapping = new DiscreteMapping(Arrow.NONE, 0);
        edgeSourceArrowMapping.setControllingAttributeName("ID", vizmapper.getNetwork(), false);
        DiscreteMapping edgeTargetArrowMapping = new DiscreteMapping(Arrow.NONE, 0);
        edgeTargetArrowMapping.setControllingAttributeName("ID", vizmapper.getNetwork(), false);
        for (int i = 0; i < this.edge_names.size(); ++i) {
            String key = (String)this.edge_names.get(i);
            String value = null;
            value = this.edgeArrow.containsKey(key) ? this.edgeArrow.get(key).toString() : "none";
            if (value.equals("none")) {
                edgeSourceArrowMapping.putMapValue(key, Arrow.NONE);
                edgeTargetArrowMapping.putMapValue(key, Arrow.NONE);
            } else if (value.equals("both")) {
                edgeSourceArrowMapping.putMapValue(key, Arrow.COLOR_ARROW);
                edgeTargetArrowMapping.putMapValue(key, Arrow.COLOR_ARROW);
            } else if (value.equals("last")) {
                edgeSourceArrowMapping.putMapValue(key, Arrow.NONE);
                edgeTargetArrowMapping.putMapValue(key, Arrow.COLOR_ARROW);
            } else if (value.equals("first")) {
                edgeSourceArrowMapping.putMapValue(key, Arrow.COLOR_ARROW);
                edgeTargetArrowMapping.putMapValue(key, Arrow.NONE);
            }
            GenericEdgeSourceArrowCalculator edgeSourceArrowCalculator = new GenericEdgeSourceArrowCalculator("GML Source Arrow Type" + this.mapSuffix, edgeSourceArrowMapping);
            GenericEdgeTargetArrowCalculator edgeTargetArrowCalculator = new GenericEdgeTargetArrowCalculator("GML Target Arrow Type" + this.mapSuffix, edgeTargetArrowMapping);
            this.eac.setCalculator(edgeTargetArrowCalculator);
            this.eac.setCalculator(edgeSourceArrowCalculator);
        }
    }

    public void applyMaps(String mapSuffix, String VSName) {
        if (VSName != null) {
            this.styleName = VSName;
        }
        if (mapSuffix != null) {
            this.mapSuffix = mapSuffix;
        }
        VisualMappingManager vizmapper = Cytoscape.getVisualMappingManager();
        this.catalog = vizmapper.getCalculatorCatalog();
        this.setNodeMaps(vizmapper);
        this.setEdgeMaps(vizmapper);
        this.gac.setDefaultBackgroundColor(this.DEF_COLOR);
        this.gmlstyle = new VisualStyle(this.styleName, this.nac, this.eac, this.gac);
        this.catalog.addVisualStyle(this.gmlstyle);
        vizmapper.setVisualStyle(this.gmlstyle);
        Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
    }

    public void read() {
        try {
            this.keyVals = new GMLParser(this.fileName).parseList();
        }
        catch (Exception io) {
            io.printStackTrace();
            if (this.taskMonitor != null) {
                this.taskMonitor.setException(io, io.getMessage());
            }
            throw new RuntimeException(io.getMessage());
        }
        this.initializeStructures();
        this.readGML(this.keyVals);
        this.createGraph();
        this.extract();
        this.releaseStructures();
    }

    public List getList() {
        return this.keyVals;
    }

    protected void initializeStructures() {
        this.nodes = new IntArrayList();
        this.sources = new IntArrayList();
        this.targets = new IntArrayList();
        this.node_labels = new Vector();
        this.edge_labels = new Vector();
        this.edge_root_index_pairs = new Vector();
        this.node_root_index_pairs = new Vector();
    }

    protected void releaseStructures() {
        this.nodes = null;
        this.sources = null;
        this.targets = null;
        this.node_labels = null;
        this.edge_labels = null;
        this.edge_root_index_pairs = null;
        this.node_root_index_pairs = null;
    }

    protected void createGraph() {
        Cytoscape.ensureCapacity(this.nodes.size(), this.sources.size());
        this.nodeIDMap = new OpenIntIntHashMap(this.nodes.size());
        this.giny_nodes = new IntArrayList(this.nodes.size());
        OpenIntIntHashMap gml_id2order = new OpenIntIntHashMap(this.nodes.size());
        HashSet<String> nodeNameSet = new HashSet<String>(this.nodes.size());
        for (int idx = 0; idx < this.nodes.size(); ++idx) {
            String label;
            if (this.taskMonitor != null) {
                this.taskMonitor.setPercentCompleted(this.percentUtil.getGlobalPercent(2, idx, this.nodes.size()));
            }
            if (!nodeNameSet.add(label = (String)this.node_labels.get(idx))) {
                throw new GMLException("GML id " + this.nodes.get(idx) + " has a duplicated label: " + label);
            }
            CyNode node = Cytoscape.getCyNode(label, true);
            this.giny_nodes.add(node.getRootGraphIndex());
            this.nodeIDMap.put(this.nodes.get(idx), node.getRootGraphIndex());
            gml_id2order.put(this.nodes.get(idx), idx);
            ((KeyValue)this.node_root_index_pairs.get((int)idx)).value = new Integer(node.getRootGraphIndex());
        }
        nodeNameSet = null;
        this.giny_edges = new IntArrayList(this.sources.size());
        HashSet<String> edgeNameSet = new HashSet<String>(this.sources.size());
        CyAttributes edgeAttributes = Cytoscape.getEdgeAttributes();
        for (int idx = 0; idx < this.sources.size(); ++idx) {
            CyEdge edge;
            String edgeName;
            String label;
            if (this.taskMonitor != null) {
                this.taskMonitor.setPercentCompleted(this.percentUtil.getGlobalPercent(3, idx, this.sources.size()));
            }
            if (gml_id2order.containsKey(this.sources.get(idx)) && gml_id2order.containsKey(this.targets.get(idx))) {
                label = (String)this.edge_labels.get(idx);
                String sourceName = (String)this.node_labels.get(gml_id2order.get(this.sources.get(idx)));
                String targetName = (String)this.node_labels.get(gml_id2order.get(this.targets.get(idx)));
                edgeName = CyEdge.createIdentifier(sourceName, label, targetName);
                int duplicate_count = 1;
                while (!edgeNameSet.add(edgeName)) {
                    edgeName = CyEdge.createIdentifier(sourceName, label, targetName) + "_" + duplicate_count;
                    ++duplicate_count;
                }
                this.edge_names.add(idx, edgeName);
                edge = Cytoscape.getRootGraph().getEdge(edgeName);
                if (edge == null) {
                    CyNode node_1 = Cytoscape.getCyNode(sourceName);
                    CyNode node_2 = Cytoscape.getCyNode(targetName);
                    edge = Cytoscape.getCyEdge(node_1, node_2, "interaction", label, true, true);
                }
            } else {
                throw new GMLException("Non-existant source/target node for edge with gml (source,target): " + this.sources.get(idx) + "," + this.targets.get(idx));
            }
            edge.setIdentifier(edgeName);
            edgeAttributes.setAttribute(edgeName, "interaction", label);
            this.giny_edges.add(edge.getRootGraphIndex());
            ((KeyValue)this.edge_root_index_pairs.get((int)idx)).value = new Integer(edge.getRootGraphIndex());
        }
        edgeNameSet = null;
    }

    protected void readGML(List list) {
        int counter = 0;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            if (this.taskMonitor != null) {
                this.taskMonitor.setPercentCompleted(this.percentUtil.getGlobalPercent(1, counter, list.size()));
                ++counter;
            }
            KeyValue keyVal = (KeyValue)it.next();
            if (!keyVal.key.equals(GRAPH)) continue;
            this.readGraph((List)keyVal.value);
        }
    }

    protected void readGraph(List list) {
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(NODE)) {
                this.readNode((List)keyVal.value);
            }
            if (!keyVal.key.equals(EDGE)) continue;
            this.readEdge((List)keyVal.value);
        }
    }

    protected void readNode(List list) {
        String label = "";
        boolean contains_id = false;
        int id = 0;
        KeyValue root_index_pair = null;
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(ID)) {
                contains_id = true;
                id = (Integer)keyVal.value;
                continue;
            }
            if (keyVal.key.equals(LABEL)) {
                label = (String)keyVal.value;
                continue;
            }
            if (!keyVal.key.equals(ROOT_INDEX)) continue;
            root_index_pair = keyVal;
        }
        if (label.equals("") || label.matches("\\s+")) {
            label = String.valueOf(id);
        }
        if (root_index_pair == null) {
            root_index_pair = new KeyValue(ROOT_INDEX, null);
            list.add(root_index_pair);
        }
        if (!contains_id) {
            StringWriter stringWriter = new StringWriter();
            try {
                GMLParser.printList(list, stringWriter);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            throw new GMLException("The node-associated list\n" + stringWriter + "is missing an id field");
        }
        this.node_root_index_pairs.add(root_index_pair);
        this.nodes.add(id);
        this.node_labels.add(label);
        this.node_names.add(label);
    }

    protected void readEdge(List list) {
        String label = DEFAULT_EDGE_INTERACTION;
        boolean contains_source = false;
        boolean contains_target = false;
        int source = 0;
        int target = 0;
        KeyValue root_index_pair = null;
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(SOURCE)) {
                contains_source = true;
                source = (Integer)keyVal.value;
                continue;
            }
            if (keyVal.key.equals(TARGET)) {
                contains_target = true;
                target = (Integer)keyVal.value;
                continue;
            }
            if (keyVal.key.equals(LABEL)) {
                label = (String)keyVal.value;
                continue;
            }
            if (!keyVal.key.equals(ROOT_INDEX)) continue;
            root_index_pair = keyVal;
        }
        if (root_index_pair == null) {
            root_index_pair = new KeyValue(ROOT_INDEX, null);
            list.add(root_index_pair);
        }
        if (!contains_source || !contains_target) {
            StringWriter stringWriter = new StringWriter();
            try {
                GMLParser.printList(list, stringWriter);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            throw new GMLException("The edge-associated list\n" + stringWriter + " is missing a source or target key");
        }
        this.sources.add(source);
        this.targets.add(target);
        this.edge_labels.add(label);
        this.edge_root_index_pairs.add(root_index_pair);
    }

    public void layout(GraphView myView) {
        if (myView == null || myView.nodeCount() == 0) {
            return;
        }
        if (this.keyVals == null) {
            throw new RuntimeException("Failed to read gml file on initialization");
        }
        for (KeyValue keyVal : this.keyVals) {
            if (!keyVal.key.equals(GRAPH)) continue;
            this.layoutGraph(myView, (List)keyVal.value);
        }
    }

    public void extract() {
        if (this.keyVals == null) {
            throw new RuntimeException("Failed to read gml file on initialization");
        }
        for (KeyValue keyVal : this.keyVals) {
            if (!keyVal.key.equals(GRAPH)) continue;
            this.extractGraph((List)keyVal.value);
        }
    }

    protected void extractGraph(List list) {
        String edgeName = null;
        int ePtr = 0;
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(NODE)) {
                this.extractNode((List)keyVal.value);
                continue;
            }
            if (!keyVal.key.equals(EDGE)) continue;
            edgeName = (String)this.edge_names.get(ePtr);
            ++ePtr;
            this.extractEdge((List)keyVal.value, edgeName);
        }
    }

    protected void extractNode(List list) {
        List graphics_list = null;
        String label = null;
        int tempid = 0;
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(ROOT_INDEX)) {
                if (keyVal.value != null) continue;
                return;
            }
            if (keyVal.key.equals(GRAPHICS)) {
                graphics_list = (List)keyVal.value;
                continue;
            }
            if (keyVal.key.equals(LABEL)) {
                label = (String)keyVal.value;
                continue;
            }
            if (!keyVal.key.equals(ID)) continue;
            tempid = (Integer)keyVal.value;
        }
        if (graphics_list != null) {
            if (label == null) {
                label = "node" + tempid;
                System.out.println("Warning: node label is missing for node ID: " + tempid);
            }
            this.extractNodeAttributes(graphics_list, label);
        }
    }

    protected void extractEdge(List list, String edgeName) {
        List graphics_list = null;
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(ROOT_INDEX)) {
                if (keyVal.value != null) continue;
                return;
            }
            if (!keyVal.key.equals(GRAPHICS)) continue;
            graphics_list = (List)keyVal.value;
        }
        if (graphics_list != null) {
            this.extractEdgeAttributes(graphics_list, edgeName);
        }
    }

    protected void layoutGraph(GraphView myView, List list) {
        String edgeName = null;
        int ePtr = 0;
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(NODE)) {
                this.layoutNode(myView, (List)keyVal.value);
                continue;
            }
            if (!keyVal.key.equals(EDGE)) continue;
            edgeName = (String)this.edge_names.get(ePtr);
            ++ePtr;
            this.layoutEdge(myView, (List)keyVal.value, edgeName);
        }
    }

    protected void layoutNode(GraphView myView, List list) {
        Integer root_index = null;
        List graphics_list = null;
        String label = null;
        int tempid = 0;
        NodeView view = null;
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(ROOT_INDEX)) {
                if (keyVal.value == null) {
                    return;
                }
                root_index = (Integer)keyVal.value;
                continue;
            }
            if (keyVal.key.equals(GRAPHICS)) {
                graphics_list = (List)keyVal.value;
                continue;
            }
            if (keyVal.key.equals(LABEL)) {
                label = (String)keyVal.value;
                continue;
            }
            if (!keyVal.key.equals(ID)) continue;
            tempid = (Integer)keyVal.value;
        }
        view = myView.getNodeView(root_index.intValue());
        if (label != null) {
            view.getLabel().setText(label);
        } else {
            view.getLabel().setText("node(" + tempid + ")");
        }
        if (graphics_list != null) {
            this.layoutNodeGraphics(myView, graphics_list, view);
        }
    }

    protected void layoutNodeGraphics(GraphView myView, List list, NodeView nodeView) {
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(X)) {
                nodeView.setXPosition(((Number)keyVal.value).doubleValue());
                continue;
            }
            if (keyVal.key.equals(Y)) {
                nodeView.setYPosition(((Number)keyVal.value).doubleValue());
                continue;
            }
            if (keyVal.key.equals(H)) {
                nodeView.setHeight(((Number)keyVal.value).doubleValue());
                continue;
            }
            if (keyVal.key.equals(W)) {
                nodeView.setWidth(((Number)keyVal.value).doubleValue());
                continue;
            }
            if (keyVal.key.equals(FILL)) {
                nodeView.setUnselectedPaint((Paint)this.getColor((String)keyVal.value));
                continue;
            }
            if (keyVal.key.equals(OUTLINE)) {
                nodeView.setBorderPaint((Paint)this.getColor((String)keyVal.value));
                continue;
            }
            if (keyVal.key.equals(OUTLINE_WIDTH)) {
                nodeView.setBorderWidth(((Number)keyVal.value).floatValue());
                continue;
            }
            if (!keyVal.key.equals(TYPE)) continue;
            String type = (String)keyVal.value;
            if (type.equals(ELLIPSE)) {
                nodeView.setShape(2);
                continue;
            }
            if (type.equals(RECTANGLE)) {
                nodeView.setShape(6);
                continue;
            }
            if (type.equals(DIAMOND)) {
                nodeView.setShape(1);
                continue;
            }
            if (type.equals(HEXAGON)) {
                nodeView.setShape(3);
                continue;
            }
            if (type.equals(OCTAGON)) {
                nodeView.setShape(4);
                continue;
            }
            if (type.equals(PARALELLOGRAM)) {
                nodeView.setShape(5);
                continue;
            }
            if (!type.equals(TRIANGLE)) continue;
            nodeView.setShape(0);
        }
    }

    protected void extractNodeAttributes(List list, String nodeName) {
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(X) || keyVal.key.equals(Y)) continue;
            if (keyVal.key.equals(H)) {
                this.nodeH.put(nodeName, keyVal.value);
                continue;
            }
            if (keyVal.key.equals(W)) {
                this.nodeW.put(nodeName, keyVal.value);
                continue;
            }
            if (keyVal.key.equals(FILL)) {
                this.nodeCol.put(nodeName, keyVal.value);
                continue;
            }
            if (keyVal.key.equals(OUTLINE)) {
                this.nodeBCol.put(nodeName, keyVal.value);
                continue;
            }
            if (keyVal.key.equals(OUTLINE_WIDTH)) {
                this.nodeBWidth.put(nodeName, keyVal.value);
                continue;
            }
            if (!keyVal.key.equals(TYPE)) continue;
            String type = (String)keyVal.value;
            if (type.equals(ELLIPSE)) {
                this.nodeShape.put(nodeName, new Byte(8));
                continue;
            }
            if (type.equals(RECTANGLE)) {
                this.nodeShape.put(nodeName, new Byte(0));
                continue;
            }
            if (type.equals(DIAMOND)) {
                this.nodeShape.put(nodeName, new Byte(7));
                continue;
            }
            if (type.equals(HEXAGON)) {
                this.nodeShape.put(nodeName, new Byte(9));
                continue;
            }
            if (type.equals(OCTAGON)) {
                this.nodeShape.put(nodeName, new Byte(10));
                continue;
            }
            if (type.equals(PARALELLOGRAM)) {
                this.nodeShape.put(nodeName, new Byte(6));
                continue;
            }
            if (!type.equals(TRIANGLE)) continue;
            this.nodeShape.put(nodeName, new Byte(5));
        }
    }

    protected void extractEdgeAttributes(List list, String edgeName) {
        String value = null;
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(LINE)) continue;
            if (keyVal.key.equals(WIDTH)) {
                this.edgeWidth.put(edgeName, (Number)keyVal.value);
                continue;
            }
            if (keyVal.key.equals(FILL)) {
                this.edgeCol.put(edgeName, (String)keyVal.value);
                continue;
            }
            if (keyVal.key.equals(ARROW)) {
                this.edgeArrow.put(edgeName, (String)keyVal.value);
                continue;
            }
            if (keyVal.key.equals(TYPE)) {
                value = (String)keyVal.value;
                if (value.equals(STRAIGHT_LINES)) {
                    this.edgeShape.put(edgeName, (String)keyVal.value);
                    continue;
                }
                if (!value.equals(CURVED_LINES)) continue;
                continue;
            }
            if (!keyVal.value.equals(SOURCE_ARROW) && !keyVal.value.equals(TARGET_ARROW)) continue;
        }
    }

    public static LineType getLineType(int width) {
        if (width == 1) {
            return LineType.LINE_1;
        }
        if (width == 2) {
            return LineType.LINE_2;
        }
        if (width == 3) {
            return LineType.LINE_3;
        }
        if (width == 4) {
            return LineType.LINE_4;
        }
        if (width == 5) {
            return LineType.LINE_5;
        }
        if (width == 6) {
            return LineType.LINE_6;
        }
        if (width == 7) {
            return LineType.LINE_7;
        }
        return LineType.LINE_1;
    }

    public void showMaps() {
        String e = null;
        Object n = null;
        String temp = null;
        for (int i = 0; i < this.edge_names.size(); ++i) {
            e = (String)this.edge_names.get(i);
            temp = e + ": ";
            temp = temp + this.edgeCol.get(e) + ", ";
            temp = temp + this.edgeWidth.get(e) + ", ";
            temp = temp + this.edgeArrow.get(e) + ", ";
            temp = temp + this.edgeShape.get(e) + ", ";
            System.out.println(temp);
            temp = null;
        }
    }

    protected void layoutEdge(GraphView myView, List list, String edgeName) {
        EdgeView edgeView = null;
        List graphics_list = null;
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(ROOT_INDEX)) {
                if (keyVal.value == null) {
                    return;
                }
                edgeView = myView.getEdgeView(((Integer)keyVal.value).intValue());
                continue;
            }
            if (!keyVal.key.equals(GRAPHICS)) continue;
            graphics_list = (List)keyVal.value;
        }
        if (edgeView != null && graphics_list != null) {
            this.layoutEdgeGraphics(myView, graphics_list, edgeView);
        }
    }

    protected void layoutEdgeGraphics(GraphView myView, List list, EdgeView edgeView) {
        String value = null;
        KeyValue keyVal2 = null;
        for (KeyValue keyVal2 : list) {
            if (keyVal2.key.equals(LINE)) {
                this.layoutEdgeGraphicsLine(myView, (List)keyVal2.value, edgeView);
                continue;
            }
            if (keyVal2.key.equals(WIDTH)) {
                edgeView.setStrokeWidth(((Number)keyVal2.value).floatValue());
                continue;
            }
            if (keyVal2.key.equals(FILL)) {
                edgeView.setUnselectedPaint((Paint)this.getColor((String)keyVal2.value));
                continue;
            }
            if (keyVal2.key.equals(TYPE)) {
                value = (String)keyVal2.value;
                if (value.equals(STRAIGHT_LINES)) {
                    edgeView.setLineType(2);
                    continue;
                }
                if (!value.equals(CURVED_LINES)) continue;
                edgeView.setLineType(1);
                continue;
            }
            if (!keyVal2.key.equals(ARROW)) continue;
            if (keyVal2.value.equals(ARROW_FIRST)) {
                edgeView.setSourceEdgeEnd(2);
            } else if (keyVal2.value.equals(ARROW_LAST)) {
                edgeView.setTargetEdgeEnd(2);
            } else if (keyVal2.value.equals(ARROW_BOTH)) {
                edgeView.setSourceEdgeEnd(2);
                edgeView.setTargetEdgeEnd(2);
            } else if (keyVal2.value.equals(ARROW_NONE)) {
                // empty if block
            }
            if (keyVal2.key.equals(SOURCE_ARROW)) {
                edgeView.setSourceEdgeEnd(((Number)keyVal2.value).intValue());
                continue;
            }
            if (!keyVal2.value.equals(TARGET_ARROW)) continue;
            edgeView.setTargetEdgeEnd(((Number)keyVal2.value).intValue());
        }
    }

    protected void layoutEdgeGraphicsLine(GraphView myView, List list, EdgeView edgeView) {
        for (KeyValue keyVal : list) {
            if (!keyVal.key.equals(POINT)) continue;
            Number x = null;
            Number y = null;
            for (KeyValue pointVal : (List)keyVal.value) {
                if (pointVal.key.equals(X)) {
                    x = (Number)pointVal.value;
                    continue;
                }
                if (!pointVal.key.equals(Y)) continue;
                y = (Number)pointVal.value;
            }
            if (x == null || y == null) continue;
            Point2D.Double pt = new Point2D.Double(x.doubleValue(), y.doubleValue());
            edgeView.getBend().addHandle((Point2D)pt);
        }
    }

    public int[] getNodeIndicesArray() {
        this.giny_nodes.trimToSize();
        return this.giny_nodes.elements();
    }

    public int[] getEdgeIndicesArray() {
        this.giny_edges.trimToSize();
        return this.giny_edges.elements();
    }

    public Color getColor(String colorString) {
        return new Color(Integer.parseInt(colorString.substring(1), 16));
    }

    public void doPostProcessing(CyNetwork net) {
        CyInitParams init = CytoscapeInit.getCyInitParams();
        if (init == null) {
            return;
        }
        if (init.getMode() == 1 || init.getMode() == 4) {
            VisualStyleBuilderDialog vsd = new VisualStyleBuilderDialog(net.getTitle(), (GraphReader)net.getClientData("reader_client_key"), Cytoscape.getDesktop(), true);
            vsd.setVisible(true);
        }
    }
}

