/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.freehep.graphicsio.swf.DefinitionTag;
import org.freehep.graphicsio.swf.End;
import org.freehep.graphicsio.swf.SWFActionSet;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFSpriteTagSet;
import org.freehep.graphicsio.swf.SWFTag;

public class DefineSprite
extends DefinitionTag {
    private int character;
    private int frameCount;
    private Vector tags;

    public DefineSprite(int id, int frameCount, Vector tags) {
        this();
        this.character = id;
        this.frameCount = frameCount;
        this.tags = tags;
    }

    public DefineSprite() {
        super(39, 3);
    }

    public SWFTag read(int tagID, SWFInputStream swf, int len) throws IOException {
        SWFTag miniTag;
        DefineSprite tag = new DefineSprite();
        tag.character = swf.readUnsignedShort();
        swf.getDictionary().put(tag.character, tag);
        tag.frameCount = swf.readUnsignedShort();
        int version = swf.getVersion();
        SWFInputStream sprite = new SWFInputStream((InputStream)swf, new SWFSpriteTagSet(version), new SWFActionSet(version));
        tag.tags = new Vector();
        do {
            miniTag = (SWFTag)sprite.readTag();
            tag.tags.add(miniTag);
        } while (!(miniTag instanceof End));
        return tag;
    }

    public void write(int tagID, SWFOutputStream swf) throws IOException {
        swf.writeUnsignedShort(this.character);
        swf.writeUnsignedShort(this.frameCount);
        for (int i = 0; i < this.tags.size(); ++i) {
            swf.writeTag((SWFTag)this.tags.get(i));
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(super.toString() + "\n");
        s.append("  character:  " + this.character + "\n");
        s.append("  frameCount: " + this.frameCount + "\n");
        s.append("  tags:       " + this.tags.size() + "\n");
        return s.toString();
    }
}

