/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.zip.InflaterInputStream;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.raw.RawImageWriteParam;
import org.freehep.graphicsio.swf.DefinitionTag;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFTag;
import org.freehep.util.UserProperties;
import org.freehep.util.images.ImageUtilities;
import org.freehep.util.io.ByteOrderInputStream;
import org.freehep.util.io.FlateOutputStream;

public class DefineBitsLossless
extends DefinitionTag {
    protected int character;
    protected RenderedImage image;
    protected Color bkg;
    private byte[] imageBytes;

    public DefineBitsLossless(int id, Image image, Color bkg, ImageObserver observer) {
        this(id, ImageUtilities.createRenderedImage(image, observer, bkg), bkg);
    }

    public DefineBitsLossless(int id, RenderedImage image, Color bkg) {
        this();
        this.character = id;
        this.image = image;
        this.bkg = bkg;
    }

    public DefineBitsLossless() {
        super(20, 2);
    }

    protected DefineBitsLossless(int tagID, int version) {
        super(tagID, version);
    }

    public SWFTag read(int tagID, SWFInputStream swf, int len) throws IOException {
        DefineBitsLossless tag = new DefineBitsLossless();
        tag.read(tagID, swf, len, false);
        return tag;
    }

    protected void read(int tagID, SWFInputStream swf, int len, boolean hasAlpha) throws IOException {
        this.character = swf.readUnsignedShort();
        swf.getDictionary().put(this.character, this);
        int format = swf.readUnsignedByte();
        int width = swf.readUnsignedShort();
        int height = swf.readUnsignedShort();
        int colorTableSize = format == 3 ? swf.readUnsignedByte() + 1 : 0;
        InflaterInputStream zip = new InflaterInputStream(swf);
        ByteOrderInputStream bois = new ByteOrderInputStream(zip, true);
        int[][] colors = new int[colorTableSize][hasAlpha ? 4 : 3];
        for (int i = 0; i < colorTableSize; ++i) {
            colors[i][0] = zip.read();
            colors[i][1] = zip.read();
            colors[i][2] = zip.read();
            if (!hasAlpha) continue;
            colors[i][3] = zip.read();
        }
        BufferedImage bi = new BufferedImage(width, height, hasAlpha ? 2 : 1);
        WritableRaster raster = bi.getRaster();
        int[] rgba = new int[hasAlpha ? 4 : 3];
        for (int y = 0; y < height; ++y) {
            block7: for (int x = 0; x < width; ++x) {
                switch (format) {
                    default: {
                        System.out.println("ERROR: unknown format in LossLess image: " + format);
                        return;
                    }
                    case 3: {
                        raster.setPixel(x, y, colors[bois.readUnsignedByte()]);
                        continue block7;
                    }
                    case 4: {
                        if (hasAlpha) {
                            System.out.println("ERROR: unknown format in LossLess2 image: 4");
                            return;
                        }
                        bois.readUBits(1);
                        rgba[0] = (int)bois.readUBits(5);
                        rgba[1] = (int)bois.readUBits(5);
                        rgba[2] = (int)bois.readUBits(5);
                        raster.setPixel(x, y, rgba);
                        continue block7;
                    }
                    case 5: {
                        if (hasAlpha) {
                            rgba[3] = bois.readUnsignedByte();
                        } else {
                            bois.readUnsignedByte();
                        }
                        rgba[0] = bois.readUnsignedByte();
                        rgba[1] = bois.readUnsignedByte();
                        rgba[2] = bois.readUnsignedByte();
                        raster.setPixel(x, y, rgba);
                    }
                }
            }
        }
        this.image = bi;
    }

    public void write(int tagID, SWFOutputStream swf) throws IOException {
        this.write(tagID, swf, false);
    }

    protected void write(int tagID, SWFOutputStream swf, boolean hasAlpha) throws IOException {
        swf.writeUnsignedShort(this.character);
        swf.writeUnsignedByte(5);
        swf.writeUnsignedShort(this.image.getWidth());
        swf.writeUnsignedShort(this.image.getHeight());
        swf.write(this.getImageBytes());
    }

    public int getLength() throws IOException {
        return this.getImageBytes().length + 7;
    }

    private byte[] getImageBytes() throws IOException {
        if (this.imageBytes == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FlateOutputStream flate = new FlateOutputStream(baos);
            UserProperties props = new UserProperties();
            props.setProperty(RawImageWriteParam.BACKGROUND, this.bkg);
            props.setProperty(RawImageWriteParam.CODE, "*ARGB");
            props.setProperty(RawImageWriteParam.PAD, 1);
            ImageGraphics2D.writeImage(this.image, "raw", (Properties)props, (OutputStream)flate);
            flate.close();
            this.imageBytes = baos.toByteArray();
        }
        return this.imageBytes;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(super.toString() + "\n");
        s.append("  character:  " + this.character);
        s.append("  image: " + this.image);
        return s.toString();
    }
}

