/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain.sequencelogo;

import java.util.Iterator;
import java.util.List;
import org.baderlab.brain.sequencelogo.SequenceLogoDistributionTrainerContext;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Symbol;

public class SequenceLogoDistributionTools {
    public static final Distribution[] distOverAlignment(Alignment a, boolean countGaps, double nullWeight) throws IllegalAlphabetException {
        List seqs = a.getLabels();
        FiniteAlphabet alpha = (FiniteAlphabet)a.symbolListForLabel(seqs.get(0)).getAlphabet();
        int i = 1;
        while (i < seqs.size()) {
            FiniteAlphabet test = (FiniteAlphabet)a.symbolListForLabel(seqs.get(i)).getAlphabet();
            if (test != alpha) {
                throw new IllegalAlphabetException("Cannot Calculate distOverAlignment() for alignments withmixed alphabets");
            }
            ++i;
        }
        Distribution[] pos = new Distribution[a.length()];
        SequenceLogoDistributionTrainerContext dtc = new SequenceLogoDistributionTrainerContext();
        dtc.setNullModelWeight(nullWeight);
        double[] adjRatios = null;
        if (countGaps) {
            adjRatios = new double[a.length()];
        }
        try {
            int i2 = 0;
            while (i2 < a.length()) {
                double gapCount = 0.0;
                double totalCount = 0.0;
                pos[i2] = DistributionFactory.DEFAULT.createDistribution(alpha);
                dtc.registerDistribution(pos[i2]);
                for (Object seqLabel : seqs) {
                    Symbol s = a.symbolAt(seqLabel, i2 + 1);
                    if (s == null) continue;
                    Symbol gap = alpha.getGapSymbol();
                    if (countGaps && s.equals(gap)) {
                        gapCount += 1.0;
                        totalCount += 1.0;
                        continue;
                    }
                    dtc.addCount(pos[i2], s, 1.0);
                    totalCount += 1.0;
                }
                if (countGaps) {
                    adjRatios[i2] = 1.0 - gapCount / totalCount;
                }
                ++i2;
            }
            dtc.train();
            if (countGaps) {
                i2 = 0;
                while (i2 < adjRatios.length) {
                    Distribution d = pos[i2];
                    Iterator iter = ((FiniteAlphabet)d.getAlphabet()).iterator();
                    while (iter.hasNext()) {
                        Symbol sym = (Symbol)iter.next();
                        d.setWeight(sym, d.getWeight(sym) * adjRatios[i2]);
                    }
                    ++i2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return pos;
    }
}

