/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import mt.MatrixEntry;
import org.baderlab.brain.PeptideToProfileReader;
import org.baderlab.brain.ProteinProfile;
import org.baderlab.brain.ProteinSequenceLogo;
import org.baderlab.brain.ProteinSequenceUtil;
import org.baderlab.brain.ProteinTerminus;
import org.biojava.bio.BioException;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionTools;
import org.biojava.bio.dist.IndexedCount;
import org.biojava.bio.dp.SimpleWeightMatrix;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.io.SeqIOTools;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;
import smt.FlexCompRowMatrix;
import smt.SparseVector;

public class ResidueResidueCorrelationMatrix {
    private FlexCompRowMatrix correlationMatrix = null;
    private int totalDomainSequenceLength = -1;
    private int totalPeptideSequenceLength = -1;
    private HashMap profileNameToProfile = null;
    private HashMap sequenceNameToSequence = null;
    private boolean domainPositionsAsRows = false;
    private int numDomainPositionsPerFeature = 0;
    private int numPeptidePositionsPerFeature = 0;
    private int multipleSequenceAlignmentLength = 0;
    private SparseVector domainFeatureFrequencyVector = null;
    private SparseVector peptideFeatureFrequencyVector = null;
    private String domainSequenceFilter = null;
    private String peptideSequenceFilter = null;
    private final String aaList = "ACDEFGHIKLMNPQRSTVWY";

    public ResidueResidueCorrelationMatrix(File multipleSequenceAlignmentFile, File peptideOrProjectFile, int peptideLength, ProteinTerminus terminus) throws BioException, IOException {
        List proteinProfileList = null;
        this.readAlignmentAndDetermineSequenceAlignmentWidth(multipleSequenceAlignmentFile);
        proteinProfileList = PeptideToProfileReader.readPeptidesAsProfiles(peptideOrProjectFile, peptideLength, terminus, 0.0, null, true, false);
        this.profileNameToProfile = new HashMap();
        this.multipleSequenceAlignmentLength = 0;
        int i = 0;
        while (i < proteinProfileList.size()) {
            ProteinProfile proteinProfile = (ProteinProfile)proteinProfileList.get(i);
            if (this.totalPeptideSequenceLength < 0) {
                this.totalPeptideSequenceLength = proteinProfile.getNumColumns();
            } else if (this.totalPeptideSequenceLength != proteinProfile.getNumColumns()) {
                throw new IllegalArgumentException("All peptide sequences must be the same length across all files.Found a profile of length " + proteinProfile.getNumColumns() + " in " + proteinProfile.getName() + " but was expecting length " + this.totalPeptideSequenceLength + " (based on the length of the" + " first sequence seen).");
            }
            this.profileNameToProfile.put(proteinProfile.getName(), proteinProfile);
            this.multipleSequenceAlignmentLength += proteinProfile.getNumSequences();
            ++i;
        }
    }

    private void readAlignmentAndDetermineSequenceAlignmentWidth(File multipleSequenceAlignmentFile) throws IOException, BioException {
        this.sequenceNameToSequence = new HashMap();
        BufferedReader brMSA = new BufferedReader(new FileReader(multipleSequenceAlignmentFile));
        SequenceIterator sequenceAlignment = (SequenceIterator)SeqIOTools.fileToBiojava("fasta", "PROTEIN", brMSA);
        while (sequenceAlignment.hasNext()) {
            Sequence seq = sequenceAlignment.nextSequence();
            if (this.totalDomainSequenceLength < 0) {
                this.totalDomainSequenceLength = seq.length();
            } else if (this.totalDomainSequenceLength != seq.length()) {
                throw new IllegalArgumentException("All domain sequences must be the same length.Found a domain sequence of length " + seq.length() + " called " + seq.getName() + " but was expecting length " + this.totalDomainSequenceLength + " (based on the length of the" + " first sequence seen).");
            }
            this.sequenceNameToSequence.put(seq.getName(), seq);
        }
        brMSA.close();
    }

    private int getCombinations(int n, int k) {
        if (k == 1) {
            return n;
        }
        int k1 = k;
        int k2 = n - k;
        if (k1 < k2) {
            k1 = n - k;
            k2 = k;
        }
        int t = 0;
        if (k1 > n) {
            return t;
        }
        t = 1;
        while (k2 > 1) {
            t *= k2--;
        }
        int t2 = 1;
        while (n > k1) {
            t2 *= n--;
        }
        t = t2 / t;
        return t;
    }

    private int getMaxIndex(int numberOfPositions, int totalPositions) {
        int maxIndex = 0;
        maxIndex = this.getCombinations(totalPositions, numberOfPositions);
        maxIndex = (int)((double)maxIndex * Math.pow(20.0, numberOfPositions));
        return maxIndex;
    }

    private int getFeatureIndex(ResiduePositionPair[] feature) {
        int index = 0;
        int partitionNumber = 0;
        int partitionOffset = 0;
        int residueOffset = 0;
        int i = 0;
        while (i < feature.length) {
            partitionNumber += this.getCombinations(feature[i].position, i + 1);
            ++i;
        }
        partitionOffset = partitionNumber * (int)Math.pow("ACDEFGHIKLMNPQRSTVWY".length(), feature.length);
        i = 0;
        while (i < feature.length) {
            residueOffset = (int)((double)residueOffset + (double)"ACDEFGHIKLMNPQRSTVWY".indexOf(feature[i].residue) * Math.pow("ACDEFGHIKLMNPQRSTVWY".length(), i));
            ++i;
        }
        index = partitionOffset + residueOffset;
        return index;
    }

    private ResiduePositionPair[] indexToFeature(int index, ResiduePositionPair[] feature, int sequenceLength) {
        int i;
        int partitionNumber = 0;
        int partitionOffset = 0;
        int tempPartitionNumber = partitionNumber = (int)Math.floor((double)index / Math.pow("ACDEFGHIKLMNPQRSTVWY".length(), feature.length));
        int featurePosition = feature.length;
        while (featurePosition > 0) {
            i = featurePosition - 1;
            while (i < sequenceLength) {
                if (tempPartitionNumber < this.getCombinations(i + 1, featurePosition)) {
                    feature[featurePosition - 1].position = i;
                    tempPartitionNumber -= this.getCombinations(i, featurePosition);
                    break;
                }
                ++i;
            }
            --featurePosition;
        }
        partitionOffset = partitionNumber * (int)Math.pow("ACDEFGHIKLMNPQRSTVWY".length(), feature.length);
        int residueOffset = index - partitionOffset;
        i = feature.length - 1;
        while (i >= 0) {
            feature[i].residue = "ACDEFGHIKLMNPQRSTVWY".charAt(residueOffset / (int)Math.pow("ACDEFGHIKLMNPQRSTVWY".length(), i));
            residueOffset %= (int)Math.pow("ACDEFGHIKLMNPQRSTVWY".length(), i);
            --i;
        }
        return feature;
    }

    private int learnSequenceToPeptides(Sequence domainSequence, ProteinProfile bindingPeptides, int numDomainPositionsPerFeature, int numPeptidePositionsPerFeature) {
        int correlationCounts = 0;
        String domainSequenceString = null;
        domainSequenceString = this.domainSequenceFilter == null ? domainSequence.seqString() : ProteinSequenceUtil.filterSequenceByColumns(domainSequence, this.domainSequenceFilter);
        Collection peptides = bindingPeptides.getSequenceMap();
        String peptideSequenceString = null;
        for (Sequence peptideSequence : peptides) {
            peptideSequenceString = this.peptideSequenceFilter == null ? peptideSequence.seqString() : ProteinSequenceUtil.filterSequenceByColumns(peptideSequence, this.peptideSequenceFilter);
            correlationCounts += this.learnSequenceToPeptide(domainSequenceString, peptideSequenceString, numDomainPositionsPerFeature, numPeptidePositionsPerFeature);
        }
        return correlationCounts;
    }

    private int[] generateFeaturePositions(int[] positionArray, int totalPositions, boolean initialize) {
        if (!initialize) {
            int i = positionArray.length - 1;
            while (i >= 0) {
                if (positionArray[i] < totalPositions - (positionArray.length - i)) {
                    int n = i;
                    positionArray[n] = positionArray[n] + 1;
                    int j = i + 1;
                    while (j < positionArray.length) {
                        positionArray[j] = positionArray[j - 1] + 1;
                        ++j;
                    }
                    break;
                }
                --i;
            }
        } else {
            int i = 0;
            while (i < positionArray.length) {
                positionArray[i] = i;
                ++i;
            }
        }
        return positionArray;
    }

    private int learnSequenceToPeptide(String domainSequenceString, String peptideSequenceString, int numDomainPositionsPerFeature, int numPeptidePositionsPerFeature) {
        int numberOfDomainFeatures = this.getCombinations(this.totalDomainSequenceLength, numDomainPositionsPerFeature);
        int[] domainPositionArray = new int[numDomainPositionsPerFeature];
        boolean initializeDomain = true;
        ResiduePositionPair[] domainFeature = this.allocateFeature(numDomainPositionsPerFeature);
        int numberOfPeptideFeatures = this.getCombinations(this.totalPeptideSequenceLength, numPeptidePositionsPerFeature);
        int[] peptidePositionArray = new int[numPeptidePositionsPerFeature];
        boolean initializePeptide = true;
        ResiduePositionPair[] peptideFeature = this.allocateFeature(numPeptidePositionsPerFeature);
        int correlationCounts = 0;
        int i = 0;
        while (i < numberOfDomainFeatures) {
            domainPositionArray = this.generateFeaturePositions(domainPositionArray, domainSequenceString.length(), initializeDomain);
            if (initializeDomain) {
                initializeDomain = false;
            }
            if (this.featureValid(domainFeature = this.createFeature(domainFeature, domainPositionArray, domainSequenceString))) {
                int j = 0;
                while (j < numberOfPeptideFeatures) {
                    peptidePositionArray = this.generateFeaturePositions(peptidePositionArray, peptideSequenceString.length(), initializePeptide);
                    if (initializePeptide) {
                        initializePeptide = false;
                    }
                    if (this.featureValid(peptideFeature = this.createFeature(peptideFeature, peptidePositionArray, peptideSequenceString))) {
                        this.addCorrelationCount(domainFeature, peptideFeature);
                        ++correlationCounts;
                    }
                    ++j;
                }
                initializePeptide = true;
            }
            ++i;
        }
        return correlationCounts;
    }

    private boolean featureValid(ResiduePositionPair[] feature) {
        int i = 0;
        while (i < feature.length) {
            ResiduePositionPair residuePositionPair = feature[i];
            if ("ACDEFGHIKLMNPQRSTVWY".indexOf(residuePositionPair.residue) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private ResiduePositionPair[] allocateFeature(int numPositionsPerFeature) {
        ResiduePositionPair[] feature = new ResiduePositionPair[numPositionsPerFeature];
        int i = 0;
        while (i < feature.length) {
            feature[i] = new ResiduePositionPair(-1, 'X');
            ++i;
        }
        return feature;
    }

    private void addCorrelationCount(ResiduePositionPair[] domainFeature, ResiduePositionPair[] peptideFeature) {
        int domainIndex = this.getFeatureIndex(domainFeature);
        int peptideIndex = this.getFeatureIndex(peptideFeature);
        if (this.domainPositionsAsRows) {
            this.correlationMatrix.add(domainIndex, peptideIndex, 1.0);
        } else {
            this.correlationMatrix.add(peptideIndex, domainIndex, 1.0);
        }
    }

    private ResiduePositionPair[] createFeature(ResiduePositionPair[] feature, int[] positionArray, String sequenceString) {
        int i = 0;
        while (i < feature.length) {
            ResiduePositionPair residuePositionPair = feature[i];
            residuePositionPair.position = positionArray[i];
            residuePositionPair.residue = sequenceString.charAt(positionArray[i]);
            ++i;
        }
        return feature;
    }

    public long learn(int numDomainPositionsPerFeature, int numPeptidePositionsPerFeature) throws BioException {
        int maxPeptideIndex;
        long numberCorrelationCounts = 0L;
        this.numDomainPositionsPerFeature = numDomainPositionsPerFeature;
        this.numPeptidePositionsPerFeature = numPeptidePositionsPerFeature;
        if (this.domainSequenceFilter != null) {
            this.totalDomainSequenceLength = ProteinSequenceUtil.countLengthOfFilteredStringResult(this.domainSequenceFilter);
        }
        if (this.peptideSequenceFilter != null) {
            this.totalPeptideSequenceLength = ProteinSequenceUtil.countLengthOfFilteredStringResult(this.peptideSequenceFilter);
        }
        int numRows = 0;
        int numColumns = 0;
        int maxDomainIndex = this.getMaxIndex(numDomainPositionsPerFeature, this.totalDomainSequenceLength);
        if (maxDomainIndex > (maxPeptideIndex = this.getMaxIndex(numPeptidePositionsPerFeature, this.totalPeptideSequenceLength))) {
            this.domainPositionsAsRows = false;
            numRows = maxPeptideIndex;
            numColumns = maxDomainIndex;
        } else {
            this.domainPositionsAsRows = true;
            numRows = maxDomainIndex;
            numColumns = maxPeptideIndex;
        }
        this.correlationMatrix = new FlexCompRowMatrix(numRows, numColumns);
        long start = System.currentTimeMillis();
        Collection profiles = this.profileNameToProfile.values();
        for (ProteinProfile proteinProfile : profiles) {
            if (this.sequenceNameToSequence.containsKey(proteinProfile.getName())) {
                numberCorrelationCounts += (long)this.learnSequenceToPeptides((Sequence)this.sequenceNameToSequence.get(proteinProfile.getName()), proteinProfile, numDomainPositionsPerFeature, numPeptidePositionsPerFeature);
                continue;
            }
            System.out.println("No aligned sequence was found for profile: " + proteinProfile.getName());
        }
        this.calculateDomainMSAFrequencies(numDomainPositionsPerFeature);
        this.calculatePeptideMSAFrequencies(numPeptidePositionsPerFeature);
        long end = System.currentTimeMillis();
        System.out.println(String.valueOf(numberCorrelationCounts) + " correlations counted in " + (end - start) / 1000L + " seconds.");
        return numberCorrelationCounts;
    }

    private void addFrequencyCount(ResiduePositionPair[] feature, SparseVector frequencyVector, double count) {
        frequencyVector.add(this.getFeatureIndex(feature), count);
    }

    private double getFrequencyCount(ResiduePositionPair[] feature, SparseVector frequencyVector) {
        return frequencyVector.get(this.getFeatureIndex(feature));
    }

    private void calculateDomainMSAFrequencies(int numDomainPositionsPerFeature) {
        int numberOfDomainFeatures = this.getCombinations(this.totalDomainSequenceLength, numDomainPositionsPerFeature);
        int[] domainPositionArray = new int[numDomainPositionsPerFeature];
        boolean initializeDomain = true;
        ResiduePositionPair[] domainFeature = this.allocateFeature(numDomainPositionsPerFeature);
        this.domainFeatureFrequencyVector = new SparseVector(this.getMaxIndex(numDomainPositionsPerFeature, this.totalDomainSequenceLength));
        Collection alignedSequences = this.sequenceNameToSequence.values();
        for (Sequence domainSequence : alignedSequences) {
            if (!this.profileNameToProfile.containsKey(domainSequence.getName())) continue;
            String domainSequenceString = null;
            domainSequenceString = this.domainSequenceFilter == null ? domainSequence.seqString() : ProteinSequenceUtil.filterSequenceByColumns(domainSequence, this.domainSequenceFilter);
            initializeDomain = true;
            ProteinProfile domainProfile = (ProteinProfile)this.profileNameToProfile.get(domainSequence.getName());
            int i = 0;
            while (i < numberOfDomainFeatures) {
                domainPositionArray = this.generateFeaturePositions(domainPositionArray, domainSequenceString.length(), initializeDomain);
                if (initializeDomain) {
                    initializeDomain = false;
                }
                if (this.featureValid(domainFeature = this.createFeature(domainFeature, domainPositionArray, domainSequenceString))) {
                    this.addFrequencyCount(domainFeature, this.domainFeatureFrequencyVector, domainProfile.getNumSequences());
                }
                ++i;
            }
        }
    }

    private void calculatePeptideMSAFrequencies(int numPeptidePositionsPerFeature) {
        int numberOfPeptideFeatures = this.getCombinations(this.totalPeptideSequenceLength, numPeptidePositionsPerFeature);
        int[] peptidePositionArray = new int[numPeptidePositionsPerFeature];
        boolean initializePeptide = true;
        ResiduePositionPair[] peptideFeature = this.allocateFeature(numPeptidePositionsPerFeature);
        this.peptideFeatureFrequencyVector = new SparseVector(this.getMaxIndex(numPeptidePositionsPerFeature, this.totalPeptideSequenceLength));
        Collection proteinProfileList = this.profileNameToProfile.values();
        for (ProteinProfile proteinProfile : proteinProfileList) {
            Collection peptides = proteinProfile.getSequenceMap();
            for (Sequence peptideSequence : peptides) {
                String peptideSequenceString = null;
                peptideSequenceString = this.peptideSequenceFilter == null ? peptideSequence.seqString() : ProteinSequenceUtil.filterSequenceByColumns(peptideSequence, this.peptideSequenceFilter);
                int j = 0;
                while (j < numberOfPeptideFeatures) {
                    peptidePositionArray = this.generateFeaturePositions(peptidePositionArray, peptideSequenceString.length(), initializePeptide);
                    if (initializePeptide) {
                        initializePeptide = false;
                    }
                    if (this.featureValid(peptideFeature = this.createFeature(peptideFeature, peptidePositionArray, peptideSequenceString))) {
                        this.addFrequencyCount(peptideFeature, this.peptideFeatureFrequencyVector, 1.0);
                    }
                    ++j;
                }
                initializePeptide = true;
            }
        }
    }

    private TreeMap getMostInformativeFeatures(double scoreThreshold) {
        TreeMap sortedResultMap = new TreeMap();
        Iterator iterator = this.correlationMatrix.iterator();
        double domainFrequency = 0.0;
        double peptideFrequency = 0.0;
        double score = 0.0;
        ResiduePositionPair[] domainFeature = this.allocateFeature(this.numDomainPositionsPerFeature);
        ResiduePositionPair[] peptideFeature = this.allocateFeature(this.numPeptidePositionsPerFeature);
        while (iterator.hasNext()) {
            MatrixEntry matrixEntry = (MatrixEntry)iterator.next();
            domainFeature = this.getDomainFeatureFromSparseMatrixEntry(matrixEntry, domainFeature);
            peptideFeature = this.getPeptideFeatureFromSparseMatrixEntry(matrixEntry, peptideFeature);
            domainFrequency = this.getFrequencyCount(domainFeature, this.domainFeatureFrequencyVector);
            score = this.scoreFeature(matrixEntry, domainFrequency, peptideFrequency = this.getFrequencyCount(peptideFeature, this.peptideFeatureFrequencyVector));
            if (!(score < scoreThreshold)) continue;
            this.addResultToSortedResultMap(score, matrixEntry, sortedResultMap);
        }
        return sortedResultMap;
    }

    public void printMostInformativeFeatures(String chosenSequenceName, double scoreThreshold) {
        ResiduePositionPair[] domainFeature = this.allocateFeature(this.numDomainPositionsPerFeature);
        ResiduePositionPair[] peptideFeature = this.allocateFeature(this.numPeptidePositionsPerFeature);
        TreeMap sortedResultMap = this.getMostInformativeFeatures(scoreThreshold);
        System.out.println("Features better than score " + scoreThreshold + " (lower is better) shown with " + chosenSequenceName);
        System.out.println("Total domain length: " + this.totalDomainSequenceLength);
        System.out.println("Total peptide length: " + this.totalPeptideSequenceLength);
        Set scores = sortedResultMap.keySet();
        for (Double score : scores) {
            ArrayList resultList = (ArrayList)sortedResultMap.get(score);
            int i = 0;
            while (i < resultList.size()) {
                CorrelationResult correlationResult = (CorrelationResult)resultList.get(i);
                this.printResult(correlationResult, chosenSequenceName, domainFeature, peptideFeature, score);
                ++i;
            }
        }
    }

    private void printResult(CorrelationResult correlationResult, String chosenSequenceName, ResiduePositionPair[] domainFeature, ResiduePositionPair[] peptideFeature, Double score) {
        domainFeature = this.indexToFeature(correlationResult.domainFeature, domainFeature, this.totalDomainSequenceLength);
        peptideFeature = this.indexToFeature(correlationResult.peptideFeature, peptideFeature, this.totalPeptideSequenceLength);
        int domainFrequency = (int)this.getFrequencyCount(domainFeature, this.domainFeatureFrequencyVector);
        int peptideFrequency = (int)this.getFrequencyCount(peptideFeature, this.peptideFeatureFrequencyVector);
        System.out.println(String.valueOf(this.featureToString(domainFeature)) + " " + this.featureToString(peptideFeature) + " " + score + " (" + correlationResult.correlationCount + "," + domainFrequency + "," + peptideFrequency + ")");
        Sequence chosenSequence = (Sequence)this.sequenceNameToSequence.get(chosenSequenceName);
        String sequenceString = chosenSequence.seqString();
        StringBuffer sb = new StringBuffer(sequenceString);
        int i = domainFeature.length - 1;
        while (i >= 0) {
            ResiduePositionPair residuePositionPair = domainFeature[i];
            sb.replace(residuePositionPair.position, residuePositionPair.position + 1, "[" + sequenceString.charAt(residuePositionPair.position) + "]");
            --i;
        }
        System.out.println(sb);
        boolean printedAResidue = false;
        int i2 = 0;
        while (i2 < this.totalPeptideSequenceLength) {
            int j = 0;
            while (j < peptideFeature.length) {
                ResiduePositionPair residuePositionPair = peptideFeature[j];
                if (residuePositionPair.position == i2) {
                    System.out.print(residuePositionPair.residue);
                    printedAResidue = true;
                    break;
                }
                ++j;
            }
            if (!printedAResidue) {
                System.out.print("-");
            } else {
                printedAResidue = false;
            }
            ++i2;
        }
        System.out.print("\n");
    }

    private void addResultToSortedResultMap(double score, MatrixEntry matrixEntry, TreeMap sortedResultMap) {
        Double scoreDouble = new Double(score);
        ArrayList resultList = null;
        resultList = !sortedResultMap.containsKey(scoreDouble) ? new ArrayList() : (ArrayList)sortedResultMap.get(scoreDouble);
        CorrelationResult result = null;
        result = this.domainPositionsAsRows ? new CorrelationResult(matrixEntry.row(), matrixEntry.column(), (int)matrixEntry.get()) : new CorrelationResult(matrixEntry.column(), matrixEntry.row(), (int)matrixEntry.get());
        resultList.add(result);
        sortedResultMap.put(scoreDouble, resultList);
    }

    private ResiduePositionPair[] getDomainFeatureFromSparseMatrixEntry(MatrixEntry matrixEntry, ResiduePositionPair[] preAllocatedDomainFeature) {
        int columnIndex = 0;
        int rowIndex = 0;
        ResiduePositionPair[] domainFeature = null;
        columnIndex = matrixEntry.column();
        rowIndex = matrixEntry.row();
        domainFeature = this.domainPositionsAsRows ? this.indexToFeature(rowIndex, preAllocatedDomainFeature, this.totalDomainSequenceLength) : this.indexToFeature(columnIndex, preAllocatedDomainFeature, this.totalDomainSequenceLength);
        return domainFeature;
    }

    private ResiduePositionPair[] getPeptideFeatureFromSparseMatrixEntry(MatrixEntry matrixEntry, ResiduePositionPair[] preAllocatedPeptideFeature) {
        int columnIndex = 0;
        int rowIndex = 0;
        ResiduePositionPair[] peptideFeature = null;
        columnIndex = matrixEntry.column();
        rowIndex = matrixEntry.row();
        peptideFeature = this.domainPositionsAsRows ? this.indexToFeature(columnIndex, preAllocatedPeptideFeature, this.totalPeptideSequenceLength) : this.indexToFeature(rowIndex, preAllocatedPeptideFeature, this.totalPeptideSequenceLength);
        return peptideFeature;
    }

    private double scoreFeature(MatrixEntry matrixEntry, double domainFrequency, double peptideFrequency) {
        double conditionalEntropy = -Math.log(matrixEntry.get() * (double)this.multipleSequenceAlignmentLength / (domainFrequency * peptideFrequency)) * (matrixEntry.get() / (double)this.multipleSequenceAlignmentLength);
        return conditionalEntropy;
    }

    public ProteinProfile predictProfileFromSequence(Sequence alignedDomainSequence) {
        ProteinProfile proteinProfile = null;
        String seqString = alignedDomainSequence.seqString();
        double domainFrequency = 0.0;
        double peptideFrequency = 0.0;
        double conditionalEntropy = 0.0;
        Distribution currentDist = null;
        HashMap alphabetMap = ProteinSequenceUtil.get20aaAlphabet();
        Symbol residue = null;
        Distribution[] weightMatrixColumns = null;
        SimpleWeightMatrix weightMatrix = null;
        weightMatrixColumns = new Distribution[this.totalPeptideSequenceLength];
        IndexedCount c = new IndexedCount(ProteinTools.getAlphabet());
        int i = 0;
        while (i < weightMatrixColumns.length) {
            weightMatrixColumns[i] = DistributionTools.countToDistribution(c);
            FiniteAlphabet fa = ProteinTools.getAlphabet();
            Iterator symbols = fa.iterator();
            while (symbols.hasNext()) {
                Symbol symbol = (Symbol)symbols.next();
                try {
                    weightMatrixColumns[i].setWeight(symbol, 1.0E-10);
                }
                catch (IllegalSymbolException e) {
                    e.printStackTrace();
                }
                catch (ChangeVetoException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        Iterator iterator = this.correlationMatrix.iterator();
        ResiduePositionPair[] domainFeature = this.allocateFeature(this.numDomainPositionsPerFeature);
        ResiduePositionPair[] peptideFeature = this.allocateFeature(this.numPeptidePositionsPerFeature);
        while (iterator.hasNext()) {
            MatrixEntry matrixEntry = (MatrixEntry)iterator.next();
            domainFeature = this.getDomainFeatureFromSparseMatrixEntry(matrixEntry, domainFeature);
            peptideFeature = this.getPeptideFeatureFromSparseMatrixEntry(matrixEntry, peptideFeature);
            if (!this.isFeatureInSequence(domainFeature, seqString) || !((conditionalEntropy = this.scoreFeature(matrixEntry, domainFrequency = this.getFrequencyCount(domainFeature, this.domainFeatureFrequencyVector), peptideFrequency = this.getFrequencyCount(peptideFeature, this.peptideFeatureFrequencyVector))) < -0.03)) continue;
            int i2 = 0;
            while (i2 < peptideFeature.length) {
                ResiduePositionPair residuePositionPair = peptideFeature[i2];
                residue = (Symbol)alphabetMap.get(String.valueOf(residuePositionPair.residue));
                currentDist = weightMatrixColumns[residuePositionPair.position];
                try {
                    currentDist.setWeight(residue, currentDist.getWeight(residue) + Math.abs(conditionalEntropy));
                }
                catch (IllegalSymbolException e) {
                    e.printStackTrace();
                }
                catch (ChangeVetoException e) {
                    e.printStackTrace();
                }
                ++i2;
            }
        }
        int i3 = 0;
        while (i3 < weightMatrixColumns.length) {
            Distribution distribution = weightMatrixColumns[i3];
            ++i3;
        }
        try {
            weightMatrix = new SimpleWeightMatrix(weightMatrixColumns);
            proteinProfile = new ProteinProfile(weightMatrix, alignedDomainSequence.getName());
        }
        catch (BioException e) {
            e.printStackTrace();
        }
        return proteinProfile;
    }

    public void outputAllLogos() {
        ProteinProfile proteinProfile = null;
        String outFileName = null;
        String outputDirectory = "D:\\Gbader\\Code\\PDZ\\data\\PDZ\\SpecificityPrediction\\Logos";
        Collection alignedSequences = this.sequenceNameToSequence.values();
        for (Sequence sequence : alignedSequences) {
            proteinProfile = this.predictProfileFromSequence(sequence);
            outFileName = new String(String.valueOf(outputDirectory) + File.separator + proteinProfile.getName() + ".png");
            ProteinSequenceLogo logo = new ProteinSequenceLogo(proteinProfile, 240);
            try {
                logo.sequenceLogoSetStartIndex(-9);
                ImageIO.write((RenderedImage)logo.drawSequenceLogo(), "png", new File(outFileName));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isFeatureInSequence(ResiduePositionPair[] sequenceFeature, String seqString) {
        int i = 0;
        while (i < sequenceFeature.length) {
            ResiduePositionPair residuePositionPair = sequenceFeature[i];
            if (seqString.charAt(residuePositionPair.position) != residuePositionPair.residue) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String featureToString(ResiduePositionPair[] feature) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < feature.length) {
            sb.append(feature[i].toString());
            ++i;
        }
        return sb.toString();
    }

    public void setDomainSequenceFilter(String domainSequenceFilter) {
        this.domainSequenceFilter = domainSequenceFilter;
    }

    public void setPeptideSequenceFilter(String peptideSequenceFilter) {
        this.peptideSequenceFilter = peptideSequenceFilter;
    }

    private class CorrelationResult {
        public int domainFeature;
        public int peptideFeature;
        public int correlationCount;

        public CorrelationResult(int domainFeature, int peptideFeature, int correlationCount) {
            this.domainFeature = domainFeature;
            this.peptideFeature = peptideFeature;
            this.correlationCount = correlationCount;
        }
    }

    private class ResiduePositionPair {
        public char residue;
        public int position;

        public ResiduePositionPair(int position, char residue) {
            this.position = position;
            this.residue = residue;
        }

        public String toString() {
            return new String("(" + this.residue + "@" + this.position + ")");
        }
    }
}

