/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.symbol.SymbolList;

public final class ProteinTerminus
implements Comparable {
    public static final int TERMINUS_NONE = 0;
    public static final int TERMINUS_N = 1;
    public static final int TERMINUS_C = 2;
    public static final ProteinTerminus NONE = new ProteinTerminus(0);
    public static final ProteinTerminus N = new ProteinTerminus(1);
    public static final ProteinTerminus C = new ProteinTerminus(2);
    private static final ProteinTerminus[] Termini = new ProteinTerminus[]{NONE, N, C};
    private static final String[] TerminiStrings = new String[]{"NONE", "N", "C"};
    private int terminus;

    public static final ProteinTerminus getProteinTerminus(int terminus) {
        if (terminus >= 0 && terminus <= 2) {
            return Termini[terminus];
        }
        return null;
    }

    private ProteinTerminus(int terminus) {
        this.terminus = terminus;
    }

    public boolean equals(Object obj) {
        return this.terminus == ((ProteinTerminus)obj).terminus;
    }

    public int compareTo(Object obj) {
        int other = ((ProteinTerminus)obj).terminus;
        if (this.terminus == other) {
            return 0;
        }
        if (this.terminus < other) {
            return -1;
        }
        return 1;
    }

    public int getTerminus() {
        return this.terminus;
    }

    public static ProteinTerminus parseTerminus(String terminus) {
        if (terminus.equalsIgnoreCase("C")) {
            return C;
        }
        if (terminus.equalsIgnoreCase("N")) {
            return N;
        }
        if (terminus.equalsIgnoreCase("NONE")) {
            return NONE;
        }
        return NONE;
    }

    public static Sequence getSequenceTerminus(Sequence sequence, int lengthFromTerminus, ProteinTerminus terminus) {
        Sequence sequenceSubSet = null;
        if (terminus.equals(N) && sequence.length() >= lengthFromTerminus) {
            SymbolList firstNresidues = sequence.subList(1, lengthFromTerminus);
            sequenceSubSet = new SimpleSequence(firstNresidues, "", sequence.getName(), null);
        } else if (terminus.equals(C) && sequence.length() >= lengthFromTerminus) {
            SymbolList lastNresidues = sequence.subList(sequence.length() - (lengthFromTerminus - 1), sequence.length());
            sequenceSubSet = new SimpleSequence(lastNresidues, "", sequence.getName(), null);
        } else {
            sequenceSubSet = sequence;
        }
        return sequenceSubSet;
    }

    public String toString() {
        return new String(TerminiStrings[this.terminus]);
    }
}

