/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import org.baderlab.brain.SequenceSearchResultSet;
import org.biojava.bio.seq.Sequence;

public class PeptideChipDesign {
    HashMap aaToCodonMap = new HashMap();
    SequenceSearchResultSet peptides;
    String description;

    public PeptideChipDesign(String codonUsageTableFileName) throws IOException {
        this.readAaToCodonMap(codonUsageTableFileName);
        this.description = null;
    }

    public PeptideChipDesign(String codonUsageTableFileName, SequenceSearchResultSet peptides) throws IOException {
        this(codonUsageTableFileName);
        this.peptides = peptides.getUniqueResultsBySequence();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    private void readAaToCodonMap(String fileName) throws IOException {
        String aaList = "ACDEFGHIKLMNPQRSTUVWY";
        BufferedReader br = null;
        br = new BufferedReader(new FileReader(fileName));
        String line = null;
        while ((line = br.readLine()) != null) {
            String[] lineSplit = line.split("\t");
            if (lineSplit.length != 2) continue;
            String aa = lineSplit[0];
            String codon = lineSplit[1];
            if ("ACDEFGHIKLMNPQRSTUVWY".indexOf(aa) < 0) {
                throw new IOException("Non standard amino acid found in codon bias table (" + aa + ").");
            }
            if (codon.length() != 3) {
                throw new IOException("Codon found not of length 3 (" + codon + ").");
            }
            this.aaToCodonMap.put(aa, codon);
        }
        br.close();
    }

    public void addToChip(SequenceSearchResultSet peptideResults) {
        if (this.peptides == null) {
            this.peptides = peptideResults;
        } else {
            this.peptides.mergeResultsFrom(peptideResults);
        }
        this.peptides = this.peptides.getUniqueResultsBySequence();
    }

    public int size() {
        return this.peptides.getNumberSequencesHit();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.description != null) {
            sb.append("Description: " + this.description + "\n");
        }
        sb.append("Peptide\tName\tDNA\n");
        Set peptideSet = this.peptides.getSequences();
        for (Sequence sequence : peptideSet) {
            sb.append(String.valueOf(sequence.seqString()) + "\t" + sequence.getName() + "\t" + this.convertPeptideToDNA(sequence.seqString()) + "\n");
        }
        return sb.toString();
    }

    private String convertPeptideToDNA(String peptide) {
        StringBuffer DNA = new StringBuffer();
        char[] peptideCharArray = peptide.toCharArray();
        int i = 0;
        while (i < peptideCharArray.length) {
            char c = peptideCharArray[i];
            String codon = (String)this.aaToCodonMap.get(String.valueOf(c));
            DNA = DNA.append(codon);
            ++i;
        }
        return DNA.toString();
    }
}

