/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.baderlab.brain.ProteinProfile;
import org.baderlab.brain.ProteinSequenceUtil;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dp.WeightMatrix;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceAnnotator;
import org.biojava.bio.seq.impl.ViewSequence;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;

public class DeltaGProfileAnnotator
implements SequenceAnnotator,
Serializable {
    private WeightMatrix matrix;
    private double threshold;
    private ArrayList alphabet;
    private double[] optimalWeightsInWeightMatrix;

    @Override
    public Sequence annotate(Sequence seq) throws IllegalAlphabetException, BioException, ChangeVetoException {
        seq = new ViewSequence(seq);
        int cols = this.matrix.columns();
        Feature.Template template = new Feature.Template();
        template.source = "DeltaGProfileAnnotator";
        int offset = 1;
        while (offset <= seq.length() - cols + 1) {
            double score = this.scoreWeightMatrix(this.matrix, seq, offset);
            if (score <= this.threshold) {
                template.location = new RangeLocation(offset, offset + cols - 1);
                SimpleAnnotation ann = new SimpleAnnotation();
                ann.setProperty("score", new Double(score));
                template.annotation = ann;
                seq.createFeature(template);
            }
            ++offset;
        }
        return seq;
    }

    public DeltaGProfileAnnotator(ProteinProfile profile, double threshold) {
        this.matrix = profile.getWeightMatrix();
        this.threshold = threshold;
        this.alphabet = this.get20aaAlphabet();
        try {
            this.optimalWeightsInWeightMatrix = this.setBestWeights(this.matrix);
        }
        catch (IllegalSymbolException e) {
            e.printStackTrace();
        }
    }

    private double[] setBestWeights(WeightMatrix wm) throws IllegalSymbolException {
        double[] bestWeights = new double[wm.columns()];
        int i = 0;
        while (i < wm.columns()) {
            Distribution d = wm.getColumn(i);
            Iterator l = this.alphabet.iterator();
            double bestWeight = 0.0;
            while (l.hasNext()) {
                Symbol symbol = (Symbol)l.next();
                if (!(bestWeight < d.getWeight(symbol))) continue;
                bestWeight = d.getWeight(symbol);
            }
            bestWeights[i] = bestWeight;
            ++i;
        }
        return bestWeights;
    }

    private ArrayList get20aaAlphabet() {
        ArrayList<Symbol> alphabet = new ArrayList<Symbol>(20);
        HashMap alphabetMap = ProteinSequenceUtil.get20aaAlphabet();
        Collection symbols = alphabetMap.values();
        for (Symbol symbol : symbols) {
            alphabet.add(symbol);
        }
        return alphabet;
    }

    public double scoreWeightMatrix(WeightMatrix matrix, SymbolList symList, int start) throws IllegalSymbolException {
        double score = 0.0;
        int cols = matrix.columns();
        int c = 0;
        while (c < cols) {
            Distribution d = matrix.getColumn(c);
            score += Math.log(d.getWeight(symList.symbolAt(c + start)) / this.optimalWeightsInWeightMatrix[c]);
            ++c;
        }
        return -score;
    }
}

