/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.dialogs.GridBagGroup;
import cytoscape.dialogs.MiscGB;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.ui.ValueDisplayer;
import cytoscape.visual.ui.VizMapUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DefaultPanel
extends JPanel
implements ChangeListener {
    private VisualMappingManager vmm;
    private ValueDisplayer backColor;
    private ValueDisplayer selectedNodeColor;
    private ValueDisplayer reverseSelectedNodeColor;
    private ValueDisplayer selectedEdgeColor;
    private ValueDisplayer reverseSelectedEdgeColor;
    private VizMapUI parentDialog;

    public DefaultPanel(VizMapUI parentDialog, VisualMappingManager vmm) {
        super(false);
        this.parentDialog = parentDialog;
        this.vmm = vmm;
        VisualStyle vs = vmm.getVisualStyle();
        GlobalAppearanceCalculator gCalc = vs.getGlobalAppearanceCalculator();
        gCalc.addChangeListener(this);
        vmm.addChangeListener(this);
        this.addColorButtons();
    }

    private void addColorButtons() {
        GridBagGroup def = new GridBagGroup();
        def.panel = this;
        this.setLayout(def.gridbag);
        MiscGB.pad(def.constraints, 2, 2);
        MiscGB.inset(def.constraints, 3);
        GlobalAppearanceCalculator gCalc = this.vmm.getVisualStyle().getGlobalAppearanceCalculator();
        this.backColor = ValueDisplayer.getDisplayFor(this.parentDialog, "Background Color", gCalc.getDefaultBackgroundColor());
        this.backColor.addItemListener(new BackColorListener());
        JButton backColorBut = new JButton("Background Color");
        backColorBut.addActionListener(this.backColor.getInputListener());
        MiscGB.insert(def, (Component)backColorBut, 0, 0);
        VisualStyle vs = this.vmm.getVisualStyle();
        MiscGB.insert(def, (Component)this.backColor, 1, 0);
        this.selectedNodeColor = ValueDisplayer.getDisplayFor(this.parentDialog, "Selected Node Color 1", gCalc.getDefaultNodeSelectionColor());
        this.selectedNodeColor.addItemListener(new SelectedNodeColorListener());
        JButton selectedNodeColorButton = new JButton("Selected Node Color 1");
        selectedNodeColorButton.setToolTipText("Change color for selected nodes. This is for normal selection.");
        selectedNodeColorButton.addActionListener(this.selectedNodeColor.getInputListener());
        MiscGB.insert(def, (Component)selectedNodeColorButton, 0, 1);
        MiscGB.insert(def, (Component)this.selectedNodeColor, 1, 1);
        this.reverseSelectedNodeColor = ValueDisplayer.getDisplayFor(this.parentDialog, "Selected Node Color 2", gCalc.getDefaultNodeReverseSelectionColor());
        this.reverseSelectedNodeColor.addItemListener(new ReverseSelectedNodeColorListener());
        JButton reverseSelectedNodeColorButton = new JButton("Selected Node Color 2");
        reverseSelectedNodeColorButton.setToolTipText("Change color for selected nodes in attribute browser.");
        reverseSelectedNodeColorButton.addActionListener(this.reverseSelectedNodeColor.getInputListener());
        MiscGB.insert(def, (Component)reverseSelectedNodeColorButton, 0, 2);
        MiscGB.insert(def, (Component)this.reverseSelectedNodeColor, 1, 2);
        this.selectedEdgeColor = ValueDisplayer.getDisplayFor(this.parentDialog, "Selected Edge Color 1", gCalc.getDefaultEdgeSelectionColor());
        this.selectedEdgeColor.addItemListener(new SelectedEdgeColorListener());
        JButton selectedEdgeColorButton = new JButton("Selected Edge Color 1");
        selectedEdgeColorButton.setToolTipText("Change color for selected edges. This is for normal selection.");
        selectedEdgeColorButton.addActionListener(this.selectedEdgeColor.getInputListener());
        MiscGB.insert(def, (Component)selectedEdgeColorButton, 0, 3);
        MiscGB.insert(def, (Component)this.selectedEdgeColor, 1, 3);
        this.reverseSelectedEdgeColor = ValueDisplayer.getDisplayFor(this.parentDialog, "Selected Edge Color 2", gCalc.getDefaultEdgeReverseSelectionColor());
        this.reverseSelectedEdgeColor.addItemListener(new ReverseSelectedEdgeColorListener());
        JButton reverseSelectedEdgeColorButton = new JButton("Selected Edge Color 2");
        reverseSelectedEdgeColorButton.setToolTipText("Change color for selected edges in attribute browser.");
        reverseSelectedEdgeColorButton.addActionListener(this.reverseSelectedEdgeColor.getInputListener());
        MiscGB.insert(def, (Component)reverseSelectedEdgeColorButton, 0, 4);
        MiscGB.insert(def, (Component)this.reverseSelectedEdgeColor, 1, 4);
    }

    public void stateChanged(ChangeEvent e) {
        VisualStyle vs = this.vmm.getVisualStyle();
        GlobalAppearanceCalculator gCalc = vs.getGlobalAppearanceCalculator();
        Color backgroundColor = gCalc.getDefaultBackgroundColor();
        this.backColor.setBackground(backgroundColor);
        this.selectedNodeColor.setBackground(gCalc.getDefaultNodeSelectionColor());
        this.reverseSelectedNodeColor.setBackground(gCalc.getDefaultNodeReverseSelectionColor());
        this.selectedEdgeColor.setBackground(gCalc.getDefaultEdgeSelectionColor());
        this.reverseSelectedEdgeColor.setBackground(gCalc.getDefaultEdgeReverseSelectionColor());
        this.repaint();
    }

    private class ReverseSelectedEdgeColorListener
    implements ItemListener {
        private ReverseSelectedEdgeColorListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                Color newReverseSelectedEdge = (Color)DefaultPanel.this.reverseSelectedEdgeColor.getValue();
                DefaultPanel.this.vmm.getVisualStyle().getGlobalAppearanceCalculator().setDefaultEdgeReverseSelectionColor(newReverseSelectedEdge);
            }
        }
    }

    private class SelectedEdgeColorListener
    implements ItemListener {
        private SelectedEdgeColorListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                Color newSelectedEdge = (Color)DefaultPanel.this.selectedEdgeColor.getValue();
                DefaultPanel.this.vmm.getVisualStyle().getGlobalAppearanceCalculator().setDefaultEdgeSelectionColor(newSelectedEdge);
            }
        }
    }

    private class ReverseSelectedNodeColorListener
    implements ItemListener {
        private ReverseSelectedNodeColorListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                Color newReverseSelectedNode = (Color)DefaultPanel.this.reverseSelectedNodeColor.getValue();
                DefaultPanel.this.vmm.getVisualStyle().getGlobalAppearanceCalculator().setDefaultNodeReverseSelectionColor(newReverseSelectedNode);
            }
        }
    }

    private class SelectedNodeColorListener
    implements ItemListener {
        private SelectedNodeColorListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                Color newSelectedNode = (Color)DefaultPanel.this.selectedNodeColor.getValue();
                DefaultPanel.this.vmm.getVisualStyle().getGlobalAppearanceCalculator().setDefaultNodeSelectionColor(newSelectedNode);
            }
        }
    }

    private class BackColorListener
    implements ItemListener {
        private BackColorListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                Color newBG = (Color)DefaultPanel.this.backColor.getValue();
                DefaultPanel.this.vmm.getVisualStyle().getGlobalAppearanceCalculator().setDefaultBackgroundColor(newBG);
            }
        }
    }
}

