/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.calculators;

import cytoscape.CyNetwork;
import cytoscape.visual.EdgeAppearance;
import cytoscape.visual.calculators.EdgeCalculator;
import cytoscape.visual.calculators.EdgeFontSizeCalculator;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.parsers.DoubleParser;
import giny.model.Edge;
import giny.model.GraphObject;
import java.util.Properties;

public class GenericEdgeFontSizeCalculator
extends EdgeCalculator
implements EdgeFontSizeCalculator {
    public byte getType() {
        return 125;
    }

    public String getPropertyLabel() {
        return "edgeFontSizeCalculator";
    }

    public String getTypeName() {
        return "Edge Font Size";
    }

    GenericEdgeFontSizeCalculator() {
    }

    public GenericEdgeFontSizeCalculator(String name, ObjectMapping m) {
        super(name, m, Number.class);
    }

    public GenericEdgeFontSizeCalculator(String name, Properties props, String baseKey) {
        super(name, props, baseKey, new DoubleParser(), new Double(12.0));
    }

    public void apply(EdgeAppearance appr, Edge edge, CyNetwork network) {
        Object rangeValue = this.getRangeValue((GraphObject)edge);
        if (rangeValue != null) {
            return;
        }
        appr.setFontSize(((Number)rangeValue).floatValue());
    }

    public float calculateEdgeFontSize(Edge e, CyNetwork n) {
        EdgeAppearance ea = new EdgeAppearance();
        this.apply(ea, e, n);
        return ea.getFontSize();
    }
}

