/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.calculators.Calculator;
import java.util.Vector;

public class VisualStyle
implements Cloneable {
    String name = "default";
    NodeAppearanceCalculator nodeAC;
    EdgeAppearanceCalculator edgeAC;
    GlobalAppearanceCalculator globalAC;
    protected int dupeCount = 0;

    public int getDupeCount() {
        return this.dupeCount;
    }

    public Vector checkConflictingCalculator(Calculator c) {
        Vector<String> conflicts = new Vector<String>();
        conflicts.add(this.name);
        for (Calculator nodeCalcs : this.nodeAC.getCalculators()) {
            if (nodeCalcs != c) continue;
            conflicts.add(nodeCalcs.getPropertyLabel());
        }
        for (Calculator edgeCalcs : this.edgeAC.getCalculators()) {
            if (edgeCalcs != c) continue;
            conflicts.add(edgeCalcs.getPropertyLabel());
        }
        return conflicts;
    }

    public Object clone() throws CloneNotSupportedException {
        int dupeCountIndex;
        VisualStyle copy = (VisualStyle)super.clone();
        String dupeFreeName = this.dupeCount != 0 ? ((dupeCountIndex = this.name.lastIndexOf(new Integer(this.dupeCount).toString())) == -1 ? new String(this.name) : this.name.substring(0, dupeCountIndex)) : new String(this.name);
        copy.name = dupeFreeName;
        ++copy.dupeCount;
        copy.nodeAC = (NodeAppearanceCalculator)this.nodeAC.clone();
        copy.edgeAC = (EdgeAppearanceCalculator)this.edgeAC.clone();
        copy.globalAC = (GlobalAppearanceCalculator)this.globalAC.clone();
        return copy;
    }

    public VisualStyle(String name) {
        this.setName(name);
        this.setNodeAppearanceCalculator(new NodeAppearanceCalculator());
        this.setEdgeAppearanceCalculator(new EdgeAppearanceCalculator());
        this.setGlobalAppearanceCalculator(new GlobalAppearanceCalculator());
    }

    public VisualStyle(String name, NodeAppearanceCalculator nac, EdgeAppearanceCalculator eac, GlobalAppearanceCalculator gac) {
        this.setName(name);
        this.setNodeAppearanceCalculator(nac);
        this.setEdgeAppearanceCalculator(eac);
        this.setGlobalAppearanceCalculator(gac);
    }

    public VisualStyle(VisualStyle toCopy) {
        if (toCopy == null) {
            return;
        }
        this.setName(toCopy.getName());
        this.setNodeAppearanceCalculator(new NodeAppearanceCalculator(toCopy.getNodeAppearanceCalculator()));
        this.setEdgeAppearanceCalculator(new EdgeAppearanceCalculator(toCopy.getEdgeAppearanceCalculator()));
        this.setGlobalAppearanceCalculator(new GlobalAppearanceCalculator(toCopy.getGlobalAppearanceCalculator()));
    }

    public VisualStyle(VisualStyle toCopy, String newName) {
        if (newName == null) {
            String s = "Unexpected null name in VisualStyle constructor";
            throw new NullPointerException(s);
        }
        this.setName(newName);
        if (toCopy == null) {
            return;
        }
        this.setNodeAppearanceCalculator(new NodeAppearanceCalculator(toCopy.getNodeAppearanceCalculator()));
        this.setEdgeAppearanceCalculator(new EdgeAppearanceCalculator(toCopy.getEdgeAppearanceCalculator()));
        this.setGlobalAppearanceCalculator(new GlobalAppearanceCalculator(toCopy.getGlobalAppearanceCalculator()));
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String setName(String n) {
        String tmp = this.name;
        this.name = n;
        return tmp;
    }

    public NodeAppearanceCalculator getNodeAppearanceCalculator() {
        return this.nodeAC;
    }

    public NodeAppearanceCalculator setNodeAppearanceCalculator(NodeAppearanceCalculator nac) {
        NodeAppearanceCalculator tmp = this.nodeAC;
        this.nodeAC = nac == null ? new NodeAppearanceCalculator() : nac;
        return tmp;
    }

    public EdgeAppearanceCalculator getEdgeAppearanceCalculator() {
        return this.edgeAC;
    }

    public EdgeAppearanceCalculator setEdgeAppearanceCalculator(EdgeAppearanceCalculator eac) {
        EdgeAppearanceCalculator tmp = this.edgeAC;
        this.edgeAC = eac == null ? new EdgeAppearanceCalculator() : eac;
        return tmp;
    }

    public GlobalAppearanceCalculator getGlobalAppearanceCalculator() {
        return this.globalAC;
    }

    public GlobalAppearanceCalculator setGlobalAppearanceCalculator(GlobalAppearanceCalculator gac) {
        GlobalAppearanceCalculator tmp = this.globalAC;
        this.globalAC = gac == null ? new GlobalAppearanceCalculator() : gac;
        return tmp;
    }
}

