/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.visual.Appearance;
import cytoscape.visual.BypassHelper;
import cytoscape.visual.LabelPosition;
import cytoscape.visual.LineType;
import cytoscape.visual.ShapeNodeRealizer;
import cytoscape.visual.parsers.ColorParser;
import cytoscape.visual.parsers.DoubleParser;
import cytoscape.visual.parsers.FontParser;
import cytoscape.visual.parsers.LabelPositionParser;
import cytoscape.visual.parsers.LineTypeParser;
import cytoscape.visual.parsers.NodeShapeParser;
import cytoscape.visual.parsers.ObjectToString;
import giny.model.Node;
import giny.view.Label;
import giny.view.NodeView;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.Properties;

public class NodeAppearance
implements Appearance,
Cloneable {
    static Font defaultFont = new Font(null, 0, 12);
    Color fillColor = Color.WHITE;
    Color borderColor = Color.BLACK;
    LineType borderLineType = LineType.LINE_1;
    byte shape = 0;
    double width = 70.0;
    double height = 30.0;
    double size = 35.0;
    String label = "";
    String toolTip = "";
    Font font = defaultFont;
    Color labelColor = Color.black;
    boolean nodeSizeLocked = true;
    LabelPosition labelPosition = new LabelPosition();

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color c) {
        if (c != null) {
            this.fillColor = c;
        }
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color c) {
        if (c != null) {
            this.borderColor = c;
        }
    }

    public LineType getBorderLineType() {
        return this.borderLineType;
    }

    public void setBorderLineType(LineType lt) {
        if (lt != null) {
            this.borderLineType = lt;
        }
    }

    public byte getShape() {
        return this.shape;
    }

    public void setShape(byte s) {
        this.shape = s;
    }

    public double getWidth() {
        if (this.nodeSizeLocked) {
            return this.size;
        }
        return this.width;
    }

    public void setJustWidth(double d) {
        this.width = d;
    }

    public void setWidth(double d) {
        this.width = d;
        if (this.nodeSizeLocked) {
            this.size = d;
        }
    }

    public double getHeight() {
        if (this.nodeSizeLocked) {
            return this.size;
        }
        return this.height;
    }

    public void setJustHeight(double d) {
        this.height = d;
    }

    public void setHeight(double d) {
        this.height = d;
        if (this.nodeSizeLocked) {
            this.size = d;
        }
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double s) {
        this.size = s;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String s) {
        if (s != null) {
            this.label = s;
        }
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public void setToolTip(String s) {
        if (s != null) {
            this.toolTip = s;
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font f) {
        if (f != null) {
            this.font = f;
        }
    }

    public float getFontSize() {
        return this.font.getSize2D();
    }

    public void setFontSize(float f) {
        this.font = this.font.deriveFont(f);
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color c) {
        if (c != null) {
            this.labelColor = c;
        }
    }

    public LabelPosition getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(LabelPosition c) {
        if (c != null) {
            this.labelPosition = c;
        }
    }

    public void applyAppearance(NodeView nodeView, boolean optimizer) {
        this.applyAppearance(nodeView);
    }

    public void applyAppearance(NodeView nodeView) {
        double newOffsetY;
        double existingOffsetY;
        double newOffsetX;
        double existingOffsetX;
        int newNodeAnchor;
        int existingNodeAnchor;
        int newJustify;
        int existingJustify;
        int newTextAnchor;
        int existingTextAnchor;
        Paint existingTextColor;
        Color newTextColor;
        Label nodelabel;
        String existingLabel;
        String newLabel;
        double existingWidth;
        double difference;
        double existingHeight;
        Paint existingBorderPaint;
        boolean change_made = false;
        Paint existingUnselectedColor = nodeView.getUnselectedPaint();
        if (!this.fillColor.equals(existingUnselectedColor)) {
            change_made = true;
            nodeView.setUnselectedPaint((Paint)this.fillColor);
        }
        if (!this.borderColor.equals(existingBorderPaint = nodeView.getBorderPaint())) {
            change_made = true;
            nodeView.setBorderPaint((Paint)this.borderColor);
        }
        Stroke existingBorderType = nodeView.getBorder();
        Stroke newBorderType = this.borderLineType.getStroke();
        if (!newBorderType.equals(existingBorderType)) {
            change_made = true;
            nodeView.setBorder(newBorderType);
        }
        if (this.nodeSizeLocked) {
            existingHeight = nodeView.getHeight();
            difference = this.size - existingHeight;
            if (Math.abs(difference) > 0.1) {
                change_made = true;
                nodeView.setHeight(this.size);
            }
            if (Math.abs(difference = this.size - (existingWidth = nodeView.getWidth())) > 0.1) {
                change_made = true;
                nodeView.setWidth(this.size);
            }
        } else {
            existingHeight = nodeView.getHeight();
            difference = this.height - existingHeight;
            if (Math.abs(difference) > 0.1) {
                change_made = true;
                nodeView.setHeight(this.height);
            }
            if (Math.abs(difference = this.width - (existingWidth = nodeView.getWidth())) > 0.1) {
                change_made = true;
                nodeView.setWidth(this.width);
            }
        }
        int existingShape = nodeView.getShape();
        int newShape = ShapeNodeRealizer.getGinyShape(this.shape);
        if (existingShape != newShape) {
            change_made = true;
            nodeView.setShape(newShape);
        }
        if (!(newLabel = this.label).equals(existingLabel = (nodelabel = nodeView.getLabel()).getText())) {
            change_made = true;
            nodelabel.setText(newLabel);
        }
        Font existingFont = nodelabel.getFont();
        Font newFont = this.getFont();
        if (!newFont.equals(existingFont)) {
            change_made = true;
            nodelabel.setFont(newFont);
        }
        if (!((Object)(newTextColor = this.labelColor)).equals(existingTextColor = nodelabel.getTextPaint())) {
            change_made = true;
            nodelabel.setTextPaint((Paint)newTextColor);
        }
        if ((existingTextAnchor = nodelabel.getTextAnchor()) != (newTextAnchor = this.labelPosition.getLabelAnchor())) {
            change_made = true;
            nodelabel.setTextAnchor(newTextAnchor);
        }
        if ((existingJustify = nodelabel.getJustify()) != (newJustify = this.labelPosition.getJustify())) {
            change_made = true;
            nodelabel.setJustify(newJustify);
        }
        if ((existingNodeAnchor = nodeView.getNodeLabelAnchor()) != (newNodeAnchor = this.labelPosition.getTargetAnchor())) {
            change_made = true;
            nodeView.setNodeLabelAnchor(newNodeAnchor);
        }
        if ((existingOffsetX = nodeView.getLabelOffsetX()) != (newOffsetX = this.labelPosition.getOffsetX())) {
            change_made = true;
            nodeView.setLabelOffsetX(newOffsetX);
        }
        if ((existingOffsetY = nodeView.getLabelOffsetY()) != (newOffsetY = this.labelPosition.getOffsetY())) {
            change_made = true;
            nodeView.setLabelOffsetY(newOffsetY);
        }
        if (change_made) {
            nodeView.setNodePosition(false);
        }
    }

    public void applyDefaultProperties(Properties nacProps, String baseKey) {
        Object f;
        double d;
        Double dObj;
        byte b;
        Byte bObj;
        LineType lt;
        Color c;
        String value = null;
        value = nacProps.getProperty(baseKey + ".defaultNodeFillColor");
        if (value != null && (c = new ColorParser().parseColor(value)) != null) {
            this.setFillColor(c);
        }
        if ((value = nacProps.getProperty(baseKey + ".defaultNodeBorderColor")) != null && (c = new ColorParser().parseColor(value)) != null) {
            this.setBorderColor(c);
        }
        if ((value = nacProps.getProperty(baseKey + ".defaultNodeLineType")) != null && (lt = new LineTypeParser().parseLineType(value)) != null) {
            this.setBorderLineType(lt);
        }
        if ((value = nacProps.getProperty(baseKey + ".defaultNodeShape")) != null && (bObj = new NodeShapeParser().parseNodeShape(value)) != null && NodeShapeParser.isValidShape(b = bObj.byteValue())) {
            this.setShape(b);
        }
        if ((value = nacProps.getProperty(baseKey + ".defaultNodeWidth")) != null && (dObj = new DoubleParser().parseDouble(value)) != null && (d = dObj.doubleValue()) > 0.0) {
            this.width = d;
        }
        if ((value = nacProps.getProperty(baseKey + ".defaultNodeHeight")) != null && (dObj = new DoubleParser().parseDouble(value)) != null && (d = dObj.doubleValue()) > 0.0) {
            this.height = d;
        }
        if ((value = nacProps.getProperty(baseKey + ".defaultNodeSize")) != null && (dObj = new DoubleParser().parseDouble(value)) != null && (d = dObj.doubleValue()) > 0.0) {
            this.size = d;
        }
        if ((value = nacProps.getProperty(baseKey + ".defaultNodeLabel")) != null) {
            this.setLabel(value);
        }
        if ((value = nacProps.getProperty(baseKey + ".defaultNodeToolTip")) != null) {
            this.setToolTip(value);
        }
        if ((value = nacProps.getProperty(baseKey + ".defaultNodeFont")) != null && (f = new FontParser().parseFont(value)) != null) {
            this.setFont((Font)f);
        }
        if ((value = nacProps.getProperty(baseKey + ".defaultNodeLabelPosition")) != null && (f = new LabelPositionParser().parseLabelPosition(value)) != null) {
            this.setLabelPosition((LabelPosition)f);
        }
    }

    public Properties getDefaultProperties(String baseKey) {
        String key = null;
        String value = null;
        Properties newProps = new Properties();
        key = baseKey + ".defaultNodeFillColor";
        value = ObjectToString.getStringValue(this.getFillColor());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultNodeBorderColor";
        value = ObjectToString.getStringValue(this.getBorderColor());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultNodeLineType";
        value = ObjectToString.getStringValue(this.getBorderLineType());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultNodeShape";
        Byte nodeShapeByte = new Byte(this.getShape());
        value = ObjectToString.getStringValue(nodeShapeByte);
        newProps.setProperty(key, value);
        key = baseKey + ".defaultNodeWidth";
        Double nodeWidthDouble = new Double(this.getWidth());
        value = ObjectToString.getStringValue(nodeWidthDouble);
        newProps.setProperty(key, value);
        key = baseKey + ".defaultNodeHeight";
        Double nodeHeightDouble = new Double(this.getHeight());
        value = ObjectToString.getStringValue(nodeHeightDouble);
        newProps.setProperty(key, value);
        key = baseKey + ".defaultNodeSize";
        Double nodeSizeDouble = new Double(this.getSize());
        value = ObjectToString.getStringValue(nodeSizeDouble);
        newProps.setProperty(key, value);
        key = baseKey + ".defaultNodeLabel";
        value = ObjectToString.getStringValue(this.getLabel());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultNodeToolTip";
        value = ObjectToString.getStringValue(this.getToolTip());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultNodeFont";
        value = ObjectToString.getStringValue(this.getFont());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultNodeLabelPosition";
        value = ObjectToString.getStringValue(this.getLabelPosition());
        newProps.setProperty(key, value);
        return newProps;
    }

    public String getDescription(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        String lineSep = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append(prefix + "NodeFillColor = ").append(this.fillColor).append(lineSep);
        sb.append(prefix + "NodeBorderColor = ").append(this.borderColor).append(lineSep);
        String nodeLineTypeText = ObjectToString.getStringValue(this.borderLineType);
        sb.append(prefix + "NodeLineType = ").append(nodeLineTypeText).append(lineSep);
        Byte nodeShapeByte = new Byte(this.shape);
        String nodeShapeText = ObjectToString.getStringValue(nodeShapeByte);
        sb.append(prefix + "NodeShape = ").append(nodeShapeText).append(lineSep);
        sb.append(prefix + "NodeWidth = ").append(this.width).append(lineSep);
        sb.append(prefix + "NodeHeight = ").append(this.height).append(lineSep);
        sb.append(prefix + "NodeSize = ").append(this.size).append(lineSep);
        sb.append(prefix + "NodeLabel = ").append(this.label).append(lineSep);
        sb.append(prefix + "NodeToolTip = ").append(this.toolTip).append(lineSep);
        sb.append(prefix + "NodeFont = ").append(this.font).append(lineSep);
        sb.append(prefix + "NodeFontColor = ").append(this.labelColor.toString()).append(lineSep);
        sb.append(prefix + "NodeLabelPosition = ").append(this.labelPosition.toString()).append(lineSep);
        sb.append(prefix + "nodeSizeLocked = ").append(this.nodeSizeLocked).append(lineSep);
        return sb.toString();
    }

    public String getDescription() {
        return this.getDescription(null);
    }

    public Object get(byte type) {
        Object defaultObj = null;
        switch (type) {
            case 0: {
                defaultObj = this.getFillColor();
                break;
            }
            case 1: {
                defaultObj = this.getBorderColor();
                break;
            }
            case 2: {
                defaultObj = this.getBorderLineType();
                break;
            }
            case 3: {
                defaultObj = new Byte(this.getShape());
                break;
            }
            case 126: {
                defaultObj = new Double(this.getHeight());
                break;
            }
            case 127: {
                defaultObj = new Double(this.getWidth());
                break;
            }
            case 4: {
                defaultObj = new Double(this.getSize());
                break;
            }
            case 5: {
                defaultObj = this.getLabel();
                break;
            }
            case 7: {
                defaultObj = this.getLabelColor();
                break;
            }
            case 14: {
                defaultObj = this.getToolTip();
                break;
            }
            case 122: {
                defaultObj = this.getFont();
                break;
            }
            case 123: {
                defaultObj = new Double(this.getFont().getSize());
                break;
            }
            case 16: {
                defaultObj = this.getLabelPosition();
            }
        }
        return defaultObj;
    }

    public void set(byte type, Object c) {
        switch (type) {
            case 0: {
                this.setFillColor((Color)c);
                break;
            }
            case 1: {
                this.setBorderColor((Color)c);
                break;
            }
            case 2: {
                this.setBorderLineType((LineType)c);
                break;
            }
            case 3: {
                this.setShape((Byte)c);
                break;
            }
            case 126: {
                this.setHeight((Double)c);
                break;
            }
            case 127: {
                this.setWidth((Double)c);
                break;
            }
            case 4: {
                this.setSize((Double)c);
                break;
            }
            case 5: {
                this.setLabel((String)c);
                break;
            }
            case 7: {
                this.setLabelColor((Color)c);
                break;
            }
            case 14: {
                this.setToolTip((String)c);
                break;
            }
            case 122: {
                this.setFont((Font)c);
                break;
            }
            case 123: {
                this.setFontSize(((Double)c).floatValue());
                break;
            }
            case 16: {
                this.setLabelPosition((LabelPosition)c);
            }
        }
    }

    public void copy(NodeAppearance na) {
        boolean actualLockState = na.getNodeSizeLocked();
        this.setNodeSizeLocked(false);
        na.setNodeSizeLocked(false);
        this.setFillColor(na.getFillColor());
        this.setBorderColor(na.getBorderColor());
        this.setBorderLineType(na.getBorderLineType());
        this.setShape(na.getShape());
        this.setWidth(na.getWidth());
        this.setHeight(na.getHeight());
        this.setSize(na.getSize());
        this.setLabel(na.getLabel());
        this.setToolTip(na.getToolTip());
        this.setFont(na.getFont());
        this.setLabelColor(na.getLabelColor());
        this.setLabelPosition(na.getLabelPosition());
        this.setNodeSizeLocked(actualLockState);
        na.setNodeSizeLocked(actualLockState);
    }

    public Object clone() {
        NodeAppearance na = new NodeAppearance();
        na.copy(this);
        return na;
    }

    public boolean getNodeSizeLocked() {
        return this.nodeSizeLocked;
    }

    public void setNodeSizeLocked(boolean b) {
        this.nodeSizeLocked = b;
    }

    public void applyBypass(Node n) {
        Double s;
        Double h;
        Double w;
        if (n == null) {
            return;
        }
        String id = n.getIdentifier();
        CyAttributes attrs = Cytoscape.getNodeAttributes();
        this.setFillColor(BypassHelper.getColorBypass(attrs, id, "node.fillColor"));
        this.setBorderColor(BypassHelper.getColorBypass(attrs, id, "node.borderColor"));
        this.setBorderLineType((LineType)BypassHelper.getBypass(attrs, id, "node.lineType", LineType.class));
        Byte b = (Byte)BypassHelper.getBypass(attrs, id, "node.shape", Byte.class);
        if (b != null) {
            this.setShape(b);
        }
        if ((w = (Double)BypassHelper.getBypass(attrs, id, "node.width", Double.class)) != null) {
            this.setWidth(w);
        }
        if ((h = (Double)BypassHelper.getBypass(attrs, id, "node.height", Double.class)) != null) {
            this.setHeight(h);
        }
        if ((s = (Double)BypassHelper.getBypass(attrs, id, "node.size", Double.class)) != null) {
            this.setSize(s);
        }
        this.setLabel((String)BypassHelper.getBypass(attrs, id, "node.label", String.class));
        this.setToolTip((String)BypassHelper.getBypass(attrs, id, "node.toolTip", String.class));
        this.setFont((Font)BypassHelper.getBypass(attrs, id, "node.font", Font.class));
        Double f = (Double)BypassHelper.getBypass(attrs, id, "node.fontSize", Double.class);
        if (f != null) {
            this.setFontSize(f.floatValue());
        }
        this.setLabelColor((Color)BypassHelper.getBypass(attrs, id, "node.labelColor", Color.class));
        this.setLabelPosition((LabelPosition)BypassHelper.getBypass(attrs, id, "node.labelPosition", LabelPosition.class));
    }
}

