/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JnlpWriterUtil {
    public Document Doc;
    public Element Root;
    public XMLOutputter Out;
    protected String Filename;
    protected String CytoDir;
    protected String Url = "http://your.jnlp.location";
    protected String SaveDir;
    public String LibDir;
    public String PluginDir;
    protected HashMap<String, String> Options;

    public JnlpWriterUtil(String[] args) {
        this.Options = this.getOptions(args);
        this.Filename = this.Options.get("filename");
        this.CytoDir = this.Options.get("cyto_dir");
        this.SaveDir = this.Options.get("save_dir");
        if (this.Options.containsKey("url")) {
            this.Url = this.Options.get("url");
        }
        this.LibDir = this.CytoDir + "/lib";
        this.PluginDir = this.CytoDir + "/plugins";
        this.setupDoc();
    }

    private void setupDoc() {
        this.Doc = new Document();
        this.Root = new Element("jnlp");
        this.Doc.setRootElement(this.Root);
        if (!this.Options.containsKey("url")) {
            Comment Codebase = new Comment("Replace the codebase URL with your own");
            this.Root.addContent(Codebase);
        }
        this.Root.setAttribute("codebase", this.Url);
        this.Root.setAttribute("href", this.Filename);
        this.Out = new XMLOutputter("  ", true);
    }

    private static void print(String s) {
        System.out.println(s);
    }

    public static void main(String[] args) throws Exception {
        JnlpWriterUtil jutil = new JnlpWriterUtil(args);
        ArrayList<String> MainLibs = jutil.getLibJars();
        JnlpWriterUtil.print("Adding " + MainLibs.size() + " total main jars");
        ArrayList<String> PluginLibs = jutil.getPluginJars();
        ArrayList<String> PluginClasses = jutil.getMainClass(PluginLibs, jutil.PluginDir);
        JnlpWriterUtil.print("Adding " + PluginLibs.size() + " total plugin jars");
        jutil.createInfoTag();
        jutil.createResourcesTag();
        jutil.addJars("lib/", MainLibs, null);
        jutil.addJars("plugins/", PluginLibs, "These are the plugins you wish to load, edit as necessary.");
        jutil.addArguments(PluginClasses);
        jutil.writeToFile();
    }

    public String getString() {
        return this.Out.outputString(this.Doc);
    }

    public void writeToFile() throws IOException {
        FileWriter writer = new FileWriter(this.SaveDir + "/" + this.Filename);
        this.Out.output(this.Doc, (Writer)writer);
    }

    public void createInfoTag() {
        Element Info2 = new Element("information");
        Info2.addContent(new Element("title").setText("Cytoscape Webstart"));
        Info2.addContent(new Element("vendor").setText("Cytoscape Collaboration"));
        Info2.addContent(new Element("homepage").setAttribute("href", "http://cytoscape.org"));
        Info2.addContent(new Element("offline-allowed"));
        this.Root.addContent(new Element("security").addContent(new Element("all-permissions")));
        this.Root.addContent(Info2);
    }

    public void createResourcesTag() {
        Element Resources = new Element("resources");
        Element JSE = new Element("j2se");
        JSE.setAttribute("version", "1.5+");
        JSE.setAttribute("max-heap-size", "1024M");
        Resources.addContent(JSE);
        Resources.addContent(new Comment("All lib jars that cytoscape requires to run should be in this list"));
        Resources.addContent(new Element("jar").setAttribute("href", "cytoscape.jar"));
        this.Root.addContent(Resources);
    }

    public void addJars(String Prefix, ArrayList<String> Jars, String Comment2) {
        Element Resources = this.Root.getChild("resources");
        if (Comment2 != null) {
            Resources.addContent(new Comment(Comment2));
        }
        for (int i = 0; i < Jars.size(); ++i) {
            Resources.addContent(new Element("jar").setAttribute("href", Prefix + Jars.get(i)));
        }
    }

    public ArrayList<String> getLibJars() {
        return this.getJarList(this.LibDir);
    }

    public ArrayList<String> getPluginJars() {
        return this.getJarList(this.PluginDir);
    }

    private ArrayList<String> getJarList(String Dir) {
        File JarDir = new File(Dir);
        if (!JarDir.exists()) {
            System.err.println("Required directory '" + JarDir.getAbsolutePath() + "' does not exist");
            System.exit(-1);
        }
        ArrayList<String> JarFiles = new ArrayList<String>();
        for (File Current : JarDir.listFiles()) {
            if (!Current.isFile() || !Current.getName().endsWith(".jar")) continue;
            JarFiles.add(Current.getName());
        }
        return JarFiles;
    }

    public ArrayList<String> getMainClass(ArrayList<String> JarFiles, String JarDir) {
        ArrayList<String> PluginMainClass = new ArrayList<String>();
        for (int i = 0; i < JarFiles.size(); ++i) {
            try {
                String className;
                JarFile jf = new JarFile(JarDir + "/" + JarFiles.get(i));
                Manifest m = jf.getManifest();
                if (m == null || (className = m.getMainAttributes().getValue("Cytoscape-Plugin")) == null) continue;
                PluginMainClass.add(className);
                continue;
            }
            catch (Exception E) {
                E.printStackTrace();
            }
        }
        return PluginMainClass;
    }

    private HashMap<String, String> getOptions(String[] args) {
        String Usage = "Usage: java " + this + " [parameters]\n" + "Option    : Description          Required\n" + "-filename : Name of jnlp file    yes\n" + "-cyto_dir : Cytoscape directory  yes\n" + "-url      : Webstart url         no\n" + "-save_dir : Save to dir          yes\n";
        HashMap<String, String> Opts = new HashMap<String, String>();
        if (args.length < 2) {
            System.err.println("Too few arguments (" + args.length + "). " + Usage);
            System.exit(-1);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-filename")) {
                Opts.put("filename", args[i + 1]);
            }
            if (args[i].equals("-cyto_dir")) {
                Opts.put("cyto_dir", args[i + 1]);
            }
            if (args[i].equals("-url")) {
                Opts.put("url", args[i + 1]);
            }
            if (!args[i].equals("-save_dir")) continue;
            Opts.put("save_dir", args[i + 1]);
        }
        if (!(Opts.containsKey("filename") && Opts.containsKey("cyto_dir") && Opts.containsKey("save_dir"))) {
            System.err.println("Required arguments missing. " + Usage);
            System.exit(-1);
        }
        return Opts;
    }

    public void addArguments(ArrayList<String> Args) {
        Element Application2 = this.Root.getChild("application-desc");
        if (Application2 == null) {
            this.Root.addContent(new Comment("This starts-up Cytoscape, specify your plugins to load, and other command line arguments.  Plugins not specified here will not be loaded."));
            Application2 = new Element("application-desc").setAttribute("main-class", "cytoscape.CyMain");
            this.Root.addContent(Application2);
        }
        for (int i = 0; i < Args.size(); ++i) {
            Application2.addContent(new Element("argument").setText("-p"));
            Application2.addContent(new Element("argument").setText(Args.get(i)));
        }
    }
}

