/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.writers;

import cytoscape.data.CyAttributes;
import cytoscape.data.attr.CountedIterator;
import cytoscape.data.attr.MultiHashMap;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;

public class CyAttributesWriter2 {
    public static String newline = System.getProperty("line.separator");
    private final CyAttributes cyAttributes;
    private final String attributeName;
    private final Writer fileWriter;

    public CyAttributesWriter2(CyAttributes attributes, String attributeName, Writer fileWriter) {
        this.cyAttributes = attributes;
        this.attributeName = attributeName;
        this.fileWriter = fileWriter;
    }

    public void writeAttributes() throws IOException {
        MultiHashMap attributeMap = this.cyAttributes.getMultiHashMap();
        if (attributeMap != null) {
            CountedIterator keys = this.cyAttributes.getMultiHashMap().getObjectKeys(this.attributeName);
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = attributeMap.getAttributeValue(key, this.attributeName, null);
                if (value == null) continue;
                if (value instanceof Collection) {
                    String result = key + " = ";
                    Collection collection = (Collection)value;
                    if (collection.size() <= 0) continue;
                    Iterator objIt = collection.iterator();
                    result = result + "(" + objIt.next();
                    while (objIt.hasNext()) {
                        result = result + "::" + objIt.next();
                    }
                    result = result + ")" + newline;
                    this.fileWriter.write(result);
                    continue;
                }
                this.fileWriter.write(key + " = " + value + newline);
            }
            this.fileWriter.flush();
        }
    }
}

