/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.servers.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

class PreviewTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private Font selectedFont = new Font("Sans-serif", 1, 12);
    private int col = 0;

    public PreviewTableCellRenderer(int col) {
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.col = col;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else if (column == this.col) {
            this.setForeground(Color.RED);
            this.setFont(this.selectedFont);
        } else {
            this.setForeground(Color.BLACK);
            super.setBackground(table.getBackground());
            this.setFont(table.getFont());
        }
        this.setHorizontalAlignment(2);
        if (column == 1) {
            String newValue = "";
            String[] synonym = value.toString().split("\\|");
            for (int i = 0; i < synonym.length; ++i) {
                newValue = newValue + synonym[i];
                if (i == synonym.length - 1) continue;
                newValue = newValue + ",  ";
            }
            this.setText(value == null ? "" : newValue.toString());
        } else {
            this.setText(value == null ? "" : value.toString());
        }
        return this;
    }
}

